/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.units;

import com.flansmod.physics.common.units.AngularVelocity;
import com.flansmod.physics.common.units.IVelocity;
import com.flansmod.physics.common.units.Units;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.Transform;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec3;

public record LinearVelocity(@Nonnull Vec3 Velocity) implements IVelocity
{
    public static final LinearVelocity Zero = new LinearVelocity(Vec3.f_82478_);

    @Nonnull
    public static LinearVelocity blocksPerSecond(@Nonnull Vec3 blocksPerSec) {
        return new LinearVelocity(Units.Speed.BlocksPerSecond_To_BlocksPerTick(blocksPerSec));
    }

    @Nonnull
    public static LinearVelocity blocksPerTick(@Nonnull Vec3 blocksPerTick) {
        return new LinearVelocity(blocksPerTick);
    }

    @Nonnull
    public LinearVelocity add(@Nonnull LinearVelocity other) {
        return new LinearVelocity(this.Velocity.m_82549_(other.Velocity));
    }

    @Nonnull
    public LinearVelocity subtract(@Nonnull LinearVelocity other) {
        return new LinearVelocity(this.Velocity.m_82546_(other.Velocity));
    }

    @Nonnull
    public LinearVelocity scale(double scale) {
        return new LinearVelocity(this.Velocity.m_82490_(scale));
    }

    @Nonnull
    public static LinearVelocity interpolate(LinearVelocity a, LinearVelocity b, double t) {
        return new LinearVelocity(a.Velocity.m_165921_(b.Velocity, t));
    }

    @Nonnull
    public static LinearVelocity average(LinearVelocity ... velocities) {
        if (velocities.length == 0) {
            return Zero;
        }
        Vec3 sum = Vec3.f_82478_;
        for (LinearVelocity v : velocities) {
            sum = sum.m_82549_(v.Velocity);
        }
        return new LinearVelocity(sum.m_82490_(1.0 / (double)velocities.length));
    }

    @Nonnull
    public Units.Speed getDefaultUnits() {
        return Units.Speed.BlocksPerTick;
    }

    @Nonnull
    public Vec3 convertToUnits(@Nonnull Units.Speed toUnits) {
        return Units.Speed.Convert(this.Velocity, Units.Speed.BlocksPerTick, toUnits);
    }

    @Nonnull
    public Vec3 applyOverTicks(double ticks) {
        return this.Velocity.m_82490_(ticks);
    }

    @Nonnull
    public Vec3 applyOneTick() {
        return this.Velocity;
    }

    @Override
    @Nonnull
    public LinearVelocity inverse() {
        return new LinearVelocity(this.Velocity.m_82490_(-1.0));
    }

    @Override
    public boolean isApproxZero() {
        return this.Velocity.m_82556_() < 9.999999999999998E-15;
    }

    @Override
    public boolean hasLinearComponent(@Nonnull Transform actingOn) {
        return false;
    }

    @Override
    @Nonnull
    public LinearVelocity getLinearComponent(@Nonnull Transform actingOn) {
        return this;
    }

    @Override
    public boolean hasAngularComponent(@Nonnull Transform actingOn) {
        return true;
    }

    @Override
    @Nonnull
    public AngularVelocity getAngularComponent(@Nonnull Transform actingOn) {
        return AngularVelocity.Zero;
    }

    @Override
    public String toString() {
        return "LinearVelocity [" + this.Velocity + "]";
    }

    @Override
    @Nonnull
    public Component toFancyString() {
        return Component.m_237110_((String)"flansphysics.linear_velocity", (Object[])new Object[]{this.Velocity.f_82479_, this.Velocity.f_82480_, this.Velocity.f_82481_});
    }

    public boolean isApprox(@Nonnull LinearVelocity other) {
        return Maths.approx(other.Velocity, this.Velocity);
    }

    public boolean isApprox(@Nonnull LinearVelocity other, double epsilon) {
        return Maths.approx(other.Velocity, this.Velocity, epsilon);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof LinearVelocity) {
            LinearVelocity otherLinearV = (LinearVelocity)other;
            return otherLinearV.Velocity.equals((Object)this.Velocity);
        }
        return false;
    }

    public void toBuf(@Nonnull FriendlyByteBuf buf) {
        buf.m_269582_(this.Velocity.m_252839_());
    }

    @Nonnull
    public static LinearVelocity fromBuf(@Nonnull FriendlyByteBuf buf) {
        return new LinearVelocity(new Vec3(buf.m_269394_()));
    }
}

