/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.units;

import com.flansmod.physics.common.units.IForce;
import com.flansmod.physics.common.units.LinearAcceleration;
import com.flansmod.physics.common.units.Torque;
import com.flansmod.physics.common.units.Units;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.Transform;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.NotImplementedException;

public record LinearForce(@Nonnull Vec3 Force) implements IForce
{
    public static final LinearForce Zero = new LinearForce(Vec3.f_82478_);

    @Nonnull
    public static LinearForce kgBlocksPerSecondSq(@Nonnull Vec3 kgBlocksPerSecSq) {
        return new LinearForce(Units.Force.KgBlocksPerSecondSq_To_KgBlocksPerTickSq(kgBlocksPerSecSq));
    }

    @Nonnull
    public static LinearForce kgBlocksPerTickSq(@Nonnull Vec3 kgBlocksPerTickSq) {
        return new LinearForce(kgBlocksPerTickSq);
    }

    @Nonnull
    public LinearForce add(@Nonnull LinearForce other) {
        return new LinearForce(this.Force.m_82549_(other.Force));
    }

    @Nonnull
    public Units.Force getDefaultUnits() {
        return Units.Force.KgBlocksPerTickSquared;
    }

    @Nonnull
    public Vec3 convertToUnits(@Nonnull Units.Force toUnits) {
        return Units.Force.Convert(this.Force, Units.Force.KgBlocksPerTickSquared, toUnits);
    }

    @Nonnull
    public LinearAcceleration actingOn(double mass) {
        return new LinearAcceleration(this.Force.m_82490_(1.0 / mass));
    }

    @Override
    public boolean isApproxZero() {
        return this.Force.m_82556_() < 9.999999999999998E-15;
    }

    @Override
    @Nonnull
    public LinearForce inverse() {
        return new LinearForce(this.Force.m_82490_(-1.0));
    }

    @Override
    public boolean hasLinearComponent(@Nonnull Transform actingOn) {
        return true;
    }

    @Override
    @Nonnull
    public LinearForce getLinearComponent(@Nonnull Transform actingOn) {
        return this;
    }

    @Override
    public boolean hasAngularComponent(@Nonnull Transform actingOn) {
        return false;
    }

    @Override
    @Nonnull
    public Torque getTorqueComponent(@Nonnull Transform actingOn) {
        throw new NotImplementedException();
    }

    @Override
    public String toString() {
        return "LinearForce [" + this.Force + "]";
    }

    @Override
    @Nonnull
    public Component toFancyString() {
        return Component.m_237110_((String)"flansphysics.linear_force", (Object[])new Object[]{this.Force.f_82479_, this.Force.f_82480_, this.Force.f_82481_});
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof LinearForce) {
            LinearForce otherForce = (LinearForce)other;
            return otherForce.Force.equals((Object)this.Force);
        }
        return false;
    }

    public boolean isApprox(@Nonnull LinearForce other) {
        return Maths.approx(other.Force, this.Force);
    }

    public boolean isApprox(@Nonnull LinearForce other, double epsilon) {
        return Maths.approx(other.Force, this.Force, epsilon);
    }
}

