/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.units;

import com.flansmod.physics.common.units.AngularAcceleration;
import com.flansmod.physics.common.units.IAcceleration;
import com.flansmod.physics.common.units.LinearForce;
import com.flansmod.physics.common.units.LinearVelocity;
import com.flansmod.physics.common.units.Units;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.Transform;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec3;

public record LinearAcceleration(@Nonnull Vec3 Acceleration) implements IAcceleration
{
    public static final LinearAcceleration Zero = new LinearAcceleration(Vec3.f_82478_);

    @Nonnull
    public static LinearAcceleration blocksPerSecondSq(@Nonnull Vec3 blocksPerSecSq) {
        return new LinearAcceleration(Units.Acceleration.BlocksPerSecondSq_To_BlocksPerTickSq(blocksPerSecSq));
    }

    @Nonnull
    public static LinearAcceleration blocksPerTickSq(@Nonnull Vec3 blocksPerTickSq) {
        return new LinearAcceleration(blocksPerTickSq);
    }

    @Nonnull
    public static LinearAcceleration fromUtoVinSeconds(@Nonnull LinearVelocity u, @Nonnull LinearVelocity v, double seconds) {
        if (Maths.approx(seconds, 0.0)) {
            return Zero;
        }
        Vec3 uPerS = u.convertToUnits(Units.Speed.BlocksPerSecond);
        Vec3 vPerS = v.convertToUnits(Units.Speed.BlocksPerSecond);
        return LinearAcceleration.blocksPerSecondSq(vPerS.m_82546_(uPerS).m_82490_(1.0 / seconds));
    }

    @Nonnull
    public static LinearAcceleration fromUtoVinTicks(@Nonnull LinearVelocity u, @Nonnull LinearVelocity v, int ticks) {
        if (ticks == 0) {
            return Zero;
        }
        Vec3 uPerT = u.convertToUnits(Units.Speed.BlocksPerTick);
        Vec3 vPerT = v.convertToUnits(Units.Speed.BlocksPerTick);
        return LinearAcceleration.blocksPerTickSq(vPerT.m_82546_(uPerT).m_82490_(1.0 / (double)ticks));
    }

    @Nonnull
    public static LinearAcceleration reaction(@Nonnull LinearVelocity inputV, @Nonnull LinearVelocity resultV) {
        return LinearAcceleration.fromUtoVinTicks(inputV, resultV, 1);
    }

    @Nonnull
    public LinearAcceleration add(@Nonnull LinearAcceleration other) {
        return new LinearAcceleration(this.Acceleration.m_82549_(other.Acceleration));
    }

    @Nonnull
    public Vec3 getTicksPerSecondSq() {
        return this.Acceleration;
    }

    @Nonnull
    public Vec3 getBlocksPerSecondSq() {
        return this.getInUnits(Units.Acceleration.BlocksPerSecondSquared);
    }

    @Nonnull
    public LinearForce multiplyBy(double mass) {
        return new LinearForce(this.Acceleration.m_82490_(mass));
    }

    @Nonnull
    public Units.Acceleration getDefaultUnits() {
        return Units.Acceleration.BlocksPerTickSquared;
    }

    @Nonnull
    public Vec3 getInUnits(@Nonnull Units.Acceleration toUnit) {
        return Units.Acceleration.Convert(this.Acceleration, Units.Acceleration.BlocksPerTickSquared, toUnit);
    }

    @Nonnull
    public LinearVelocity applyOverTicks(double ticks) {
        return new LinearVelocity(this.Acceleration.m_82490_(ticks));
    }

    @Nonnull
    public LinearVelocity applyOneTick() {
        return new LinearVelocity(this.Acceleration);
    }

    @Override
    @Nonnull
    public LinearAcceleration inverse() {
        return new LinearAcceleration(this.Acceleration.m_82490_(-1.0));
    }

    @Override
    public boolean isApproxZero() {
        return this.Acceleration.m_82556_() < 9.999999999999998E-15;
    }

    @Override
    public boolean hasLinearComponent(@Nonnull Transform actingOn) {
        return true;
    }

    @Override
    @Nonnull
    public LinearAcceleration getLinearComponent(@Nonnull Transform actingOn) {
        return this;
    }

    @Override
    public boolean hasAngularComponent(@Nonnull Transform actingOn) {
        return false;
    }

    @Override
    @Nonnull
    public AngularAcceleration getAngularComponent(@Nonnull Transform actingOn) {
        return AngularAcceleration.Zero;
    }

    @Override
    public String toString() {
        return "LinearAcceleration [" + this.Acceleration + "] blocks/tick^2";
    }

    @Override
    @Nonnull
    public Component toFancyString() {
        return Component.m_237110_((String)"flansphysics.linear_acceleration", (Object[])new Object[]{this.Acceleration.f_82479_, this.Acceleration.f_82480_, this.Acceleration.f_82481_});
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof LinearAcceleration) {
            LinearAcceleration otherLinearA = (LinearAcceleration)other;
            return otherLinearA.Acceleration.equals((Object)this.Acceleration);
        }
        return false;
    }

    public boolean isApprox(@Nonnull LinearAcceleration other) {
        return Maths.approx(other.Acceleration, this.Acceleration);
    }

    public boolean isApprox(@Nonnull LinearAcceleration other, double epsilon) {
        return Maths.approx(other.Acceleration, this.Acceleration, epsilon);
    }
}

