/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.units;

import com.flansmod.physics.common.units.CompoundAcceleration;
import com.flansmod.physics.common.units.IForce;
import com.flansmod.physics.common.units.LinearForce;
import com.flansmod.physics.common.units.Torque;
import com.flansmod.physics.common.util.Transform;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec3;

public record CompoundForce(@Nonnull LinearForce linear, @Nonnull Torque angular) implements IForce
{
    public static final CompoundForce Zero = new CompoundForce(LinearForce.Zero, Torque.Zero);

    @Nonnull
    public static CompoundForce of(@Nonnull LinearForce linear, @Nonnull Torque angular) {
        return new CompoundForce(linear, angular);
    }

    @Nonnull
    public CompoundAcceleration applyTo(double mass, @Nonnull Vec3 momentOfInertia) {
        return this.applyTo(mass, momentOfInertia, Transform.IDENTITY);
    }

    @Nonnull
    public CompoundAcceleration applyTo(double mass, @Nonnull Vec3 momentOfInertia, @Nonnull Transform actingOn) {
        return CompoundAcceleration.of(this.getLinearComponent(actingOn).actingOn(mass), this.getTorqueComponent(actingOn).actingOnMomentOfInertia(momentOfInertia));
    }

    @Override
    @Nonnull
    public CompoundForce inverse() {
        return new CompoundForce(this.linear.inverse(), this.angular.inverse());
    }

    @Override
    public boolean isApproxZero() {
        return this.linear.isApproxZero() && this.angular.isApproxZero();
    }

    @Override
    public boolean hasLinearComponent(@Nonnull Transform actingOn) {
        return true;
    }

    @Override
    @Nonnull
    public LinearForce getLinearComponent(@Nonnull Transform actingOn) {
        return this.linear;
    }

    @Override
    public boolean hasAngularComponent(@Nonnull Transform actingOn) {
        return true;
    }

    @Override
    @Nonnull
    public Torque getTorqueComponent(@Nonnull Transform actingOn) {
        return this.angular;
    }

    @Override
    public String toString() {
        return "CompoundForce [" + this.linear + "] at [" + this.angular + "]";
    }

    @Override
    @Nonnull
    public Component toFancyString() {
        return Component.m_237110_((String)"flansphysics.compound_force", (Object[])new Object[]{this.linear.Force().f_82479_, this.linear.Force().f_82480_, this.linear.Force().f_82481_, this.angular.Magnitude(), this.angular.Axis().f_82479_, this.angular.Axis().f_82480_, this.angular.Axis().f_82481_});
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof CompoundForce) {
            CompoundForce otherCompound = (CompoundForce)other;
            return otherCompound.linear.equals(this.linear) && otherCompound.angular.equals(this.angular);
        }
        return false;
    }

    public boolean isApprox(@Nonnull CompoundForce other) {
        return this.linear.isApprox(other.linear) && this.angular.isApprox(other.angular);
    }

    public boolean isApprox(@Nonnull CompoundForce other, double epsilon) {
        return this.linear.isApprox(other.linear, epsilon) && this.angular.isApprox(other.angular, epsilon);
    }
}

