/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.units;

import com.flansmod.physics.common.units.AngularAcceleration;
import com.flansmod.physics.common.units.CompoundForce;
import com.flansmod.physics.common.units.CompoundVelocity;
import com.flansmod.physics.common.units.IAcceleration;
import com.flansmod.physics.common.units.LinearAcceleration;
import com.flansmod.physics.common.util.Transform;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec3;

public record CompoundAcceleration(@Nonnull LinearAcceleration linear, @Nonnull AngularAcceleration angular) implements IAcceleration
{
    public static final CompoundAcceleration Zero = new CompoundAcceleration(LinearAcceleration.Zero, AngularAcceleration.Zero);

    @Nonnull
    public static CompoundAcceleration of(@Nonnull LinearAcceleration linear, @Nonnull AngularAcceleration angular) {
        return new CompoundAcceleration(linear, angular);
    }

    @Nonnull
    public CompoundVelocity applyOneTick() {
        return this.applyOneTick(Transform.IDENTITY);
    }

    @Nonnull
    public CompoundVelocity applyOneTick(@Nonnull Transform actingOn) {
        return CompoundVelocity.of(this.getLinearComponent(actingOn).applyOneTick(), this.getAngularComponent(actingOn).applyOneTick());
    }

    @Nonnull
    public CompoundForce asForceForPointMass(double mass) {
        return CompoundForce.of(this.linear.multiplyBy(mass), this.angular.asTorqueForPointMass(mass));
    }

    @Nonnull
    public CompoundForce asForceForMass(double mass, @Nonnull Vec3 momentOfInertia) {
        return CompoundForce.of(this.linear.multiplyBy(mass), this.angular.asTorqueForSpinMass(momentOfInertia));
    }

    @Override
    @Nonnull
    public CompoundAcceleration inverse() {
        return new CompoundAcceleration(this.linear.inverse(), this.angular.inverse());
    }

    @Override
    public boolean isApproxZero() {
        return this.linear.isApproxZero() && this.angular.isApproxZero();
    }

    @Override
    public boolean hasLinearComponent(@Nonnull Transform actingOn) {
        return true;
    }

    @Override
    @Nonnull
    public LinearAcceleration getLinearComponent(@Nonnull Transform actingOn) {
        return this.linear;
    }

    @Override
    public boolean hasAngularComponent(@Nonnull Transform actingOn) {
        return true;
    }

    @Override
    @Nonnull
    public AngularAcceleration getAngularComponent(@Nonnull Transform actingOn) {
        return this.angular;
    }

    @Override
    public String toString() {
        return "CompoundAcceleration [" + this.linear + "] at [" + this.angular + "]";
    }

    @Override
    @Nonnull
    public Component toFancyString() {
        return Component.m_237110_((String)"flansphysics.compound_acceleration", (Object[])new Object[]{this.linear.Acceleration().f_82479_, this.linear.Acceleration().f_82480_, this.linear.Acceleration().f_82481_, this.angular.Magnitude(), this.angular.Axis().f_82479_, this.angular.Axis().f_82480_, this.angular.Axis().f_82481_});
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof CompoundAcceleration) {
            CompoundAcceleration otherCompound = (CompoundAcceleration)other;
            return otherCompound.linear.equals(this.linear) && otherCompound.angular.equals(this.angular);
        }
        return false;
    }

    public boolean isApprox(@Nonnull CompoundAcceleration other) {
        return this.linear.isApprox(other.linear) && this.angular.isApprox(other.angular);
    }

    public boolean isApprox(@Nonnull CompoundAcceleration other, double epsilon) {
        return this.linear.isApprox(other.linear, epsilon) && this.angular.isApprox(other.angular, epsilon);
    }
}

