/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.tests;

import com.flansmod.physics.common.FlansPhysicsMod;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.Transform;
import com.flansmod.physics.common.util.TransformStack;
import javax.annotation.Nonnull;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class TransformTests {
    private static final float Epsilon = 0.03f;

    public static void runTests() {
        Vector3f eulerYaw90 = new Vector3f(0.0f, 90.0f, 0.0f);
        Vector3f eulerYaw135 = new Vector3f(0.0f, 135.0f, 0.0f);
        Vector3f eulerPitchUp90 = new Vector3f(-90.0f, 0.0f, 0.0f);
        Vector3f eulerPitchDown45 = new Vector3f(45.0f, 0.0f, 0.0f);
        Vector3f eulerPitchDown90 = new Vector3f(90.0f, 0.0f, 0.0f);
        Vector3f eulerRollLeft45 = new Vector3f(0.0f, 0.0f, -45.0f);
        Vector3f eulerRollRight45 = new Vector3f(0.0f, 0.0f, 45.0f);
        Vector3f eulerRollRight60 = new Vector3f(0.0f, 0.0f, 60.0f);
        Vector3f eulerRollRight90 = new Vector3f(0.0f, 0.0f, 90.0f);
        Quaternionf yaw90 = Transform.quatFromEuler(eulerYaw90);
        Quaternionf yaw135 = Transform.quatFromEuler(eulerYaw135);
        Quaternionf pitchUp90 = Transform.quatFromEuler(eulerPitchUp90);
        Quaternionf pitchDown45 = Transform.quatFromEuler(eulerPitchDown45);
        Quaternionf pitchDown90 = Transform.quatFromEuler(eulerPitchDown90);
        Quaternionf rollLeft45 = Transform.quatFromEuler(eulerRollLeft45);
        Quaternionf rollRight45 = Transform.quatFromEuler(eulerRollRight45);
        Quaternionf rollRight60 = Transform.quatFromEuler(eulerRollRight60);
        Quaternionf rollRight90 = Transform.quatFromEuler(eulerRollRight90);
        TransformTests.assertEqual(eulerYaw90, Transform.toEuler(yaw90), "ToEuler != FromEuler^-1");
        TransformTests.assertEqual(eulerYaw135, Transform.toEuler(yaw135), "ToEuler != FromEuler^-1");
        TransformTests.assertEqual(eulerPitchUp90, Transform.toEuler(pitchUp90), "ToEuler != FromEuler^-1");
        TransformTests.assertEqual(eulerPitchDown45, Transform.toEuler(pitchDown45), "ToEuler != FromEuler^-1");
        TransformTests.assertEqual(eulerPitchDown90, Transform.toEuler(pitchDown90), "ToEuler != FromEuler^-1");
        TransformTests.assertEqual(eulerRollRight60, Transform.toEuler(rollRight60), "ToEuler != FromEuler^-1");
        TransformTests.assertEqual(eulerRollLeft45, Transform.toEuler(rollLeft45), "ToEuler != FromEuler^-1");
        TransformTests.assertEqual(eulerRollRight45, Transform.toEuler(rollRight45), "ToEuler != FromEuler^-1");
        TransformTests.assertEqual(eulerRollRight90, Transform.toEuler(rollRight90), "ToEuler != FromEuler^-1");
        Vector3f eulerYaw90Pitch45 = new Vector3f(45.0f, 90.0f, 0.0f);
        Vector3f eulerYaw90Pitch45Roll45 = new Vector3f(45.0f, 90.0f, 45.0f);
        Vector3f eulerPitch45Roll60 = new Vector3f(45.0f, 0.0f, 60.0f);
        Quaternionf yaw90Pitch45 = Transform.quatFromEuler(eulerYaw90Pitch45);
        Quaternionf yaw90Pitch45Roll45 = Transform.quatFromEuler(eulerYaw90Pitch45Roll45);
        Quaternionf pitch45Roll60 = Transform.quatFromEuler(eulerPitch45Roll60);
        TransformTests.assertEqual(eulerYaw90Pitch45, Transform.toEuler(yaw90Pitch45), "ToEuler != FromEuler^-1");
        TransformTests.assertEqual(eulerYaw90Pitch45Roll45, Transform.toEuler(yaw90Pitch45Roll45), "ToEuler != FromEuler^-1");
        TransformTests.assertEqual(eulerPitch45Roll60, Transform.toEuler(pitch45Roll60), "ToEuler != FromEuler^-1");
        Vector3f mcNorth = new Vector3f(0.0f, 0.0f, -1.0f);
        Vector3f mcEast = new Vector3f(1.0f, 0.0f, 0.0f);
        Vector3f mcSouth = new Vector3f(0.0f, 0.0f, 1.0f);
        Vector3f mcWest = new Vector3f(-1.0f, 0.0f, 0.0f);
        Vector3f mcUp = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f mcDown = new Vector3f(0.0f, -1.0f, 0.0f);
        TransformTests.assertEqual(Transform.rotate(mcSouth, yaw90), mcWest, "South * Yaw90 != West");
        TransformTests.assertEqual(Transform.rotate(mcWest, yaw90), mcNorth, "West * Yaw90 != North");
        TransformTests.assertEqual(Transform.rotate(mcNorth, yaw90), mcEast, "North * Yaw90 != East");
        TransformTests.assertEqual(Transform.rotate(mcEast, yaw90), mcSouth, "East * Yaw90 != South");
        TransformTests.assertEqual(Transform.rotate(mcUp, yaw90), mcUp, "Up * Yaw90 != Up");
        TransformTests.assertEqual(Transform.rotate(mcDown, yaw90), mcDown, "Down * Yaw90 != Down");
        TransformTests.assertEqual(Transform.rotate(mcNorth, pitchUp90), mcUp, "North * PitchUp90 != Up");
        TransformTests.assertEqual(Transform.rotate(mcEast, pitchUp90), mcEast, "East * PitchUp90 != East");
        TransformTests.assertEqual(Transform.rotate(mcUp, pitchUp90), mcSouth, "Up * PitchUp90 != South");
        TransformTests.assertEqual(Transform.rotate(mcNorth, pitchDown90), mcDown, "North * PitchDown90 != Down");
        TransformTests.assertEqual(Transform.rotate(mcEast, pitchDown90), mcEast, "East * PitchDown90 != East");
        TransformTests.assertEqual(Transform.rotate(mcUp, pitchDown90), mcNorth, "Up * PitchDown90 != North");
        TransformTests.assertEqual(Transform.rotate(mcNorth, rollRight90), mcNorth, "North * RollRight90 != North");
        TransformTests.assertEqual(Transform.rotate(mcEast, rollRight90), mcDown, "East * PitchDown90 != Down");
        TransformTests.assertEqual(Transform.rotate(mcUp, rollRight90), mcEast, "Up * PitchDown90 != East");
        Vector3f mcDownNorth = new Vector3f(0.0f, -Maths.cosF(0.7853982f), -Maths.sinF(0.7853982f));
        Vector3f mcDownEast = new Vector3f(Maths.sinF(0.7853982f), -Maths.cosF(0.7853982f), 0.0f);
        TransformTests.assertEqual(Transform.rotate(mcNorth, pitchDown45), mcDownNorth, "Pitch north not as expected");
        TransformTests.assertEqual(Transform.rotate(Transform.rotate(mcNorth, pitchDown45), yaw90), mcDownEast, "Pitch east not as expected");
        TransformTests.assertEqual(yaw90Pitch45.transform((Vector3fc)mcNorth, new Vector3f()), yaw90.transform((Vector3fc)pitchDown45.transform((Vector3fc)mcNorth, new Vector3f()), new Vector3f()), "YawPitch composition incorrect");
        TransformTests.assertEqual(Transform.compose(pitchDown45, yaw90), yaw90Pitch45, "Composition unexpected");
        TransformTests.assertEqual(Transform.compose(rollRight45, pitchDown45, yaw90), yaw90Pitch45Roll45, "Composition unexpected");
        TransformTests.assertEqual(Transform.compose(rollRight60, pitchDown45), pitch45Roll60, "Composition unexpected");
        TransformTests.assertEqual(Transform.IDENTITY.forward(), mcNorth, "IDENTITY.Forward() not North");
        TransformTests.assertEqual(Transform.IDENTITY.up(), mcUp, "IDENTITY.Up() not Up");
        TransformTests.assertEqual(Transform.IDENTITY.right(), mcEast, "IDENTITY.Right() not East");
        Transform offsetXAxis = Transform.fromPos(1.0, 0.0, 0.0);
        Transform offsetYAxis = Transform.fromPos(0.0, 1.0, 0.0);
        Transform offsetZAxis = Transform.fromPos(0.0, 0.0, 1.0);
        TransformTests.verifyCommutative(offsetXAxis, offsetYAxis);
        TransformTests.verifyCommutative(offsetXAxis, offsetZAxis);
        TransformTests.verifyAssociative(offsetXAxis, offsetYAxis, offsetZAxis);
        Transform tYaw90 = Transform.fromEuler(eulerYaw90);
        Transform tYaw135 = Transform.fromEuler(eulerYaw135);
        Transform tPitchUp90 = Transform.fromEuler(eulerPitchUp90);
        Transform tPitchDown45 = Transform.fromEuler(eulerPitchDown45);
        Transform tRollRight45 = Transform.fromEuler(eulerRollRight45);
        Transform tRollRight90 = Transform.fromEuler(eulerRollRight90);
        TransformTests.assertEqual(TransformStack.of(tYaw90, tYaw90, tYaw90, tYaw90).top(), Transform.IDENTITY, "4 turns != identity");
        TransformTests.verifyAssociative(tRollRight45, tPitchUp90, tYaw90);
        TransformTests.verifyCommutative(tYaw90, tYaw135);
        TransformTests.verifyCommutative(tRollRight45, tRollRight90);
        TransformTests.verifyCommutative(tPitchUp90, tPitchDown45);
        TransformTests.verifyCommutative(offsetXAxis, tPitchUp90);
        TransformTests.verifyCommutative(offsetYAxis, tYaw90);
        TransformTests.verifyCommutative(offsetZAxis, tRollRight45);
        TransformTests.assertEqual(Transform.fromLookDirection(tYaw90.forward(), tYaw90.up()), tYaw90, "Look along failed");
        TransformTests.assertEqual(Transform.fromLookDirection(tPitchDown45.forward(), tPitchDown45.up()), tPitchDown45, "Look along failed");
        TransformTests.assertEqual(Transform.fromLookDirection(tRollRight90.forward(), tRollRight90.up()), tRollRight90, "Look along failed");
        Transform flipTest = Transform.fromPosAndEuler(new Vec3(30.0, 31.3, -12.0), 45.0f, 43.0f, 13.0f);
        TransformTests.assertEqual(flipTest, flipTest.reflect(true, false, false).reflect(true, false, false), "FlipX not self-inverse");
        TransformTests.assertEqual(flipTest, flipTest.reflect(false, true, false).reflect(false, true, false), "FlipY not self-inverse");
        TransformTests.assertEqual(flipTest, flipTest.reflect(false, false, true).reflect(false, false, true), "FlipZ not self-inverse");
        Transform composed = TransformStack.of(tYaw90, tRollRight45, tPitchDown45).top();
        TransformTests.assertEqual(Transform.fromLookDirection(composed.forward(), composed.up()), composed, "Look along failed");
    }

    private static void verifyAssociative(@Nonnull Transform a, @Nonnull Transform b, @Nonnull Transform c) {
        TransformTests.assertEqual(TransformStack.of(TransformStack.of(a, b).top(), c).top(), TransformStack.of(a, TransformStack.of(b, c).top()).top(), "Transforms not associative");
    }

    private static void verifyCommutative(@Nonnull Transform a, @Nonnull Transform b) {
        TransformTests.assertEqual(TransformStack.of().and(a).and(b).top(), TransformStack.of().and(b).and(a).top(), "Transforms not commutative");
    }

    private static void assertEqual(@Nonnull Transform a, @Nonnull Transform b, @Nonnull String error) {
        Vector3f eulerA = Transform.toEuler(a.Orientation);
        Vector3f eulerB = Transform.toEuler(b.Orientation);
        if (!(Maths.approx(eulerA.x, eulerB.x, 0.03f) && Maths.approx(eulerA.y, eulerB.y, 0.03f) && Maths.approx(eulerA.z, eulerB.z, 0.03f) && Maths.approx(a.Position.x, b.Position.x, (double)0.03f) && Maths.approx(a.Position.y, b.Position.y, (double)0.03f) && Maths.approx(a.Position.z, b.Position.z, (double)0.03f) && Maths.approx(a.Scale.x, b.Scale.x, 0.03f) && Maths.approx(a.Scale.y, b.Scale.y, 0.03f) && Maths.approx(a.Scale.z, b.Scale.z, 0.03f))) {
            FlansPhysicsMod.LOGGER.error(error);
        }
    }

    private static void assertEqual(@Nonnull Quaternionf a, @Nonnull Quaternionf b, @Nonnull String error) {
        if (!(Maths.approx(a.x, b.x, 0.03f) && Maths.approx(a.y, b.y, 0.03f) && Maths.approx(a.z, b.z, 0.03f) && Maths.approx(a.w, b.w, 0.03f))) {
            Vector3f eulerA = Transform.toEuler(a);
            Vector3f eulerB = Transform.toEuler(b);
            FlansPhysicsMod.LOGGER.error(error + ":" + eulerA + "," + eulerB);
        }
    }

    private static void assertEqual(@Nonnull Vec3 a, @Nonnull Vec3 b, @Nonnull String error) {
        if (!(Maths.approx(a.f_82479_, b.f_82479_, (double)0.03f) && Maths.approx(a.f_82480_, b.f_82480_, (double)0.03f) && Maths.approx(a.f_82481_, b.f_82481_, (double)0.03f))) {
            FlansPhysicsMod.LOGGER.error(error);
        }
    }

    private static void assertEqual(@Nonnull Vec3 a, @Nonnull Vector3f b, @Nonnull String error) {
        if (!(Maths.approx(a.f_82479_, (double)b.x, (double)0.03f) && Maths.approx(a.f_82480_, (double)b.y, (double)0.03f) && Maths.approx(a.f_82481_, (double)b.z, (double)0.03f))) {
            FlansPhysicsMod.LOGGER.error(error);
        }
    }

    private static void assertEqual(@Nonnull Vector3f a, @Nonnull Vector3f b, @Nonnull String error) {
        if (!(Maths.approx(a.x, b.x, 0.03f) && Maths.approx(a.y, b.y, 0.03f) && Maths.approx(a.z, b.z, 0.03f))) {
            FlansPhysicsMod.LOGGER.error(error);
        }
    }

    private static void assertEqual(float a, float b, @Nonnull String error) {
        if (!Maths.approx(a, b, 0.03f)) {
            FlansPhysicsMod.LOGGER.error(error);
        }
    }
}

