/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.deprecated;

import com.flansmod.physics.common.units.AngularAcceleration;
import com.flansmod.physics.common.units.IForce;
import com.flansmod.physics.common.units.LinearAcceleration;
import com.flansmod.physics.common.units.LinearForce;
import com.flansmod.physics.common.units.LinearVelocity;
import com.flansmod.physics.common.units.Torque;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.Transform;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.phys.Vec3;

public class ForcesOnPart {
    private final List<IForce> forces = new ArrayList<IForce>();
    private final List<IForce> reactionForces = new ArrayList<IForce>();
    public float dampening = 1.0f;

    public void endFrame() {
        this.reactionForces.clear();
        this.forces.clear();
        this.dampening = 1.0f;
    }

    @Nonnull
    public List<IForce> debug_GetForces() {
        return this.forces;
    }

    @Nonnull
    public List<IForce> debug_GetReactionForces() {
        return this.reactionForces;
    }

    public void addReactionForce(@Nonnull IForce force) {
        this.reactionForces.add(force);
    }

    public void addForce(@Nonnull IForce force) {
        this.forces.add(force);
    }

    public void addDampener(float dampening) {
        this.dampening *= 1.0f - Maths.clamp(dampening, 0.0f, 1.0f);
    }

    public float getDampeningRatio() {
        return this.dampening;
    }

    @Nonnull
    public LinearVelocity applyLinearAcceleration(@Nonnull LinearVelocity motion, @Nonnull Transform partTransform, float mass, boolean includeReactions) {
        return motion.add(this.sumLinearAcceleration(partTransform, mass, includeReactions).applyOneTick());
    }

    @Nonnull
    public LinearAcceleration sumLinearAcceleration(@Nonnull Transform partTransform, double mass, boolean includeReactions) {
        return this.sumLinearForces(partTransform, includeReactions).actingOn(mass);
    }

    @Nonnull
    public LinearForce sumLinearForces(@Nonnull Transform partTransform, boolean includeReactions) {
        LinearForce motion = LinearForce.Zero;
        for (IForce force : this.forces) {
            if (!force.hasLinearComponent(partTransform)) continue;
            motion = motion.add(force.getLinearComponent(partTransform));
        }
        if (includeReactions) {
            for (IForce force : this.reactionForces) {
                if (!force.hasLinearComponent(partTransform)) continue;
                motion = motion.add(force.getLinearComponent(partTransform));
            }
        }
        return motion;
    }

    @Nonnull
    public AngularAcceleration sumAngularAcceleration(@Nonnull Transform partTransform, @Nonnull Vec3 momentOfInertia, boolean includeReactions) {
        return this.sumTorque(partTransform, includeReactions).actingOnMomentOfInertia(momentOfInertia);
    }

    @Nonnull
    public Torque sumTorque(@Nonnull Transform partTransform, boolean includeReactions) {
        Torque sum = Torque.Zero;
        for (IForce force : this.forces) {
            if (!force.hasAngularComponent(partTransform)) continue;
            sum = sum.compose(force.getTorqueComponent(partTransform));
        }
        if (includeReactions) {
            for (IForce force : this.reactionForces) {
                if (!force.hasAngularComponent(partTransform)) continue;
                sum = sum.compose(force.getTorqueComponent(partTransform));
            }
        }
        return sum;
    }

    public boolean equals(Object other) {
        if (other instanceof ForcesOnPart) {
            ForcesOnPart otherForces = (ForcesOnPart)other;
            return otherForces.forces.equals(this.forces) && otherForces.reactionForces.equals(this.reactionForces) && Maths.approx(this.dampening, otherForces.dampening);
        }
        return false;
    }
}

