/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.collision.obb;

import com.flansmod.physics.common.util.shapes.IPlane;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public record SeparationResult(boolean success, @Nonnull IPlane separator, double depth) {
    @Nonnull
    public static SeparationResult successful(@Nonnull IPlane separator) {
        return new SeparationResult(true, separator, 0.0);
    }

    @Nonnull
    public static SeparationResult failure(@Nonnull IPlane separator, double depth) {
        return new SeparationResult(false, separator, depth);
    }

    @Nonnull
    public static SeparationResult bestFailResult(@Nullable SeparationResult previousBestResult, @Nonnull IPlane newSeparator, double newDepth) {
        return SeparationResult.bestFailResult(previousBestResult, SeparationResult.failure(newSeparator, newDepth));
    }

    @Nonnull
    public static SeparationResult bestFailResult(@Nullable SeparationResult previousBestResult, @Nonnull SeparationResult newResult) {
        if (previousBestResult == null) {
            return newResult;
        }
        double previousDist = previousBestResult.depth();
        double newDist = newResult.depth();
        if (newDist > previousDist) {
            return newResult;
        }
        return previousBestResult;
    }
}

