/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.collision.obb;

import com.flansmod.physics.client.DebugRenderer;
import com.flansmod.physics.common.FlansPhysicsMod;
import com.flansmod.physics.common.collision.ColliderHandle;
import com.flansmod.physics.common.collision.DynamicCollisionEvent;
import com.flansmod.physics.common.collision.ICollisionSystem;
import com.flansmod.physics.common.collision.IDynamicObjectUpdateReceiver;
import com.flansmod.physics.common.collision.IStaticObject;
import com.flansmod.physics.common.collision.StaticCollisionEvent;
import com.flansmod.physics.common.collision.TransformedBB;
import com.flansmod.physics.common.collision.obb.DynamicObject;
import com.flansmod.physics.common.collision.threading.CollisionTaskResolveDynamic;
import com.flansmod.physics.common.collision.threading.CollisionTaskSeparateDynamicFromStatic;
import com.flansmod.physics.common.collision.threading.CollisionTaskSeparateDynamicPair;
import com.flansmod.physics.common.collision.threading.ICollisionTask;
import com.flansmod.physics.common.units.AngularAcceleration;
import com.flansmod.physics.common.units.AngularVelocity;
import com.flansmod.physics.common.units.LinearAcceleration;
import com.flansmod.physics.common.units.LinearForce;
import com.flansmod.physics.common.units.LinearVelocity;
import com.flansmod.physics.common.units.Torque;
import com.flansmod.physics.common.util.ProjectedRange;
import com.flansmod.physics.common.util.ProjectionUtil;
import com.flansmod.physics.common.util.Transform;
import com.flansmod.physics.common.util.shapes.ISeparationAxis;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class OBBCollisionSystem
implements ICollisionSystem {
    private static Map<Level, OBBCollisionSystem> Instances = new HashMap<Level, OBBCollisionSystem>();
    private Map<ColliderHandle, IStaticObject> Statics = new HashMap<ColliderHandle, IStaticObject>();
    private final Level BlockAccess;
    private final Map<ColliderHandle, DynamicObject> Dynamics = new HashMap<ColliderHandle, DynamicObject>();
    private final List<ColliderHandle> AllHandles = new ArrayList<ColliderHandle>();
    private final List<ColliderHandle> InvalidatedHandles = new ArrayList<ColliderHandle>();
    private final Map<Pair<ColliderHandle, ColliderHandle>, ImmutableList<ISeparationAxis>> DynamicSeparations = new HashMap<Pair<ColliderHandle, ColliderHandle>, ImmutableList<ISeparationAxis>>();
    private final Map<ColliderHandle, ImmutableList<ISeparationAxis>> StaticSeparators = new HashMap<ColliderHandle, ImmutableList<ISeparationAxis>>();
    private long NextID = 1L;
    private final List<CollisionTaskSeparateDynamicPair> DynamicSeparationTasks = new ArrayList<CollisionTaskSeparateDynamicPair>();
    private final List<CollisionTaskSeparateDynamicFromStatic> StaticSeparationTasks = new ArrayList<CollisionTaskSeparateDynamicFromStatic>();
    private final List<CollisionTaskResolveDynamic> ResolverTasks = new ArrayList<CollisionTaskResolveDynamic>();
    private boolean DoingPhysics = false;
    private final Queue<Runnable> DoAfterPhysics = new ArrayDeque<Runnable>();
    private static final int PHYSICS_LOCK_MS_TIMEOUT = 16;
    private final Lock DynamicsLock = new ReentrantLock();
    private final Lock TasksLock = new ReentrantLock();
    public static final double MAX_LINEAR_BLOCKS_PER_TICK = 60.0;
    public static final double MAX_ANGULAR_MOTION_PER_TICK = 60.0;
    public static boolean DEBUG_SETTING_ONLY_LINEAR_REACTIONS = false;
    private final boolean SINGLE_THREAD_DEBUG = true;
    public static ColliderHandle DEBUG_HANDLE = new ColliderHandle(0L);

    @Nonnull
    public static OBBCollisionSystem ForLevel(@Nonnull Level level) {
        if (!Instances.containsKey(level)) {
            Instances.put(level, new OBBCollisionSystem(level));
        }
        return Instances.get(level);
    }

    public static ColliderHandle Debug_CycleInspectHandle(@Nonnull Level level, int delta) {
        OBBCollisionSystem system = OBBCollisionSystem.ForLevel(level);
        int index = system.AllHandles.indexOf(DEBUG_HANDLE);
        int newIndex = index + delta;
        DEBUG_HANDLE = newIndex >= system.AllHandles.size() || newIndex < 0 ? new ColliderHandle(0L) : system.AllHandles.get(newIndex);
        return DEBUG_HANDLE;
    }

    public static ColliderHandle Debug_SetInspectHandleIndex(@Nonnull Level level, int index) {
        OBBCollisionSystem system = OBBCollisionSystem.ForLevel(level);
        DEBUG_HANDLE = index >= system.AllHandles.size() || index < 0 ? new ColliderHandle(0L) : system.AllHandles.get(index);
        return DEBUG_HANDLE;
    }

    public static ColliderHandle Debug_SetNearestInspectHandle(@Nonnull Level level, @Nonnull Vec3 pos) {
        double closestDistSq = Double.MAX_VALUE;
        ColliderHandle closest = new ColliderHandle(0L);
        OBBCollisionSystem system = OBBCollisionSystem.ForLevel(level);
        for (ColliderHandle handle : system.AllHandles) {
            double distSq;
            DynamicObject dynamic;
            if (!handle.IsValid() || (dynamic = system.Dynamics.get(handle)) == null || !((distSq = dynamic.getCurrentLocation().positionVec3().m_82557_(pos)) < closestDistSq)) continue;
            closestDistSq = distSq;
            closest = handle;
        }
        DEBUG_HANDLE = closest.IsValid() ? closest : new ColliderHandle(0L);
        return DEBUG_HANDLE;
    }

    public static int Debug_GetNumHandles(@Nonnull Level level) {
        OBBCollisionSystem system = OBBCollisionSystem.ForLevel(level);
        return system.AllHandles.size();
    }

    public OBBCollisionSystem(@Nonnull Level level) {
        this.BlockAccess = level;
    }

    @Override
    public long getGameTick() {
        return this.BlockAccess.m_46467_();
    }

    private boolean lockDynamics(int msTimeout) {
        int msElapsed = 0;
        while (true) {
            if (this.DynamicsLock.tryLock()) {
                this.DoingPhysics = true;
                return true;
            }
            if (++msElapsed >= msTimeout) {
                return false;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private boolean tryLockDynamics() {
        return this.lockDynamics(0);
    }

    private void unlockDynamics() {
        this.DoingPhysics = false;
        this.DynamicsLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForEachDynamic(@Nonnull Consumer<DynamicObject> func, int msTimeout) {
        if (this.lockDynamics(msTimeout)) {
            try {
                for (DynamicObject dyn : this.Dynamics.values()) {
                    func.accept(dyn);
                }
            }
            finally {
                this.unlockDynamics();
            }
            return true;
        }
        return false;
    }

    public boolean tryForEachDynamic(@Nonnull Consumer<DynamicObject> func) {
        return this.waitForEachDynamic(func, 0);
    }

    private void doAfterPhysics(@Nonnull Runnable func) {
        if (this.DoingPhysics) {
            this.DoAfterPhysics.add(func);
        } else {
            func.run();
        }
    }

    @Override
    @Nonnull
    public ColliderHandle registerDynamic(@Nonnull List<AABB> localColliders, @Nonnull Transform initialTransform, double mass, @Nonnull Vec3 momentOfInertia) {
        return this.registerDynamic(builder -> builder.withColliders(localColliders).inLocation(initialTransform).withMass(mass).withMomentOfInertia(momentOfInertia));
    }

    @Nonnull
    public ColliderHandle registerDynamic(@Nonnull Consumer<DynamicObject.Builder> buildFunc) {
        ColliderHandle handle = new ColliderHandle(this.NextID);
        DynamicObject.Builder dynObjBuilder = DynamicObject.builder();
        buildFunc.accept(dynObjBuilder);
        DynamicObject dynObj = dynObjBuilder.build();
        ++this.NextID;
        this.doAfterPhysics(() -> {
            this.AllHandles.add(handle);
            this.Dynamics.put(handle, dynObj);
        });
        return handle;
    }

    @Override
    public void unregisterDynamic(@Nonnull ColliderHandle handle) {
        this.doAfterPhysics(() -> {
            this.Dynamics.remove(handle);
            this.AllHandles.remove(handle);
            this.InvalidatedHandles.remove(handle);
        });
    }

    @Override
    public void updateColliders(@Nonnull ColliderHandle handle, @Nonnull List<AABB> localColliders) {
    }

    @Override
    @Nonnull
    public LinearVelocity getLinearVelocity(@Nonnull ColliderHandle handle) {
        DynamicObject dyn = this.Dynamics.get(handle);
        if (dyn != null) {
            return dyn.getLinearVelocity();
        }
        return LinearVelocity.Zero;
    }

    @Override
    @Nonnull
    public AngularVelocity getAngularVelocity(@Nonnull ColliderHandle handle) {
        DynamicObject dyn = this.Dynamics.get(handle);
        if (dyn != null) {
            return dyn.getAngularVelocity();
        }
        return AngularVelocity.Zero;
    }

    @Override
    public void setLinearVelocity(@Nonnull ColliderHandle handle, @Nonnull LinearVelocity linearVelocity) {
        this.doAfterPhysics(() -> {
            DynamicObject dyn = this.Dynamics.get(handle);
            if (dyn != null && !FlansPhysicsMod.PAUSE_PHYSICS) {
                dyn.setLinearVelocity(linearVelocity);
            }
        });
    }

    @Override
    public void setAngularVelocity(@Nonnull ColliderHandle handle, @Nonnull AngularVelocity angularVelocity) {
        this.doAfterPhysics(() -> {
            DynamicObject dyn = this.Dynamics.get(handle);
            if (dyn != null && !FlansPhysicsMod.PAUSE_PHYSICS) {
                dyn.setAngularVelocity(angularVelocity);
            }
        });
    }

    @Override
    public void teleport(@Nonnull ColliderHandle handle, @Nonnull Transform to) {
        this.doAfterPhysics(() -> {
            DynamicObject dyn = this.Dynamics.get(handle);
            if (dyn != null && !FlansPhysicsMod.PAUSE_PHYSICS) {
                dyn.teleportTo(to);
            }
        });
    }

    @Override
    public void applyForce(@Nonnull ColliderHandle handle, @Nonnull LinearForce force) {
        this.doAfterPhysics(() -> {
            DynamicObject dyn = this.Dynamics.get(handle);
            if (dyn != null && !FlansPhysicsMod.PAUSE_PHYSICS) {
                dyn.addLinearAcceleration(force.actingOn(dyn.getMass()));
            }
        });
    }

    @Override
    public void applyTorque(@Nonnull ColliderHandle handle, @Nonnull Torque torque) {
        this.doAfterPhysics(() -> {
            DynamicObject dyn = this.Dynamics.get(handle);
            if (dyn != null && !FlansPhysicsMod.PAUSE_PHYSICS) {
                dyn.addAngularAcceleration(torque.actingOnInertiaTensor(dyn.InertiaTensor));
            }
        });
    }

    public void addLinearAcceleration(@Nonnull ColliderHandle handle, @Nonnull LinearAcceleration linearAcceleration) {
        this.doAfterPhysics(() -> {
            DynamicObject dyn = this.Dynamics.get(handle);
            if (dyn != null && !FlansPhysicsMod.PAUSE_PHYSICS) {
                dyn.addLinearAcceleration(linearAcceleration);
            }
        });
    }

    public void addAngularAcceleration(@Nonnull ColliderHandle handle, @Nonnull AngularAcceleration angularAcceleration) {
        this.doAfterPhysics(() -> {
            DynamicObject dyn = this.Dynamics.get(handle);
            if (dyn != null && !FlansPhysicsMod.PAUSE_PHYSICS) {
                dyn.addAngularAcceleration(angularAcceleration);
            }
        });
    }

    @Override
    public boolean isHandleInvalidated(@Nonnull ColliderHandle handle) {
        return this.InvalidatedHandles.contains(handle);
    }

    @Override
    @Nonnull
    public Transform processEvents(@Nonnull ColliderHandle handle, @Nonnull Consumer<StaticCollisionEvent> staticFunc, @Nonnull Consumer<DynamicCollisionEvent> dynamicFunc) {
        DynamicObject obj = this.Dynamics.get(handle);
        if (obj != null) {
            if (FlansPhysicsMod.PAUSE_PHYSICS) {
                return obj.getCurrentLocation();
            }
            for (StaticCollisionEvent staticCollisionEvent : obj.StaticCollisions) {
                staticFunc.accept(staticCollisionEvent);
            }
            for (DynamicCollisionEvent dynamicCollisionEvent : obj.DynamicCollisions) {
                dynamicFunc.accept(dynamicCollisionEvent);
            }
            return obj.getPendingLocation();
        }
        return Transform.IDENTITY;
    }

    @Override
    public void copyDynamicState(@Nonnull ColliderHandle handle, @Nonnull IDynamicObjectUpdateReceiver receiver) {
        DynamicObject obj = this.Dynamics.get(handle);
        if (obj != null) {
            receiver.updateLocation(obj.getPendingLocation());
            receiver.updateLinearVelocity(obj.getLinearVelocity());
            receiver.updateAngularVelocity(obj.getAngularVelocity());
            if (!FlansPhysicsMod.PAUSE_PHYSICS) {
                for (StaticCollisionEvent staticCollisionEvent : obj.StaticCollisions) {
                    receiver.handleStaticCollision(staticCollisionEvent);
                }
                for (DynamicCollisionEvent dynamicCollisionEvent : obj.DynamicCollisions) {
                    receiver.handleDynamicCollision(dynamicCollisionEvent);
                }
            }
        }
    }

    @Override
    public void preTick() {
        if (this.lockDynamics(16)) {
            this.unlockDynamics();
        } else {
            FlansPhysicsMod.LOGGER.warn("Physics could not lock after 16ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void physicsTick() {
        if (this.lockDynamics(16)) {
            try {
                ArrayList<ColliderHandle> expiredHandles = new ArrayList<ColliderHandle>();
                for (Map.Entry<ColliderHandle, DynamicObject> kvp : this.Dynamics.entrySet()) {
                    kvp.getValue().preTick();
                    if (!kvp.getValue().isInvalid()) continue;
                    expiredHandles.add(kvp.getKey());
                }
                for (ColliderHandle handle : expiredHandles) {
                    this.InvalidatedHandles.add(handle);
                    this.AllHandles.remove(handle);
                    this.Dynamics.remove(handle);
                }
                this.physicsStep_createSeparationTasks();
                this.physicsStep_unthreaded_processSeparationTasks();
                this.physicsStep_collectSeparationTasks();
                this.physicsStep_createResolverTasks();
                this.physicsStep_unthreaded_processResolverTasks();
                this.physicsStep_collectResolverTasks();
                this.physicsStep_commitFrame();
                while (!this.DoAfterPhysics.isEmpty()) {
                    this.DoAfterPhysics.remove().run();
                }
            }
            finally {
                this.unlockDynamics();
            }
        } else {
            FlansPhysicsMod.LOGGER.warn("Physics could not lock after 16ms");
        }
    }

    private void physicsStep_createSeparationTasks() {
        for (int i = 0; i < this.AllHandles.size(); ++i) {
            ColliderHandle handleA = this.AllHandles.get(i);
            DynamicObject objectA = this.Dynamics.get(handleA);
            if (objectA == null) continue;
            boolean movingA = !objectA.getLinearVelocity().isApproxZero() || !objectA.getAngularVelocity().isApproxZero();
            AABB sweepTestAABB = objectA.getSweepTestAABB();
            ImmutableList<VoxelShape> worldBBs = this.getWorldColliders(sweepTestAABB);
            if (!worldBBs.isEmpty()) {
                this.StaticSeparationTasks.add(CollisionTaskSeparateDynamicFromStatic.of(handleA, objectA, worldBBs, this.StaticSeparators.getOrDefault(handleA, (ImmutableList<ISeparationAxis>)ImmutableList.of())));
            }
            for (int j = i + 1; j < this.AllHandles.size(); ++j) {
                boolean movingB;
                ColliderHandle handleB = this.AllHandles.get(j);
                DynamicObject objectB = this.Dynamics.get(handleB);
                if (objectB == null) continue;
                boolean bl = movingB = !objectB.getLinearVelocity().isApproxZero() || !objectB.getAngularVelocity().isApproxZero();
                if (!movingA && !movingB) continue;
                Pair<ColliderHandle, ColliderHandle> key = ColliderHandle.uniquePairOf(handleA, handleB);
                this.DynamicSeparationTasks.add(CollisionTaskSeparateDynamicPair.of(handleA, objectA, handleB, objectB, this.DynamicSeparations.getOrDefault(key, (ImmutableList<ISeparationAxis>)ImmutableList.of())));
            }
        }
    }

    private void physicsStep_unthreaded_processSeparationTasks() {
        ICollisionTask<CollisionTaskSeparateDynamicFromStatic.Input, CollisionTaskSeparateDynamicFromStatic.Output> task;
        int i;
        for (i = 0; i < this.StaticSeparationTasks.size(); ++i) {
            task = this.StaticSeparationTasks.get(i);
            ((CollisionTaskSeparateDynamicFromStatic)task).run();
            if (((CollisionTaskSeparateDynamicFromStatic)task).isComplete()) continue;
            FlansPhysicsMod.LOGGER.error("SINGLE_THREAD_PHYSICS: Failed to complete static task");
        }
        for (i = 0; i < this.DynamicSeparationTasks.size(); ++i) {
            task = this.DynamicSeparationTasks.get(i);
            ((CollisionTaskSeparateDynamicPair)task).run();
            if (((CollisionTaskSeparateDynamicPair)task).isComplete()) continue;
            FlansPhysicsMod.LOGGER.error("SINGLE_THREAD_PHYSICS: Failed to complete dynamic task");
        }
    }

    private void physicsStep_collectSeparationTasks() {
        ICollisionTask<CollisionTaskSeparateDynamicFromStatic.Input, CollisionTaskSeparateDynamicFromStatic.Output> task;
        int i;
        for (i = 0; i < this.StaticSeparationTasks.size(); ++i) {
            CollisionTaskSeparateDynamicFromStatic.Output output;
            task = this.StaticSeparationTasks.get(i);
            if (!((CollisionTaskSeparateDynamicFromStatic)task).isComplete()) continue;
            DynamicObject object = this.Dynamics.get(((CollisionTaskSeparateDynamicFromStatic)task).Handle);
            if (object != null && (output = ((CollisionTaskSeparateDynamicFromStatic)task).getResult()) != null) {
                object.StaticCollisions.addAll((Collection<StaticCollisionEvent>)output.EventsA());
                if (output.NewSeparatorList() != null && !output.NewSeparatorList().isEmpty()) {
                    this.StaticSeparators.put(((CollisionTaskSeparateDynamicFromStatic)task).Handle, output.NewSeparatorList());
                    if (DEBUG_HANDLE.Handle() == ((CollisionTaskSeparateDynamicFromStatic)task).Handle.Handle()) {
                        ArrayList<VoxelShape> statics = new ArrayList<VoxelShape>((Collection<VoxelShape>)((CollisionTaskSeparateDynamicFromStatic)task).Debug_GetInput().StaticShapes());
                        float blue = 1.0f;
                        for (ISeparationAxis axis : output.NewSeparatorList()) {
                            Vec3 normal = axis.getNormal();
                            Vec3 up = new Vec3(normal.f_82481_, -normal.f_82479_, -normal.f_82480_);
                            TransformedBB obb = object.getPendingBB();
                            ProjectedRange range = axis.projectOBBMinMax(obb);
                            double center = axis.project(obb.GetCenter());
                            Transform pos = Transform.fromPositionAndLookDirection(obb.GetCenter().m_82549_(normal.m_82490_(range.max() - center)), normal, up);
                            DebugRenderer.renderArrow(pos, 3, new Vector4f(1.0f, 1.0f, blue, 1.0f), new Vec3(0.0, 0.0, -1.0));
                            for (int j = statics.size() - 1; j >= 0; --j) {
                                AABB aabb = ((VoxelShape)statics.get(j)).m_83215_();
                                ProjectedRange boxProj = axis.projectAABBMinMax(aabb);
                                if (!ProjectionUtil.SeparatedAThenB(range, boxProj)) continue;
                                Transform staticPos = Transform.fromPos(aabb.m_82399_());
                                DebugRenderer.renderCube(staticPos, 3, new Vector4f(1.0f, 1.0f, blue, 1.0f), new Vector3f((float)aabb.m_82362_() * 0.5f, (float)aabb.m_82376_() * 0.5f, (float)aabb.m_82385_() * 0.5f));
                                statics.remove(j);
                            }
                            blue *= 0.66f;
                        }
                        for (int j = statics.size() - 1; j >= 0; --j) {
                            AABB aabb = ((VoxelShape)statics.get(j)).m_83215_();
                            Transform staticPos = Transform.fromPos(aabb.m_82399_());
                            DebugRenderer.renderCube(staticPos, 3, new Vector4f(1.0f, 0.0f, 0.0f, 1.0f), new Vector3f((float)aabb.m_82362_() * 0.5f, (float)aabb.m_82376_() * 0.5f, (float)aabb.m_82385_() * 0.5f));
                        }
                    }
                }
            }
            if (DEBUG_HANDLE.Handle() != ((CollisionTaskSeparateDynamicFromStatic)task).Handle.Handle()) continue;
        }
        this.StaticSeparationTasks.clear();
        for (i = 0; i < this.DynamicSeparationTasks.size(); ++i) {
            DynamicObject objectB;
            CollisionTaskSeparateDynamicPair.Output output;
            task = this.DynamicSeparationTasks.get(i);
            if (!((CollisionTaskSeparateDynamicPair)task).isComplete() || (output = ((CollisionTaskSeparateDynamicPair)task).getResult()) == null) continue;
            DynamicObject objectA = this.Dynamics.get(((CollisionTaskSeparateDynamicPair)task).HandleA);
            if (objectA != null) {
                objectA.DynamicCollisions.addAll((Collection<DynamicCollisionEvent>)output.EventsA());
            }
            if ((objectB = this.Dynamics.get(((CollisionTaskSeparateDynamicPair)task).HandleB)) != null) {
                objectB.DynamicCollisions.addAll((Collection<DynamicCollisionEvent>)output.EventsB());
            }
            if (output.NewSeparatorList() == null || output.NewSeparatorList().size() <= 0) continue;
            this.DynamicSeparations.put(ColliderHandle.uniquePairOf(((CollisionTaskSeparateDynamicPair)task).HandleA, ((CollisionTaskSeparateDynamicPair)task).HandleB), output.NewSeparatorList());
        }
        this.DynamicSeparationTasks.clear();
    }

    private void physicsStep_createResolverTasks() {
        for (Map.Entry<ColliderHandle, DynamicObject> kvp : this.Dynamics.entrySet()) {
            ColliderHandle handle = kvp.getKey();
            DynamicObject dyn = kvp.getValue();
            if (dyn.pendingFrameIsTeleport() || dyn.StaticCollisions.isEmpty() && dyn.DynamicCollisions.isEmpty()) continue;
            this.ResolverTasks.add(CollisionTaskResolveDynamic.of(handle, dyn, dyn.DynamicCollisions, dyn.StaticCollisions));
        }
    }

    private void physicsStep_unthreaded_processResolverTasks() {
        for (int i = 0; i < this.ResolverTasks.size(); ++i) {
            CollisionTaskResolveDynamic task = this.ResolverTasks.get(i);
            task.run();
            if (task.isComplete()) continue;
            FlansPhysicsMod.LOGGER.error("SINGLE_THREAD_PHYSICS: Failed to complete resolver task");
        }
    }

    private void physicsStep_collectResolverTasks() {
        for (int i = 0; i < this.ResolverTasks.size(); ++i) {
            CollisionTaskResolveDynamic task = this.ResolverTasks.get(i);
            DynamicObject dyn = this.Dynamics.get(task.Handle);
            if (dyn == null || task.getResult() == null) continue;
            dyn.setPendingLocation(task.getResult().ResolvedLocation());
            dyn.setPendingLinearVelocity(task.getResult().ResolvedVelocity().linear());
            dyn.setPendingAngularVelocity(task.getResult().ResolvedVelocity().angular());
        }
        this.ResolverTasks.clear();
    }

    private void physicsStep_commitFrame() {
        if (FlansPhysicsMod.PAUSE_PHYSICS) {
            for (DynamicObject dyn : this.Dynamics.values()) {
                dyn.discardPendingFrame();
            }
        } else {
            for (DynamicObject dyn : this.Dynamics.values()) {
                dyn.commitPendingFrame();
            }
        }
    }

    @Nonnull
    private ImmutableList<VoxelShape> getWorldColliders(@Nonnull AABB sweepAABB) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (sweepAABB.m_82362_() > 128.0 || sweepAABB.m_82376_() > 64.0 || sweepAABB.m_82385_() > 128.0) {
            FlansPhysicsMod.LOGGER.warn("Oversized SweepTest AABB at " + sweepAABB);
            return builder.build();
        }
        Iterable blockCollisions = this.BlockAccess.m_186434_(null, sweepAABB);
        builder.addAll(blockCollisions);
        WorldBorder worldborder = this.BlockAccess.m_6857_();
        if (worldborder.m_61941_(sweepAABB.m_82399_().f_82479_, sweepAABB.m_82399_().f_82481_) < sweepAABB.m_82309_()) {
            builder.add((Object)worldborder.m_61946_());
        }
        return builder.build();
    }

    @Nonnull
    public ImmutableList<ISeparationAxis> Debug_GetSeparatorsFor(@Nonnull ColliderHandle handle) {
        return this.StaticSeparators.getOrDefault(handle, (ImmutableList<ISeparationAxis>)ImmutableList.of());
    }
}

