/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.worldgen.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;

public class LootPopulator
extends LootModifier {
    public static final Supplier<Codec<LootPopulator>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> LootPopulator.codecStart((RecordCodecBuilder.Instance)inst).and((App)LootEntry.CODEC.listOf().fieldOf("entries").forGetter(m -> m.Entries)).apply((Applicative)inst, LootPopulator::new)));
    private final List<LootEntry> Entries;

    public LootPopulator(LootItemCondition[] conditionsIn, List<LootEntry> entries) {
        super(conditionsIn);
        this.Entries = entries;
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        for (LootEntry entry : this.Entries) {
            if (!(context.m_230907_().m_188501_() < entry.Chance)) continue;
            int count = entry.MinStackSize == entry.MaxStackSize ? entry.MinStackSize : context.m_230907_().m_216339_(entry.MinStackSize, entry.MaxStackSize);
            generatedLoot.add((Object)entry.Item.m_255036_(count));
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }

    private static class LootEntry {
        public static final Codec<LootEntry> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ExtraCodecs.f_184349_.optionalFieldOf("chance", (Object)Float.valueOf(1.0f)).forGetter(m -> Float.valueOf(m.Chance)), (App)Codec.INT.optionalFieldOf("min_stack_size", (Object)1).forGetter(m -> m.MinStackSize), (App)Codec.INT.optionalFieldOf("max_stack_size", (Object)1).forGetter(m -> m.MaxStackSize), (App)ItemStack.f_41582_.optionalFieldOf("item", (Object)ItemStack.f_41583_).forGetter(m -> m.Item)).apply((Applicative)inst, LootEntry::new));
        public final float Chance;
        public final int MinStackSize;
        public final int MaxStackSize;
        public final ItemStack Item;

        public LootEntry(float chance, int minStack, int maxStack, ItemStack item) {
            this.Chance = chance;
            this.MinStackSize = minStack;
            this.MaxStackSize = maxStack;
            this.Item = item;
        }
    }
}

