/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.types.vehicles.elements;

import com.flansmod.common.types.JsonField;
import com.flansmod.common.types.vehicles.elements.EControlLogicHint;
import javax.annotation.Nonnull;
import net.minecraft.world.phys.Vec3;

public class WheelDefinition {
    public static final WheelDefinition INVALID = new WheelDefinition();
    @JsonField
    public Vec3 visualOffset = Vec3.f_82478_;
    @JsonField
    public float springStrength = 1.0f;
    @JsonField
    public float stepHeight = 1.0f;
    @JsonField
    public float gravityScale = 1.0f;
    @JsonField(Min=0.0)
    public float maxForwardTorque = 1.0f;
    @JsonField(Min=0.0)
    public float maxReverseTorque = 1.0f;
    @JsonField(Min=0.009999999776482582)
    public float radius = 0.25f;
    @JsonField
    public boolean floatOnWater = false;
    @JsonField
    public float buoyancy = 1.0f;
    @JsonField(Min=9.999999747378752E-5)
    public float mass = 1.0f;
    @JsonField(Docs="Leave as zero to auto-calculate")
    public Vec3 momentOfInertia = Vec3.f_82478_;
    @JsonField(Min=0.0, Docs="Roughly how many seconds it takes for player changes to torque to be applied")
    public float torqueResponsiveness = 0.1f;
    @JsonField(Min=0.0, Docs="Roughly how many seconds it takes for player changes to yaw (steering) to be applied")
    public float yawResponsiveness = 0.1f;
    @JsonField
    public EControlLogicHint[] controlHints = new EControlLogicHint[0];
    private static final float TICK_RATE = 0.05f;
    private Vec3 _CalculatedMoment = null;

    public boolean IsHintedAs(@Nonnull EControlLogicHint check) {
        for (EControlLogicHint hintType : this.controlHints) {
            if (hintType != check) continue;
            return true;
        }
        return false;
    }

    public float TorqueLerpRate() {
        if (this.torqueResponsiveness < 0.01f) {
            return 1.0f;
        }
        return 0.05f / this.torqueResponsiveness;
    }

    public float YawLerpRate() {
        if (this.yawResponsiveness < 0.01f) {
            return 1.0f;
        }
        return 0.05f / this.yawResponsiveness;
    }

    public Vec3 MomentOfInertia() {
        if (this._CalculatedMoment == null) {
            if (this.momentOfInertia.m_82557_(Vec3.f_82478_) < 1.0E-7) {
                double inertiaX = 0.4f * this.mass * this.radius * this.radius;
                double inertiaY = inertiaX * 0.5;
                double inertiaZ = inertiaX * (double)0.1f;
                this._CalculatedMoment = new Vec3(inertiaX, inertiaY, inertiaZ);
            } else {
                this._CalculatedMoment = this.momentOfInertia;
            }
        }
        return this._CalculatedMoment;
    }
}

