/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.types.vehicles.elements;

import com.flansmod.common.types.JsonField;
import com.flansmod.common.types.elements.SoundDefinition;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.Transform;
import javax.annotation.Nonnull;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.Lazy;

public class ArticulatedPartDefinition {
    @JsonField
    public boolean active = false;
    @JsonField
    public float minParameter = 0.0f;
    @JsonField
    public float maxParameter = 1.0f;
    @JsonField
    public float startParameter = 0.0f;
    @JsonField
    public boolean cyclic = false;
    @JsonField(Min=-360.0, Max=360.0)
    public float minYaw = 0.0f;
    @JsonField(Min=-360.0, Max=360.0)
    public float maxYaw = 0.0f;
    @JsonField(Min=-90.0, Max=90.0)
    public float minPitch = 0.0f;
    @JsonField(Min=-90.0, Max=90.0)
    public float maxPitch = 0.0f;
    @JsonField(Min=-360.0, Max=360.0)
    public float minRoll = 0.0f;
    @JsonField(Min=-360.0, Max=360.0)
    public float maxRoll = 0.0f;
    @JsonField
    public Vec3 minOffset = Vec3.f_82478_;
    @JsonField
    public Vec3 maxOffset = Vec3.f_82478_;
    @JsonField
    public SoundDefinition traverseSound = new SoundDefinition();
    @JsonField(Docs="If set true, this turret has to line up its yaw, then its pitch, one at a time")
    public boolean traveseIndependently = false;
    @JsonField(Docs="If non-empty, the turret will try to align itself to this seat's look vector")
    public String followSeatAtPath = "";
    @JsonField
    public boolean lockSeatToGunAngles = false;
    @JsonField(Docs="How fast does the part turn? Set to 0 or negative to make it move at player look speed.")
    public float rotateSpeed = 1.0f;
    @Nonnull
    public Lazy<Transform> StartPose = Lazy.of(() -> Transform.fromPosAndEuler(this.minOffset, this.minYaw, this.minPitch, this.minRoll));
    @Nonnull
    public Lazy<Transform> EndPose = Lazy.of(() -> Transform.fromPosAndEuler(this.maxOffset, this.maxYaw, this.maxPitch, this.maxRoll));

    @Nonnull
    public Transform Apply(float parameter) {
        return Transform.interpolate((Transform)this.StartPose.get(), (Transform)this.EndPose.get(), Maths.clamp(parameter, this.minParameter, this.maxParameter));
    }
}

