/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.types.elements;

import com.flansmod.common.types.JsonDefinition;
import com.flansmod.common.types.JsonField;
import com.flansmod.common.types.elements.SoundLODDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SoundDefinition {
    @JsonField(AssetPathHint="sounds/")
    public ResourceLocation sound = JsonDefinition.InvalidLocation;
    @JsonField(Docs="In seconds")
    public float length = 1.0f;
    @JsonField
    public float minPitchMultiplier = 1.0f;
    @JsonField
    public float maxPitchMultiplier = 1.0f;
    @JsonField
    public float minVolume = 1.0f;
    @JsonField
    public float maxVolume = 1.0f;
    @JsonField
    public float maxRange = 100.0f;
    @JsonField
    public SoundLODDefinition[] LODs = new SoundLODDefinition[0];

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation GetSoundLocation() {
        return this.sound;
    }

    public float PickRandomVolume(RandomSource random) {
        return this.minVolume + random.m_188501_() * (this.maxVolume - this.minVolume);
    }

    public float PickRangedVolume(float distance) {
        return this.minVolume + (this.maxVolume - this.minVolume) * (1.0f - distance / this.maxRange);
    }

    public float PickRandomPitch(RandomSource random) {
        return this.minPitchMultiplier + random.m_188501_() * (this.maxPitchMultiplier - this.minPitchMultiplier);
    }

    public void PlayUnLODedOnEntity(Entity entity) {
        entity.m_5496_(SoundEvent.m_262856_((ResourceLocation)this.sound, (float)this.maxRange), this.PickRandomVolume(entity.m_9236_().f_46441_), this.PickRandomPitch(entity.m_9236_().f_46441_));
    }

    public void PlayUnLODed(Level level, Vec3 pos) {
        level.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvent.m_262856_((ResourceLocation)this.sound, (float)this.maxRange), SoundSource.PLAYERS, this.PickRandomVolume(level.f_46441_), this.PickRandomPitch(level.f_46441_));
    }
}

