/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.types.elements;

import com.flansmod.common.FlansMod;
import com.flansmod.common.types.JsonField;
import com.flansmod.common.types.crafting.EMaterialType;
import com.flansmod.common.types.crafting.MaterialDefinition;
import com.flansmod.common.types.elements.EFilterType;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MaterialFilterDefinition {
    @JsonField
    public EFilterType filterType = EFilterType.Allow;
    @JsonField
    public EMaterialType[] materialTypes = new EMaterialType[0];
    @JsonField
    public int minTier = 1;
    @JsonField
    public int maxTier = 5;
    @Nullable
    private List<MaterialDefinition> MaterialCache = null;

    public boolean Allows(@Nonnull MaterialDefinition material) {
        if (this.filterType == EFilterType.Allow) {
            return this.GetMatches().contains(material);
        }
        return false;
    }

    public boolean Disallows(@Nonnull MaterialDefinition material) {
        if (this.filterType == EFilterType.Disallow) {
            return this.GetMatches().contains(material);
        }
        return false;
    }

    public boolean is(@Nonnull EMaterialType matType) {
        for (EMaterialType allowed : this.materialTypes) {
            if (allowed != matType) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public List<MaterialDefinition> GetMatches() {
        if (this.MaterialCache == null) {
            this.MaterialCache = FlansMod.MATERIALS.Find(mat -> mat.IsValid() && mat.craftingTier >= this.minTier && mat.craftingTier <= this.maxTier && this.is(mat.materialType));
        }
        return this.MaterialCache;
    }
}

