/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.types.elements;

import com.flansmod.common.item.FlanItem;
import com.flansmod.common.item.PartItem;
import com.flansmod.common.types.JsonDefinition;
import com.flansmod.common.types.JsonField;
import com.flansmod.common.types.elements.LocationFilterDefinition;
import com.flansmod.common.types.elements.MaterialFilterDefinition;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemCollectionDefinition {
    @JsonField(Docs="ItemID inclusions/exclusions - to ignore itemID, leave empty")
    public LocationFilterDefinition[] itemIDFilters = new LocationFilterDefinition[0];
    @JsonField(Docs="ItemTag inclusions/exclusions - to ignore tags, leave empty")
    public LocationFilterDefinition[] itemTagFilters = new LocationFilterDefinition[0];
    @JsonField(Docs="Material inclusions/exclusions - to ignore materials, leave empty")
    public MaterialFilterDefinition[] materialFilters = new MaterialFilterDefinition[0];
    private List<JsonDefinition> CachedDefinitions = null;
    private List<ItemStack> CachedMatches = null;

    @Nonnull
    public List<JsonDefinition> GetDefinitionMatches() {
        if (this.CachedDefinitions == null) {
            this.CachedDefinitions = new ArrayList<JsonDefinition>();
            for (ItemStack stack : this.GetItemMatches()) {
                Item item = stack.m_41720_();
                if (!(item instanceof FlanItem)) continue;
                FlanItem flanItem = (FlanItem)item;
                this.CachedDefinitions.add(flanItem.Def());
            }
        }
        return this.CachedDefinitions;
    }

    @Nonnull
    public List<ItemStack> GetItemMatches() {
        if (this.CachedMatches == null) {
            this.CachedMatches = new ArrayList<ItemStack>();
            ForgeRegistries.ITEMS.forEach(item -> {
                Object partItem;
                int n;
                boolean included = false;
                for (LocationFilterDefinition idFilter : this.itemIDFilters) {
                    if (!idFilter.Allows(item.m_204114_().m_205785_().m_135782_())) continue;
                    included = true;
                    break;
                }
                LocationFilterDefinition[] locationFilterDefinitionArray = this.itemTagFilters;
                int n2 = locationFilterDefinitionArray.length;
                for (n = 0; n < n2; ++n) {
                    LocationFilterDefinition tagFilter = locationFilterDefinitionArray[n];
                    if (!item.m_204114_().m_203616_().anyMatch(itemTag -> tagFilter.Allows(itemTag.f_203868_()))) continue;
                    included = true;
                    break;
                }
                if (item instanceof PartItem) {
                    partItem = (LocationFilterDefinition[])item;
                    MaterialFilterDefinition[] materialFilterDefinitionArray = this.materialFilters;
                    n = materialFilterDefinitionArray.length;
                    for (int tagFilter = 0; tagFilter < n; ++tagFilter) {
                        MaterialFilterDefinition matFilter = materialFilterDefinitionArray[tagFilter];
                        if (!matFilter.Allows(((PartItem)((Object)((Object)partItem))).Def().GetMaterial())) continue;
                        included = true;
                        break;
                    }
                }
                if (!included) {
                    return;
                }
                for (LocationFilterDefinition idFilter : this.itemIDFilters) {
                    if (!idFilter.Disallows(item.m_204114_().m_205785_().m_135782_())) continue;
                    return;
                }
                for (LocationFilterDefinition tagFilter : this.itemTagFilters) {
                    if (!item.m_204114_().m_203616_().anyMatch(itemTag -> tagFilter.Disallows(itemTag.f_203868_()))) continue;
                    return;
                }
                if (item instanceof PartItem) {
                    partItem = (PartItem)((Object)item);
                    for (MaterialFilterDefinition matFilter : this.materialFilters) {
                        if (!matFilter.Disallows(((PartItem)((Object)((Object)partItem))).Def().GetMaterial())) continue;
                        return;
                    }
                }
                this.CachedMatches.add(new ItemStack((ItemLike)item));
            });
        }
        return this.CachedMatches;
    }
}

