/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.types.crafting.elements;

import com.flansmod.common.FlansMod;
import com.flansmod.common.crafting.recipes.GunFabricationRecipe;
import com.flansmod.common.types.JsonField;
import com.flansmod.common.types.elements.ItemCollectionDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class GunCraftingDefinition {
    @JsonField
    public boolean isActive = false;
    @JsonField
    public ItemCollectionDefinition craftableGuns = new ItemCollectionDefinition();
    @JsonField
    public int maxSlots = 8;
    @JsonField
    public int FECostPerCraft = 0;
    @Nonnull
    private final HashMap<Level, List<GunFabricationRecipe>> RecipeCaches = new HashMap();

    @Nonnull
    public List<ItemStack> GetAllOutputs() {
        return this.craftableGuns.GetItemMatches();
    }

    @Nonnull
    public List<GunFabricationRecipe> GetAllRecipes(@Nonnull Level level) {
        List<ItemStack> allOutputs = this.GetAllOutputs();
        if (!this.RecipeCaches.containsKey(level)) {
            ArrayList<GunFabricationRecipe> recipeCache = new ArrayList<GunFabricationRecipe>();
            List allRecipes = level.m_7465_().m_44013_((RecipeType)FlansMod.GUN_FABRICATION_RECIPE_TYPE.get());
            for (GunFabricationRecipe recipe : allRecipes) {
                boolean allowed = false;
                for (ItemStack validOutput : allOutputs) {
                    if (!ItemStack.m_41656_((ItemStack)validOutput, (ItemStack)recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_))) continue;
                    allowed = true;
                }
                if (recipe.InputIngredients.size() > this.maxSlots) {
                    allowed = false;
                }
                if (!allowed) continue;
                recipeCache.add(recipe);
            }
            recipeCache.sort((o1, o2) -> {
                int hash2;
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                int hash1 = o1.Loc.hashCode();
                if (hash1 < (hash2 = o2.Loc.hashCode())) {
                    return -1;
                }
                if (hash2 < hash1) {
                    return 1;
                }
                FlansMod.LOGGER.error("Equivalient recipes " + o1 + " " + o2 + "!");
                return 0;
            });
            this.RecipeCaches.put(level, recipeCache);
        }
        return this.RecipeCaches.get(level);
    }
}

