/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.types.abilities.elements;

import com.flansmod.common.actions.contexts.TriggerContext;
import com.flansmod.common.item.FlanItem;
import com.flansmod.common.types.JsonField;
import com.flansmod.common.types.abilities.elements.EAbilityTrigger;
import com.flansmod.common.types.abilities.elements.ETriggerConditionType;
import com.flansmod.common.types.abilities.elements.TriggerConditionDefinition;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;

public class AbilityTriggerDefinition {
    @JsonField
    public EAbilityTrigger triggerType = EAbilityTrigger.Instant;
    @JsonField
    public TriggerConditionDefinition[] triggerConditions = new TriggerConditionDefinition[0];

    public boolean Matches(@Nonnull EAbilityTrigger checkTriggerType) {
        return this.triggerType == checkTriggerType;
    }

    public boolean Matches(@Nonnull EAbilityTrigger checkTriggerType, @Nonnull TriggerContext triggerContext) {
        if (this.triggerType != checkTriggerType) {
            return false;
        }
        for (TriggerConditionDefinition conditionDef : this.triggerConditions) {
            if (conditionDef.Matches(triggerContext)) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public Component GetTooltip(boolean expanded) {
        String localisationKey = "trigger.expanded." + this.triggerType.toString().toLowerCase();
        switch (this.triggerType) {
            case StartActionGroup: 
            case TriggerActionGroup: 
            case EndActionGroup: {
                for (TriggerConditionDefinition condition : this.triggerConditions) {
                    if (condition.conditionType != ETriggerConditionType.CheckActionGroupPath) continue;
                    return Component.m_237110_((String)localisationKey, (Object[])new Object[]{FlanItem.ListOf("action.group_path.", condition.allowedValues)});
                }
                return Component.m_237110_((String)localisationKey, (Object[])new Object[]{Component.m_237115_((String)"trigger.any")});
            }
        }
        return Component.m_237115_((String)localisationKey);
    }
}

