/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.projectiles;

import com.flansmod.client.render.FirstPersonManager;
import com.flansmod.common.FlansModConfig;
import com.flansmod.common.actions.ActionGroupInstance;
import com.flansmod.common.actions.contexts.ActionGroupContext;
import com.flansmod.common.actions.contexts.GunContext;
import com.flansmod.common.actions.contexts.GunContextPlayer;
import com.flansmod.common.actions.contexts.ShooterContext;
import com.flansmod.common.actions.nodes.EjectCasingAction;
import com.flansmod.common.types.guns.GunDefinition;
import com.flansmod.common.types.guns.elements.ActionDefinition;
import com.flansmod.common.types.guns.elements.EActionType;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.MinecraftHelpers;
import com.flansmod.physics.common.util.Transform;
import com.flansmod.physics.common.util.TransformStack;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class CasingEntity
extends Projectile {
    private static final EntityDataAccessor<Optional<UUID>> DATA_OWNER_UUID = SynchedEntityData.m_135353_(CasingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_SHOOTER_UUID = SynchedEntityData.m_135353_(CasingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_GUN_ID = SynchedEntityData.m_135353_(CasingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> DATA_ACTION_GROUP_PATH_HASH = SynchedEntityData.m_135353_(CasingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_LIFETIME = SynchedEntityData.m_135353_(CasingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int lifeTime = 0;
    public boolean initialized = false;
    public Vec3 firstPersonOffset = Vec3.f_82478_;
    public String itemToSpawn = "";
    public EjectCasingAction Action;

    public void SetOwnerID(@Nonnull UUID ownerID) {
        this.f_19804_.m_135381_(DATA_OWNER_UUID, Optional.of(ownerID));
    }

    public void SetShooterID(@Nonnull UUID shooterID) {
        this.f_19804_.m_135381_(DATA_SHOOTER_UUID, Optional.of(shooterID));
    }

    public void SetGunID(@Nonnull UUID gunID) {
        this.f_19804_.m_135381_(DATA_GUN_ID, Optional.of(gunID));
    }

    public void SetActionGroupPathHash(int hash) {
        this.f_19804_.m_135381_(DATA_ACTION_GROUP_PATH_HASH, (Object)hash);
    }

    @Nonnull
    public UUID GetOwnerID() {
        return ((Optional)this.f_19804_.m_135370_(DATA_OWNER_UUID)).orElse(ShooterContext.InvalidID);
    }

    @Nonnull
    public UUID GetShooterID() {
        return ((Optional)this.f_19804_.m_135370_(DATA_SHOOTER_UUID)).orElse(ShooterContext.InvalidID);
    }

    @Nonnull
    public UUID GetGunID() {
        return ((Optional)this.f_19804_.m_135370_(DATA_GUN_ID)).orElse(GunContext.INVALID.GetUUID());
    }

    public int GetActionGroupPathHash() {
        return (Integer)this.f_19804_.m_135370_(DATA_ACTION_GROUP_PATH_HASH);
    }

    public void SetLifeTime(int index) {
        this.f_19804_.m_135381_(DATA_LIFETIME, (Object)index);
    }

    public int GetLifeTime() {
        return (Integer)this.f_19804_.m_135370_(DATA_LIFETIME);
    }

    public GunDefinition GetGunDef() {
        return this.GetContext().Def;
    }

    @Nonnull
    public GunContext GetContext() {
        return ShooterContext.of(this.GetShooterID(), this.GetOwnerID()).CreateContext(this.GetGunID());
    }

    @Nullable
    public Entity Owner() {
        return this.m_9236_().m_46003_(this.GetOwnerID());
    }

    @Nullable
    public Entity GetShooter() {
        return this.m_9236_().m_46003_(this.GetOwnerID());
    }

    public CasingEntity(EntityType<? extends Projectile> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_OWNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(DATA_SHOOTER_UUID, Optional.empty());
        this.f_19804_.m_135372_(DATA_GUN_ID, Optional.empty());
        this.f_19804_.m_135372_(DATA_ACTION_GROUP_PATH_HASH, (Object)0);
        this.f_19804_.m_135372_(DATA_LIFETIME, (Object)0);
    }

    public void InitContext(@Nonnull ActionGroupContext context) {
        this.SetOwnerID(context.Gun.GetShooter().OwnerUUID());
        this.SetShooterID(context.Gun.GetShooter().EntityUUID());
        this.SetGunID(context.Gun.GetUUID());
        this.SetActionGroupPathHash(context.GroupPath.hashCode());
        this.lifeTime = 0;
        this.initialized = false;
    }

    public void InitOffset() {
        ShooterContext shooter = ShooterContext.of(this.GetShooterID(), this.GetOwnerID());
        GunContext gun = shooter.CreateContext(this.GetGunID());
        ActionGroupContext actionGroup = gun.GetActionGroupContextByHash(this.GetActionGroupPathHash());
        if (this.Action == null) {
            for (ActionDefinition def : actionGroup.Def.actions) {
                if (def.actionType != EActionType.EjectCasing) continue;
                this.Action = new EjectCasingAction(new ActionGroupInstance(actionGroup), def);
            }
        }
        if (this.Action == null) {
            return;
        }
        GunContext gunContext = this.GetContext();
        if (gunContext instanceof GunContextPlayer) {
            GunContextPlayer playerGunContext = (GunContextPlayer)gunContext;
            ItemDisplayContext transformType = MinecraftHelpers.getFirstPersonTransformType(playerGunContext.GetHand());
            Transform origin = FirstPersonManager.GetWorldSpaceAPTransform(this.GetContext(), transformType, ActionGroupContext.CreateGroupPath(this.Action.AttachPoint()));
            TransformStack transformStack = TransformStack.empty();
            transformStack.add(origin);
            Vec3 position = transformStack.top().positionVec3();
            Vec3 position2 = this.m_20182_();
            this.firstPersonOffset = new Vec3(position.m_7096_() - position2.m_7096_(), position.m_7098_() - position2.m_7098_(), position.m_7094_() - position2.m_7094_());
        }
    }

    public void m_7380_(CompoundTag tags) {
        CompoundTag contextTags = new CompoundTag();
        this.GetContext().Save(contextTags);
        tags.m_128365_("context", (Tag)contextTags);
        tags.m_128405_("lifeTime", this.lifeTime);
    }

    public void m_7378_(CompoundTag tags) {
        if (tags.m_128441_("bullet")) {
            // empty if block
        }
        if (tags.m_128441_("context")) {
            ActionGroupContext context = ActionGroupContext.Load(tags.m_128469_("context"), this.m_9236_().f_46443_);
            if (context != null) {
                this.InitContext(context);
            }
        } else {
            this.m_6074_();
        }
        this.lifeTime = tags.m_128451_("lifeTime");
        CompoundTag tag = new CompoundTag();
    }

    public void RecalculateFacing(Vec3 direction) {
        double xz = Maths.sqrt(direction.f_82479_ * direction.f_82479_ + direction.f_82481_ * direction.f_82481_);
        float yawDeg = (float)Maths.atan2(direction.f_82479_, direction.f_82481_) * 57.29578f;
        float pitchDeg = (float)Maths.atan2(direction.f_82480_, xz) * 57.29578f;
        this.m_146926_(pitchDeg);
        this.m_146922_(yawDeg);
        this.m_146867_();
    }

    public void SetVelocity(Vec3 velocity) {
        this.m_20256_(velocity);
        this.m_146867_();
    }

    public void m_8119_() {
        super.m_8119_();
        this.lifeTime = this.GetLifeTime();
        if (this.m_9236_().f_46443_ && this.lifeTime == 0) {
            this.InitOffset();
        }
        Vec3 motion = this.m_20184_();
        motion = this.ApplyGravity(motion);
        this.Spin();
        this.m_20256_(motion);
        this.m_6478_(MoverType.SELF, motion);
        if (!this.m_9236_().m_5776_()) {
            this.HitGround();
        }
        ++this.lifeTime;
        this.SetLifeTime(this.lifeTime);
    }

    protected Vec3 ApplyGravity(Vec3 motion) {
        return new Vec3(motion.f_82479_, motion.f_82480_ - 0.04, motion.f_82481_);
    }

    public void Spin() {
    }

    public void HitGround() {
        HitResult hitResult = ProjectileUtil.m_278158_((Entity)this, this::CanHitEntity);
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            this.Die();
        }
        if (this.m_20096_()) {
            this.Die();
        }
    }

    public void Die() {
        Item i;
        if (this.itemToSpawn != null && !this.itemToSpawn.isEmpty() && (i = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(this.itemToSpawn))) != null && i != Items.f_41852_ && ((Boolean)FlansModConfig.AllowBulletCasingDrops.get()).booleanValue()) {
            ItemStack casing = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(this.itemToSpawn)), 1);
            ItemEntity created = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), casing);
            created.m_32060_();
            created.m_32060_();
            this.m_9236_().m_7967_((Entity)created);
        }
        if (!this.m_9236_().f_46443_) {
            this.m_6074_();
        }
    }

    private boolean CanHitEntity(Entity entity) {
        return true;
    }
}

