/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.projectiles;

import com.flansmod.common.projectiles.BulletEntity;
import com.flansmod.common.types.bullets.elements.ProjectileDefinition;
import java.util.ArrayList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BulletGuidance {
    public GuidanceType mode = GuidanceType.NONE;

    public static Vec3 BeamRide(BulletEntity bullet, Vec3 motionIn) {
        Entity e = bullet.GetContext().ActionGroup.Gun.GetShooter().Entity();
        if (e == null) {
            return motionIn;
        }
        Vec3 target = e.m_146892_();
        double distance = target.m_82554_(bullet.m_20182_());
        target = e.m_146892_().m_82549_(e.m_20154_().m_82490_(distance += 2.0));
        return BulletGuidance.RotateTo(bullet, motionIn, target);
    }

    public static Vec3 BeamRideTop(BulletEntity bullet, Vec3 motionIn) {
        Vec3 target;
        if (bullet.GetContext().ActionGroup.Gun.GetShooter().Entity() == null) {
            return motionIn;
        }
        Vec3 initTarget = target = BulletGuidance.GetLookingAt(bullet.GetContext().ActionGroup.Gun.GetShooter().Entity(), 128.0f);
        double lateralDist = BulletGuidance.lateralDistance(bullet.m_20182_(), initTarget);
        if (lateralDist > (double)bullet.GetContext().GetProjectileDef().topAttackRange) {
            Vec3 currentFlat = new Vec3(bullet.m_20182_().f_82479_, 0.0, bullet.m_20182_().f_82481_);
            Vec3 targetFlat = new Vec3(initTarget.f_82479_, 0.0, initTarget.f_82481_);
            Vec3 dir = targetFlat.m_82546_(currentFlat);
            dir = dir.m_82541_();
            target = bullet.m_20182_().m_82549_(dir.m_82490_((double)bullet.GetContext().GetProjectileDef().topAttackHeight));
            target = new Vec3(target.f_82479_, Math.max(bullet.GetContext().ActionGroup.Gun.GetShooter().Entity().m_20182_().f_82480_ + (double)bullet.GetContext().GetProjectileDef().topAttackHeight, initTarget.f_82480_ + (double)bullet.GetContext().GetProjectileDef().topAttackHeight), target.f_82481_);
        }
        return BulletGuidance.RotateTo(bullet, motionIn, target);
    }

    public static Vec3 TopAttackLocked(BulletEntity bullet, Vec3 motionIn) {
        if (bullet.GetContext().ActionGroup.Gun.GetShooter().Entity() == null) {
            return motionIn;
        }
        if (bullet.LockedOnTo == null) {
            return motionIn;
        }
        Vec3 target = bullet.LockedOnTo.m_20182_();
        double lateralDist = BulletGuidance.lateralDistance(bullet.m_20182_(), bullet.LockedOnTo.m_20182_());
        if (lateralDist > (double)bullet.GetContext().GetProjectileDef().topAttackRange) {
            Vec3 currentFlat = new Vec3(bullet.m_20182_().f_82479_, 0.0, bullet.m_20182_().f_82481_);
            Vec3 targetFlat = new Vec3(bullet.LockedOnTo.m_20182_().f_82479_, 0.0, bullet.LockedOnTo.m_20182_().f_82481_);
            Vec3 dir = targetFlat.m_82546_(currentFlat);
            dir = dir.m_82541_();
            target = bullet.m_20182_().m_82549_(dir.m_82490_(3.0));
            target = new Vec3(target.f_82479_, Math.max(bullet.GetContext().ActionGroup.Gun.GetShooter().Entity().m_20182_().f_82480_ + (double)bullet.GetContext().GetProjectileDef().topAttackHeight, bullet.LockedOnTo.m_20182_().f_82480_ + (double)bullet.GetContext().GetProjectileDef().topAttackHeight), target.f_82481_);
        }
        return BulletGuidance.RotateTo(bullet, motionIn, target);
    }

    public static Vec3 RotateTowards(BulletEntity bullet, Vec3 motionIn) {
        if (bullet.LockedOnTo == null) {
            return motionIn;
        }
        if (!BulletGuidance.checkTrack(bullet, bullet.LockedOnTo)) {
            return motionIn;
        }
        return BulletGuidance.RotateTo(bullet, motionIn, bullet.LockedOnTo.m_20182_());
    }

    public static Vec3 RotateTowardsProportional(BulletEntity bullet, Vec3 motionIn) {
        if (bullet.LockedOnTo == null) {
            return motionIn;
        }
        if (!BulletGuidance.checkTrack(bullet, bullet.LockedOnTo)) {
            return motionIn;
        }
        float distance = bullet.m_20270_(bullet.LockedOnTo);
        float speed = (float)motionIn.m_82553_();
        float timeToReach = distance / speed;
        Vec3 predicted = bullet.LockedOnTo.m_20182_().m_82549_(bullet.LockedOnTo.m_20184_().m_82490_((double)timeToReach));
        return BulletGuidance.RotateTo(bullet, motionIn, predicted);
    }

    public static Vec3 RotateTo(BulletEntity bullet, Vec3 current, Vec3 target) {
        double speed = current.m_82553_();
        current = current.m_82541_();
        Vec3 targetDir = target.m_82546_(bullet.m_20182_()).m_82541_();
        float rotAngle = (float)Math.acos(current.m_82526_(targetDir));
        Vec3 rotAxis = current.m_82537_(targetDir).m_82541_();
        return BulletGuidance.rotateVector(current.m_82490_(speed), rotAxis, Math.min(rotAngle, bullet.GetContext().TurnRate()));
    }

    public static Vec3 rotateVector(Vec3 vec, Vec3 axis, double theta) {
        double x = vec.m_7096_();
        double y = vec.m_7098_();
        double z = vec.m_7094_();
        double u = axis.m_7096_();
        double v = axis.m_7098_();
        double w = axis.m_7094_();
        double xPrime = u * (u * x + v * y + w * z) * (1.0 - Math.cos(theta)) + x * Math.cos(theta) + (-w * y + v * z) * Math.sin(theta);
        double yPrime = v * (u * x + v * y + w * z) * (1.0 - Math.cos(theta)) + y * Math.cos(theta) + (w * x - u * z) * Math.sin(theta);
        double zPrime = w * (u * x + v * y + w * z) * (1.0 - Math.cos(theta)) + z * Math.cos(theta) + (-v * x + u * y) * Math.sin(theta);
        return new Vec3(xPrime, yPrime, zPrime);
    }

    public static double lateralDistance(Vec3 p1, Vec3 p2) {
        double d0 = p1.f_82479_ - p2.f_82479_;
        double d2 = p1.f_82481_ - p2.f_82481_;
        return Math.sqrt(d0 * d0 + d2 * d2);
    }

    public static boolean checkLock(Entity origin, Entity target, ProjectileDefinition bulletDef) {
        Vec3 v1 = origin.m_20154_();
        Vec3 v2 = target.m_20182_().m_82546_(origin.m_20182_());
        v2 = v2.m_82541_();
        return BulletGuidance.checkWithinCone(v1, v2, bulletDef.lockCone);
    }

    public static boolean checkLock(Entity origin, Entity target, float lockCone) {
        Vec3 v1 = origin.m_20154_();
        Vec3 v2 = target.m_20182_().m_82546_(origin.m_20182_());
        v2 = v2.m_82541_();
        return BulletGuidance.checkWithinCone(v1, v2, lockCone);
    }

    public static boolean checkTrack(Entity origin, Entity target, ProjectileDefinition bulletDef) {
        Vec3 v1 = origin.m_20154_();
        Vec3 v2 = target.m_20182_().m_82546_(origin.m_20182_());
        v2 = v2.m_82541_();
        return BulletGuidance.checkWithinCone(v1, v2, bulletDef.trackCone);
    }

    public static boolean checkTrack(BulletEntity bullet, Entity target) {
        Vec3 v1 = bullet.m_20184_();
        Vec3 v2 = target.m_20182_().m_82546_(bullet.m_20182_());
        v2 = v2.m_82541_();
        return BulletGuidance.checkWithinCone(v1, v2, bullet.GetContext().TrackCone());
    }

    public static boolean checkLock(BulletEntity bullet, Entity target) {
        Vec3 v1 = bullet.m_20184_();
        Vec3 v2 = target.m_20182_().m_82546_(bullet.m_20182_());
        return BulletGuidance.checkWithinCone(v1, v2 = v2.m_82541_(), bullet.GetContext().LockCone()) && BulletGuidance.CanSeeEntity((Entity)bullet, target);
    }

    public static boolean checkWithinCone(Vec3 v1, Vec3 v2, float coneSize) {
        double dot = v1.m_82526_(v2);
        double v1Length = v1.m_82553_();
        double v2Length = v2.m_82553_();
        double angle = Math.acos(dot / (v1Length * v2Length));
        return (angle = Math.toDegrees(angle)) < (double)coneSize;
    }

    public static Entity getLockOnTarget(ArrayList<Class> targetTypes, BulletEntity bullet) {
        return BulletGuidance.getLockOnTarget(targetTypes, (Entity)bullet, bullet.GetContext().LockRange(), bullet.GetContext().LockCone());
    }

    public static Entity getLockOnTarget(ArrayList<Class> targetTypes, Entity shooter, ProjectileDefinition def) {
        return BulletGuidance.getLockOnTarget(targetTypes, shooter, def.lockRange, def.lockCone);
    }

    public static Entity getLockOnTarget(ArrayList<Class> targetTypes, Entity shooter, float lockRange, float lockCone) {
        float closestRange = 90000.0f;
        Entity closest = null;
        for (Class c : targetTypes) {
            for (Object nearest : shooter.m_9236_().m_45976_(c, new AABB(shooter.m_20185_() - (double)lockRange, shooter.m_20186_() - (double)lockRange, shooter.m_20189_() - (double)lockRange, shooter.m_20185_() + (double)lockRange, shooter.m_20186_() + (double)lockRange, shooter.m_20189_() + (double)lockRange))) {
                if (!(shooter.m_20270_((Entity)nearest) < closestRange) || !BulletGuidance.checkLock(shooter, (Entity)nearest, lockCone) || !BulletGuidance.CanSeeEntity(shooter, (Entity)nearest)) continue;
                closestRange = shooter.m_20270_((Entity)nearest);
                closest = (Entity)nearest;
            }
        }
        return closest;
    }

    public static GuidanceType GuidanceType(ProjectileDefinition projectileDef) {
        if (projectileDef == null) {
            return GuidanceType.NONE;
        }
        return BulletGuidance.GuidanceType(projectileDef.guidanceType);
    }

    public static GuidanceType GuidanceType(String type) {
        return switch (type) {
            case "beam_riding" -> GuidanceType.BEAM_RIDING;
            case "beam_riding_top" -> GuidanceType.BEAM_RIDING_TOP;
            case "beam_and_lock" -> GuidanceType.BEAM_AND_LOCK;
            case "beam_and_lock_top" -> GuidanceType.BEAM_AND_LOCK_TOP;
            case "lock_on" -> GuidanceType.LOCKON_SIMPLE;
            case "lock_on_predictive" -> GuidanceType.LOCKON_LEADING;
            case "lock_on_top" -> GuidanceType.LOCKON_TOP;
            default -> GuidanceType.NONE;
        };
    }

    public static boolean HasLockOn(String type) {
        return switch (type) {
            case "beam_and_lock" -> true;
            case "beam_and_lock_top" -> true;
            case "lock_on" -> true;
            case "lock_on_predictive" -> true;
            case "lock_on_top" -> true;
            default -> false;
        };
    }

    public static boolean CanSeeEntity(Entity e1, Entity e2) {
        return BulletGuidance.CanSee(e1.m_146892_(), e2.m_20182_(), e1.m_9236_());
    }

    public static boolean CanSee(Vec3 v1, Vec3 v2, Level level) {
        double distance = v1.m_82554_(v2);
        Vec3 dir = v2.m_82546_(v1);
        dir = dir.m_82541_();
        ClipContext clipContext = new ClipContext(v1, v2, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null);
        BlockHitResult blockHit = level.m_45547_(clipContext);
        return blockHit.m_6662_() == HitResult.Type.MISS;
    }

    public static Vec3 GetLookingAt(Entity e1, float maxRange) {
        Vec3 pos1 = e1.m_146892_();
        Vec3 pos2 = pos1.m_82549_(e1.m_20154_().m_82490_((double)maxRange));
        ClipContext clipContext = new ClipContext(pos1, pos2, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null);
        BlockHitResult blockHit = e1.m_9236_().m_45547_(clipContext);
        if (blockHit.m_6662_() != HitResult.Type.MISS) {
            return blockHit.m_82450_();
        }
        return pos2;
    }

    public static enum GuidanceType {
        NONE,
        BEAM_RIDING,
        BEAM_RIDING_TOP,
        BEAM_AND_LOCK,
        BEAM_AND_LOCK_TOP,
        LOCKON_SIMPLE,
        LOCKON_LEADING,
        LOCKON_TOP;

    }
}

