/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.projectiles;

import com.flansmod.client.render.FlanItemModelRenderer;
import com.flansmod.client.render.models.FlansModelRegistry;
import com.flansmod.common.FlansMod;
import com.flansmod.common.actions.ActionGroupInstance;
import com.flansmod.common.actions.ActionStack;
import com.flansmod.common.actions.contexts.ActionGroupContext;
import com.flansmod.common.actions.contexts.GunContext;
import com.flansmod.common.actions.contexts.GunshotContext;
import com.flansmod.common.actions.contexts.ShooterContext;
import com.flansmod.common.gunshots.Gunshot;
import com.flansmod.common.network.FlansEntityDataSerializers;
import com.flansmod.common.projectiles.BulletGuidance;
import com.flansmod.common.types.bullets.BulletDefinition;
import com.flansmod.common.types.bullets.elements.EProjectileResponseType;
import com.flansmod.common.types.bullets.elements.ProjectileDefinition;
import com.flansmod.common.types.bullets.elements.TrailDefinition;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.Transform;
import com.flansmod.physics.common.util.TransformStack;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Vector3f;

public class BulletEntity
extends Projectile {
    private static final EntityDataAccessor<Optional<UUID>> DATA_OWNER_UUID = SynchedEntityData.m_135353_(BulletEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_SHOOTER_UUID = SynchedEntityData.m_135353_(BulletEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_GUN_ID = SynchedEntityData.m_135353_(BulletEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<BulletDefinition> DATA_BULLET_DEF = SynchedEntityData.m_135353_(BulletEntity.class, FlansEntityDataSerializers.BULLET_DEF);
    private static final EntityDataAccessor<Integer> DATA_ACTION_GROUP_PATH_HASH = SynchedEntityData.m_135353_(BulletEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_SHOT_INDEX = SynchedEntityData.m_135353_(BulletEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_LOCK_ID = SynchedEntityData.m_135353_(BulletEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_LIFETIME = SynchedEntityData.m_135353_(BulletEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Nullable
    public Entity LockedOnTo = null;
    public float RemainingPenetratingPower = 0.0f;
    public int FuseRemaining = 0;
    public int lockId = 0;
    public boolean Stuck = false;
    public boolean Detonated = false;
    public final ActionStack Actions;
    public int lifeTime = 0;

    public void SetOwnerID(@Nonnull UUID ownerID) {
        this.f_19804_.m_135381_(DATA_OWNER_UUID, Optional.of(ownerID));
    }

    public void SetShooterID(@Nonnull UUID shooterID) {
        this.f_19804_.m_135381_(DATA_SHOOTER_UUID, Optional.of(shooterID));
    }

    public void SetGunID(@Nonnull UUID gunID) {
        this.f_19804_.m_135381_(DATA_GUN_ID, Optional.of(gunID));
    }

    public void SetActionGroupPathHash(int hash) {
        this.f_19804_.m_135381_(DATA_ACTION_GROUP_PATH_HASH, (Object)hash);
    }

    public void SetBulletDef(@Nonnull BulletDefinition bulletDef) {
        this.f_19804_.m_135381_(DATA_BULLET_DEF, (Object)bulletDef);
    }

    public void SetShotIndex(int index) {
        this.f_19804_.m_135381_(DATA_SHOT_INDEX, (Object)index);
    }

    public void SetLockID(int index) {
        this.f_19804_.m_135381_(DATA_LOCK_ID, (Object)index);
    }

    @Nonnull
    public UUID GetOwnerID() {
        return ((Optional)this.f_19804_.m_135370_(DATA_OWNER_UUID)).orElse(ShooterContext.InvalidID);
    }

    @Nonnull
    public UUID GetShooterID() {
        return ((Optional)this.f_19804_.m_135370_(DATA_SHOOTER_UUID)).orElse(ShooterContext.InvalidID);
    }

    @Nonnull
    public UUID GetGunID() {
        return ((Optional)this.f_19804_.m_135370_(DATA_GUN_ID)).orElse(GunContext.INVALID.GetUUID());
    }

    public int GetActionGroupPathHash() {
        return (Integer)this.f_19804_.m_135370_(DATA_ACTION_GROUP_PATH_HASH);
    }

    @Nonnull
    public BulletDefinition GetBulletDef() {
        return (BulletDefinition)this.f_19804_.m_135370_(DATA_BULLET_DEF);
    }

    public int GetShotIndex() {
        return (Integer)this.f_19804_.m_135370_(DATA_SHOT_INDEX);
    }

    public int GetLockID() {
        return (Integer)this.f_19804_.m_135370_(DATA_LOCK_ID);
    }

    @Nullable
    public ProjectileDefinition GetProjectileDef() {
        BulletDefinition bulletDef = this.GetBulletDef();
        int shotIndex = this.GetShotIndex();
        if (0 <= shotIndex && shotIndex < bulletDef.projectiles.length) {
            return bulletDef.projectiles[shotIndex];
        }
        return null;
    }

    @Nonnull
    public GunshotContext GetContext() {
        ShooterContext shooter = ShooterContext.of(this.GetShooterID(), this.GetOwnerID());
        GunContext gun = shooter.CreateContext(this.GetGunID());
        ActionGroupContext actionGroup = gun.GetActionGroupContextByHash(this.GetActionGroupPathHash());
        return GunshotContext.projectile(actionGroup, this.GetBulletDef(), this.GetShotIndex());
    }

    @Nullable
    public Entity Owner() {
        return this.m_9236_().m_46003_(this.GetOwnerID());
    }

    @Nullable
    public Entity GetShooter() {
        return this.m_9236_().m_46003_(this.GetOwnerID());
    }

    public BulletEntity(EntityType<? extends BulletEntity> entityType, Level level) {
        super(entityType, level);
        this.Actions = new ActionStack(level.f_46443_);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_OWNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(DATA_SHOOTER_UUID, Optional.empty());
        this.f_19804_.m_135372_(DATA_GUN_ID, Optional.empty());
        this.f_19804_.m_135372_(DATA_BULLET_DEF, (Object)BulletDefinition.INVALID);
        this.f_19804_.m_135372_(DATA_SHOT_INDEX, (Object)0);
        this.f_19804_.m_135372_(DATA_LOCK_ID, (Object)-1);
        this.f_19804_.m_135372_(DATA_ACTION_GROUP_PATH_HASH, (Object)0);
        this.f_19804_.m_135372_(DATA_LIFETIME, (Object)0);
    }

    public void SetLockOnTarget(Entity e) {
        this.LockedOnTo = e;
    }

    public void InitContext(@Nonnull GunshotContext context) {
        float fuseTime;
        Entity e;
        this.SetOwnerID(context.ActionGroup.Gun.GetShooter().OwnerUUID());
        this.SetShooterID(context.ActionGroup.Gun.GetShooter().EntityUUID());
        this.SetGunID(context.ActionGroup.Gun.GetUUID());
        this.SetActionGroupPathHash(context.ActionGroup.GroupPath.hashCode());
        this.SetBulletDef(context.Bullet);
        this.SetShotIndex(context.DefIndex);
        this.LockedOnTo = e = context.ActionGroup.Gun.GetLockTarget();
        if (e != null) {
            this.SetLockID(e.m_19879_());
        }
        if ((fuseTime = context.FuseTimeSeconds()) > 0.0f) {
            this.FuseRemaining = Maths.ceil(fuseTime * 20.0f);
            ActionGroupInstance group = context.ActionGroup.Gun.GetOrCreateActionGroup(context.ActionGroup);
            if (group.GetProgressTicks() > 0) {
                this.FuseRemaining -= group.GetProgressTicks();
            }
        }
        this.lifeTime = 0;
    }

    public boolean m_6783_(double p_19883_) {
        double d0 = this.m_20191_().m_82309_();
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return p_19883_ < (d0 *= 64.0 * BulletEntity.m_20150_() * 6.0) * d0;
    }

    public void SetVelocity(Vec3 velocity) {
        this.m_20256_(velocity);
        this.m_146867_();
    }

    private void RecalculateFacing(Vec3 motion) {
        double xz = Maths.sqrt(motion.f_82479_ * motion.f_82479_ + motion.f_82481_ * motion.f_82481_);
        float yawDeg = (float)Maths.atan2(motion.f_82479_, motion.f_82481_) * 57.29578f;
        float pitchDeg = (float)Maths.atan2(motion.f_82480_, xz) * 57.29578f;
        float turnRate = this.GetContext().TurnRate();
        pitchDeg = Maths.lerpDegrees(this.m_146909_(), pitchDeg, Math.min(turnRate * 20.0f, 1.0f));
        yawDeg = Maths.lerpDegrees(this.m_146908_(), yawDeg, Math.min(turnRate * 20.0f, 1.0f));
        this.m_146926_(pitchDeg);
        this.m_146922_(yawDeg);
    }

    private void RefreshLockOnTarget() {
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.Stuck) {
            this.m_20256_(Vec3.f_82478_);
        }
        Vec3 motion = this.m_20184_();
        motion = this.Accelerate(motion);
        motion = this.ApplyDrag(motion);
        motion = this.ApplyGravity(motion);
        this.m_20256_(motion);
        motion = this.OnImpact(motion);
        ProjectileDefinition def = this.GetContext().GetProjectileDef();
        if (this.GetLockID() != -1) {
            this.LockedOnTo = this.m_9236_().m_6815_(this.GetLockID());
        }
        if (def == null) {
            if (!this.m_9236_().f_46443_) {
                this.m_6074_();
            }
            return;
        }
        switch (def.GetGuidanceMode()) {
            case LOCKON_SIMPLE: {
                this.RefreshLockOnTarget();
                break;
            }
            case LOCKON_LEADING: {
                this.RefreshLockOnTarget();
            }
        }
        if (this.LockedOnTo != null && this.LockedOnTo.m_213877_()) {
            this.LockedOnTo = null;
        }
        switch (def.GetGuidanceMode()) {
            case BEAM_RIDING: {
                motion = BulletGuidance.BeamRide(this, motion);
                break;
            }
            case BEAM_RIDING_TOP: {
                motion = BulletGuidance.BeamRideTop(this, motion);
                break;
            }
            case BEAM_AND_LOCK: {
                if (this.LockedOnTo == null) {
                    motion = BulletGuidance.BeamRide(this, motion);
                    break;
                }
                motion = BulletGuidance.RotateTowardsProportional(this, motion);
                break;
            }
            case BEAM_AND_LOCK_TOP: {
                if (this.LockedOnTo == null) {
                    motion = BulletGuidance.BeamRideTop(this, motion);
                    break;
                }
                motion = BulletGuidance.TopAttackLocked(this, motion);
                break;
            }
            case LOCKON_SIMPLE: {
                motion = BulletGuidance.RotateTowards(this, motion);
                break;
            }
            case LOCKON_LEADING: {
                motion = BulletGuidance.RotateTowardsProportional(this, motion);
                break;
            }
            case LOCKON_TOP: {
                motion = BulletGuidance.TopAttackLocked(this, motion);
            }
        }
        this.m_6478_(MoverType.SELF, motion);
        this.m_20256_(motion);
        this.RecalculateFacing(motion);
        this.UpdateFuse();
        Vec3 origin = this.m_20182_();
        Vec3 look = motion.m_82541_();
        if (this.m_9236_().m_5776_()) {
            this.SpawnTrail();
        }
        ++this.lifeTime;
    }

    protected Vec3 Accelerate(Vec3 motion) {
        double currSpeed;
        if (this.GetContext().Acceleration() > 0.0f && (currSpeed = motion.m_82553_()) < (double)this.GetContext().MaxSpeed() / 20.0) {
            float acc = this.GetContext().Acceleration() / 20.0f;
            motion = motion.m_82541_().m_82490_(currSpeed + (double)acc);
        }
        return motion;
    }

    public void SpawnTrail() {
        BulletDefinition def = this.GetContext().Bullet;
        ResourceLocation loc = def.Location;
        FlanItemModelRenderer bulletRenderer = (FlanItemModelRenderer)FlansModelRegistry.GetItemRenderer(loc);
        for (TrailDefinition trail : this.GetContext().GetProjectileDef().particleTrails) {
            if (this.m_20069_() && !trail.spawnUnderwater || !this.m_20069_() && trail.onlySpawnUnderwater || this.lifeTime < trail.fromTick || this.lifeTime >= trail.toTick) continue;
            for (String apName : trail.spawnPoints) {
                TransformStack transformStack = TransformStack.empty();
                transformStack.add(Transform.fromPosAndEuler(this.m_20182_(), new Vector3f(this.m_146909_(), -this.m_146908_() + 90.0f, (float)this.lifeTime)));
                bulletRenderer.ApplyAPOffsetInternal(transformStack, apName, null, null);
                Transform point = transformStack.top();
                Vec3 position = transformStack.localToGlobalPosition(Vec3.f_82478_);
                Vec3 look = transformStack.right();
                float speed = trail.speed;
                ParticleOptions particle = (ParticleOptions)ForgeRegistries.PARTICLE_TYPES.getValue(new ResourceLocation(trail.particle));
                if (particle == null) continue;
                Minecraft.m_91087_().f_91073_.m_7106_(particle, position.m_7096_(), position.m_7098_(), position.m_7094_(), look.m_7096_() * (double)speed, look.m_7098_() * (double)speed, look.m_7094_() * (double)speed);
            }
        }
    }

    protected Vec3 ApplyDrag(Vec3 motion) {
        if (this.m_20069_()) {
            return motion.m_82490_((double)Maths.clamp(1.0f - this.GetContext().DragInWater(), 0.0f, 1.0f));
        }
        return motion.m_82490_((double)Maths.clamp(1.0f - this.GetContext().DragInAir(), 0.0f, 1.0f));
    }

    protected Vec3 ApplyGravity(Vec3 motion) {
        if (this.m_20068_() || this.Stuck) {
            return motion;
        }
        return new Vec3(motion.f_82479_, motion.f_82480_ - (double)this.GetContext().GravityFactor() * 0.02, motion.f_82481_);
    }

    protected void UpdateFuse() {
        if (!this.m_9236_().f_46443_ && this.GetContext().FuseTimeSeconds() > 0.0f) {
            --this.FuseRemaining;
            if (this.FuseRemaining <= 0) {
                this.Detonate((HitResult)BlockHitResult.m_82426_((Vec3)this.m_20182_(), (Direction)Direction.DOWN, (BlockPos)this.m_20183_()));
            }
        }
    }

    protected Vec3 OnImpact(Vec3 motion) {
        HitResult hitResult = ProjectileUtil.m_278158_((Entity)this, this::CanHitEntity);
        EProjectileResponseType responseType = switch (hitResult.m_6662_()) {
            default -> throw new IncompatibleClassChangeError();
            case HitResult.Type.MISS -> EProjectileResponseType.PassThrough;
            case HitResult.Type.ENTITY -> this.GetContext().ResponseToEntity();
            case HitResult.Type.BLOCK -> this.GetContext().ResponseToBlock();
        };
        switch (responseType) {
            case PassThrough: {
                return motion;
            }
            case Stick: {
                this.Stuck = true;
                return Vec3.f_82478_;
            }
            case Detonate: {
                this.Detonate(hitResult);
                return Vec3.f_82478_;
            }
            case Bounce: {
                BlockHitResult blockHitResult = (BlockHitResult)hitResult;
                return switch (blockHitResult.m_82434_()) {
                    default -> throw new IncompatibleClassChangeError();
                    case Direction.UP, Direction.DOWN -> new Vec3(motion.f_82479_, -motion.f_82480_, motion.f_82481_);
                    case Direction.EAST, Direction.WEST -> new Vec3(-motion.f_82479_, motion.f_82480_, motion.f_82481_);
                    case Direction.NORTH, Direction.SOUTH -> new Vec3(motion.f_82479_, motion.f_82480_, -motion.f_82481_);
                };
            }
        }
        return motion;
    }

    private boolean CanHitEntity(Entity entity) {
        return true;
    }

    public void Detonate(HitResult hit) {
        if (!this.Detonated) {
            Gunshot shot = new Gunshot();
            shot.fromShotIndex = 0;
            shot.bulletDef = this.GetBulletDef();
            shot.origin = this.m_20182_();
            shot.trajectory = this.m_20184_();
            shot.hits = new HitResult[]{hit};
            this.GetContext().ProcessShot(shot);
            this.Detonated = true;
        }
        if (!this.m_9236_().f_46443_) {
            this.m_6074_();
        }
    }

    public void m_7380_(CompoundTag tags) {
        tags.m_128359_("bullet", this.GetBulletDef().Location.toString());
        tags.m_128405_("fuse", this.FuseRemaining);
        tags.m_128379_("stuck", this.Stuck);
        tags.m_128405_("lockTarget", this.lockId);
        CompoundTag contextTags = new CompoundTag();
        this.GetContext().Save(contextTags);
        tags.m_128365_("context", (Tag)contextTags);
        tags.m_128405_("lifeTime", this.lifeTime);
    }

    public void m_7378_(CompoundTag tags) {
        if (tags.m_128441_("bullet")) {
            this.SetBulletDef((BulletDefinition)FlansMod.BULLETS.Get(new ResourceLocation(tags.m_128461_("bullet"))));
        }
        this.FuseRemaining = tags.m_128451_("fuse");
        this.Stuck = tags.m_128471_("stuck");
        this.lockId = tags.m_128451_("lockTarget");
        GunshotContext context = GunshotContext.Load(tags.m_128469_("context"), this.m_9236_().f_46443_);
        this.InitContext(context);
        this.LockedOnTo = this.m_9236_().m_6815_(tags.m_128451_("lockTarget"));
        this.lifeTime = tags.m_128451_("lifeTime");
    }

    public void m_20254_(int i) {
    }

    public boolean m_6094_() {
        return false;
    }
}

