/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.network.bidirectional;

import com.flansmod.common.actions.ActionGroupInstance;
import com.flansmod.common.actions.ActionInstance;
import com.flansmod.common.actions.Actions;
import com.flansmod.common.actions.contexts.ActionGroupContext;
import com.flansmod.common.actions.contexts.GunContext;
import com.flansmod.common.actions.contexts.ShooterContext;
import com.flansmod.common.gunshots.EPressType;
import com.flansmod.common.network.FlansModMessage;
import com.flansmod.common.network.elements.ActionGroupNetID;
import com.flansmod.physics.common.util.MinecraftHelpers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;

public class ActionUpdateMessage
extends FlansModMessage {
    private long StartTick;
    private final ActionGroupNetID Context;
    private EPressType PressType;
    private final HashMap<Integer, ActionTriggerInfo> Triggers = new HashMap();

    public EPressType GetPressType() {
        return this.PressType;
    }

    public Set<Map.Entry<Integer, ActionTriggerInfo>> GetTriggers() {
        return this.Triggers.entrySet();
    }

    public long GetStartTick() {
        return this.StartTick;
    }

    public int GetFirstTriggerIndex() {
        int firstIndex = Integer.MAX_VALUE;
        for (int triggerIndex : this.Triggers.keySet()) {
            if (triggerIndex >= firstIndex) continue;
            firstIndex = triggerIndex;
        }
        return firstIndex == Integer.MAX_VALUE ? -1 : firstIndex;
    }

    public int GetLastTriggerIndex() {
        int lastIndex = -1;
        for (int triggerIndex : this.Triggers.keySet()) {
            if (triggerIndex <= lastIndex) continue;
            lastIndex = triggerIndex;
        }
        return lastIndex;
    }

    public long GetFirstTriggerTick() {
        long firstTick = Long.MAX_VALUE;
        for (ActionTriggerInfo trigger : this.Triggers.values()) {
            if ((long)trigger.DeltaTick + this.StartTick >= firstTick) continue;
            firstTick = (long)trigger.DeltaTick + this.StartTick;
        }
        return firstTick == Long.MAX_VALUE ? -1L : firstTick;
    }

    public long GetLastTriggerTick() {
        long lastTick = -1L;
        for (ActionTriggerInfo trigger : this.Triggers.values()) {
            if ((long)trigger.DeltaTick + this.StartTick <= lastTick) continue;
            lastTick = (long)trigger.DeltaTick + this.StartTick;
        }
        return lastTick;
    }

    @Nonnull
    public ActionGroupContext GetActionGroupContext(boolean client) {
        ShooterContext shooterContext = ShooterContext.of(this.Context.ShooterID, this.Context.ShooterID, client);
        if (!shooterContext.IsValid()) {
            return ActionGroupContext.INVALID;
        }
        GunContext gunContext = GunContext.of(shooterContext, this.Context.GunID);
        if (!gunContext.IsValid()) {
            return ActionGroupContext.INVALID;
        }
        return gunContext.GetActionGroupContextByHash(this.Context.GroupPathHash);
    }

    public ActionUpdateMessage() {
        this.Context = new ActionGroupNetID();
    }

    public ActionUpdateMessage(ActionGroupContext actionGroupContext, EPressType pressType, long startTick) {
        this.StartTick = startTick;
        this.Context = new ActionGroupNetID(actionGroupContext.Gun.GetShooter().ShooterID(), actionGroupContext.GroupPath.hashCode(), actionGroupContext.Gun.GetInventorySlotIndex(), actionGroupContext.Gun.GetUUID());
        this.PressType = pressType;
    }

    public ActionInstance.NetData GetNetData(int triggerIndex, int actionIndex) {
        ActionTriggerInfo triggerInfo = this.Triggers.get(triggerIndex);
        if (triggerInfo != null && actionIndex < triggerInfo.NetData.size()) {
            return triggerInfo.NetData.get(actionIndex);
        }
        return ActionInstance.NetData.Invalid;
    }

    public void AddTriggers(ActionGroupInstance group, int triggerIndexMin, int triggerIndexMax) {
        for (int i = triggerIndexMin; i <= triggerIndexMax; ++i) {
            ActionTriggerInfo accumulatedNetData = new ActionTriggerInfo();
            accumulatedNetData.DeltaTick = (int)(MinecraftHelpers.getTick() - group.GetStartedTick());
            for (ActionInstance action : group.GetActions()) {
                accumulatedNetData.NetData.add(action.GetNetDataForTrigger(i));
            }
            this.Triggers.put(i, accumulatedNetData);
        }
    }

    @Override
    public void Encode(FriendlyByteBuf buf) {
        buf.writeByte(this.PressType.ordinal());
        buf.writeLong(this.StartTick);
        this.Context.Encode(buf);
        buf.writeInt(this.Triggers.size());
        for (Map.Entry<Integer, ActionTriggerInfo> kvp : this.Triggers.entrySet()) {
            buf.writeInt(kvp.getKey().intValue());
            buf.writeInt(kvp.getValue().DeltaTick);
            buf.writeInt(kvp.getValue().NetData.size());
            for (ActionInstance.NetData netData : kvp.getValue().NetData) {
                buf.writeInt(netData.GetID());
                netData.Encode(buf);
            }
        }
    }

    @Override
    public void Decode(FriendlyByteBuf buf) {
        this.PressType = EPressType.values()[buf.readByte()];
        this.StartTick = buf.readLong();
        this.Context.Decode(buf);
        int numTriggers = buf.readInt();
        for (int i = 0; i < numTriggers; ++i) {
            int triggerIndex = buf.readInt();
            int deltaTick = buf.readInt();
            int count = buf.readInt();
            ActionTriggerInfo triggerInfo = new ActionTriggerInfo();
            triggerInfo.DeltaTick = deltaTick;
            for (int j = 0; j < count; ++j) {
                int netDataType = buf.readInt();
                ActionInstance.NetData netData = Actions.CreateEmptyNetData(netDataType);
                netData.Decode(buf);
                triggerInfo.NetData.add(netData);
            }
            this.Triggers.put(triggerIndex, triggerInfo);
        }
    }

    public String toString() {
        return "ActionUpdate (" + this.PressType + ") @" + this.StartTick + "L - GunID:'" + this.Context.GunID + "', Slot: " + this.Context.InventorySlotIndex + ", #Triggers=" + this.Triggers.size();
    }

    public static class ActionTriggerInfo {
        public int DeltaTick;
        public List<ActionInstance.NetData> NetData = new ArrayList<ActionInstance.NetData>();
    }

    public static class ToClient
    extends FlansModMessage {
        public ActionUpdateMessage Data;

        public ToClient() {
            this.Data = new ActionUpdateMessage();
        }

        public ToClient(ActionUpdateMessage data) {
            this.Data = data;
        }

        @Override
        public void Encode(FriendlyByteBuf buf) {
            this.Data.Encode(buf);
        }

        @Override
        public void Decode(FriendlyByteBuf buf) {
            this.Data.Decode(buf);
        }
    }

    public static class ToServer
    extends FlansModMessage {
        public ActionUpdateMessage Data;

        public ToServer() {
            this.Data = new ActionUpdateMessage();
        }

        public ToServer(ActionUpdateMessage data) {
            this.Data = data;
        }

        @Override
        public void Encode(FriendlyByteBuf buf) {
            this.Data.Encode(buf);
        }

        @Override
        public void Decode(FriendlyByteBuf buf) {
            this.Data.Decode(buf);
        }
    }
}

