/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.gunshots;

import com.flansmod.common.gunshots.EPlayerHitArea;
import com.flansmod.physics.client.DebugRenderer;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.Transform;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class PlayerHitbox {
    public Transform transform;
    public Vector3f halfExtents;
    public EPlayerHitArea area;

    public PlayerHitbox(@Nonnull EPlayerHitArea hitArea, @Nonnull Transform trans, @Nonnull Vector3f half) {
        this.transform = trans;
        this.halfExtents = half;
        this.area = hitArea;
    }

    public boolean Raycast(@Nonnull Vec3 startPos, @Nonnull Vec3 endPos, @Nullable Vector3d outPos) {
        return Maths.rayBoxIntersect(startPos, endPos, this.transform, this.halfExtents, outPos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void debugRender(@Nonnull Vec3 withOffset, @Nonnull Vector4f colour) {
        Transform renderPos = Transform.compose(Transform.fromPos(withOffset), this.transform);
        DebugRenderer.renderCube(renderPos, 1, colour, this.halfExtents);
        DebugRenderer.renderAxes(renderPos, 1, new Vector4f(1.0f, 1.0f, 1.0f, 1.0f));
    }
}

