/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.entity.vehicle.modules;

import com.flansmod.common.entity.vehicle.PerPartMap;
import com.flansmod.common.entity.vehicle.hierarchy.VehicleComponentPath;
import com.flansmod.common.entity.vehicle.save.EngineSyncState;
import com.flansmod.common.types.parts.elements.EFuelType;
import com.flansmod.common.types.parts.elements.EngineDefinition;
import com.flansmod.physics.common.util.Maths;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.RecipeType;

public interface IVehicleEngineModule {
    @Nonnull
    public PerPartMap<EngineSyncState> GetEngineSaveData();

    public void SetEngineSaveData(@Nonnull PerPartMap<EngineSyncState> var1);

    public void ModifyEngineSaveData(@Nonnull VehicleComponentPath var1, @Nonnull Consumer<EngineSyncState> var2);

    @Nonnull
    public EngineDefinition GetDefaultEngine();

    @Nonnull
    default public EngineDefinition GetEngineDef(@Nonnull VehicleComponentPath enginePath) {
        return this.GetEngineSaveData().ApplyOrDefault(enginePath, EngineSyncState::GetEngine, this.GetDefaultEngine());
    }

    default public float GetThrottle(@Nonnull VehicleComponentPath enginePath) {
        return this.GetEngineSaveData().ApplyOrDefault(enginePath, EngineSyncState::GetEngineThrottle, Float.valueOf(0.0f)).floatValue();
    }

    default public int GetBurnTimeRemaining(@Nonnull VehicleComponentPath enginePath) {
        return this.GetEngineSaveData().ApplyOrDefault(enginePath, EngineSyncState::GetBurnTimeRemaining, Integer.valueOf(0));
    }

    default public int GetBurnTimeDuration(@Nonnull VehicleComponentPath enginePath) {
        return this.GetEngineSaveData().ApplyOrDefault(enginePath, EngineSyncState::GetBurnTimeDuration, Integer.valueOf(0));
    }

    default public int GetCurrentFE(@Nonnull VehicleComponentPath enginePath) {
        return this.GetEngineSaveData().ApplyOrDefault(enginePath, EngineSyncState::GetCurrentFE, Integer.valueOf(0));
    }

    default public int GetLiquidAmount(@Nonnull VehicleComponentPath enginePath) {
        return this.GetEngineSaveData().ApplyOrDefault(enginePath, EngineSyncState::GetLiquidAmount, Integer.valueOf(0));
    }

    default public int GetNextBurnableSlot(@Nonnull VehicleComponentPath enginePath, @Nonnull RecipeType<?> recipeType) {
        return this.GetEngineSaveData().ApplyOrDefault(enginePath, engineSave -> engineSave.GetNextBurnableSlot(recipeType), Integer.valueOf(-1));
    }

    default public int CountBurnTime(@Nonnull VehicleComponentPath enginePath, @Nonnull RecipeType<?> recipeType) {
        return this.GetEngineSaveData().ApplyOrDefault(enginePath, engineSave -> engineSave.CountBurnTime(recipeType), Integer.valueOf(-1));
    }

    default public int CountBurnableItems(@Nonnull VehicleComponentPath enginePath, @Nonnull RecipeType<?> recipeType) {
        return this.GetEngineSaveData().ApplyOrDefault(enginePath, engineSave -> engineSave.CountBurnableItems(recipeType), Integer.valueOf(-1));
    }

    default public float GetFuelConsumptionRate(@Nonnull VehicleComponentPath enginePath) {
        EngineDefinition engine = this.GetEngineDef(enginePath);
        float throttle = this.GetThrottle(enginePath);
        if (throttle <= 1.0f) {
            return Maths.lerpF(0.0f, engine.fuelConsumptionIdle, throttle);
        }
        return Maths.lerpF(engine.fuelConsumptionIdle, engine.fuelConsumptionFull, throttle - 1.0f);
    }

    default public boolean CanThrust(@Nullable Player player, @Nonnull VehicleComponentPath enginePath) {
        if (player != null && player.m_7500_()) {
            return true;
        }
        return this.CanThrust(enginePath);
    }

    default public boolean CanThrust(@Nonnull VehicleComponentPath enginePath) {
        EngineDefinition engine = this.GetEngineDef(enginePath);
        return switch (engine.fuelType) {
            case EFuelType.Creative -> true;
            case EFuelType.FE -> {
                if (this.GetCurrentFE(enginePath) > 0) {
                    yield true;
                }
                yield false;
            }
            default -> this.GetBurnTimeRemaining(enginePath) > 0;
        };
    }

    default public boolean CanBurnMoreFuel(@Nonnull VehicleComponentPath enginePath) {
        EngineDefinition engine = this.GetEngineDef(enginePath);
        return switch (engine.fuelType) {
            default -> throw new IncompatibleClassChangeError();
            case EFuelType.Creative -> true;
            case EFuelType.FE -> {
                if (this.GetCurrentFE(enginePath) > 0) {
                    yield true;
                }
                yield false;
            }
            case EFuelType.Liquid -> {
                if (this.GetLiquidAmount(enginePath) > 0) {
                    yield true;
                }
                yield false;
            }
            case EFuelType.Smeltable -> {
                if (this.GetNextBurnableSlot(enginePath, RecipeType.f_44108_) != -1) {
                    yield true;
                }
                yield false;
            }
            case EFuelType.Smokable -> {
                if (this.GetNextBurnableSlot(enginePath, RecipeType.f_44110_) != -1) {
                    yield true;
                }
                yield false;
            }
            case EFuelType.Blastable -> this.GetNextBurnableSlot(enginePath, RecipeType.f_44109_) != -1;
        };
    }

    default public int GetFuelFillLevel(@Nonnull VehicleComponentPath enginePath) {
        EngineDefinition engine = this.GetEngineDef(enginePath);
        return switch (engine.fuelType) {
            default -> throw new IncompatibleClassChangeError();
            case EFuelType.Creative -> 999;
            case EFuelType.FE -> this.GetCurrentFE(enginePath);
            case EFuelType.Liquid -> this.GetLiquidAmount(enginePath);
            case EFuelType.Smeltable -> this.CountBurnableItems(enginePath, RecipeType.f_44108_);
            case EFuelType.Smokable -> this.CountBurnableItems(enginePath, RecipeType.f_44110_);
            case EFuelType.Blastable -> this.CountBurnableItems(enginePath, RecipeType.f_44109_);
        };
    }

    default public int GetFuelMaxLevel(@Nonnull VehicleComponentPath enginePath) {
        EngineDefinition engine = this.GetEngineDef(enginePath);
        return switch (engine.fuelType) {
            default -> throw new IncompatibleClassChangeError();
            case EFuelType.Creative -> 999;
            case EFuelType.FE -> engine.FECapacity;
            case EFuelType.Liquid -> engine.liquidFuelCapacity;
            case EFuelType.Smeltable -> engine.solidFuelSlots * 64;
            case EFuelType.Smokable -> engine.solidFuelSlots * 64;
            case EFuelType.Blastable -> engine.solidFuelSlots * 64;
        };
    }

    default public void SetToOff(@Nonnull VehicleComponentPath enginePath) {
        this.SetThrottle(enginePath, 0.0f);
    }

    default public void SetToIdle(@Nonnull VehicleComponentPath enginePath) {
        this.SetThrottle(enginePath, 1.0f);
    }

    default public void SetToFull(@Nonnull VehicleComponentPath enginePath) {
        this.SetThrottle(enginePath, 2.0f);
    }

    default public void SetThrottle(@Nonnull VehicleComponentPath enginePath, float parameter) {
        this.ModifyEngineSaveData(enginePath, engineSaveData -> {
            engineSaveData.Throttle = parameter;
        });
    }
}

