/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.entity.vehicle.hierarchy;

import com.flansmod.common.entity.vehicle.hierarchy.EPartDefComponent;
import com.flansmod.common.entity.vehicle.hierarchy.VehicleComponentPath;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Either;
import java.util.Objects;
import javax.annotation.Nonnull;

public record VehiclePartPath(@Nonnull Either<Integer, ImmutableList<String>> Source) {
    public static final VehiclePartPath Invalid = new VehiclePartPath((Either<Integer, ImmutableList<String>>)Either.left((Object)0));
    public static final VehiclePartPath Core = new VehiclePartPath((Either<Integer, ImmutableList<String>>)Either.right((Object)ImmutableList.of()));

    @Nonnull
    public static VehiclePartPath of(int hash) {
        return new VehiclePartPath((Either<Integer, ImmutableList<String>>)Either.left((Object)hash));
    }

    @Nonnull
    public static VehiclePartPath of(@Nonnull ImmutableList<String> names) {
        return new VehiclePartPath((Either<Integer, ImmutableList<String>>)Either.right(names));
    }

    @Nonnull
    public static VehiclePartPath of(@Nonnull String string) {
        Object[] components = string.split("/");
        return new VehiclePartPath((Either<Integer, ImmutableList<String>>)Either.right((Object)ImmutableList.copyOf((Object[])components)));
    }

    @Nonnull
    public VehiclePartPath Compact() {
        return this.IsNamed() ? VehiclePartPath.of(this.hashCode()) : this;
    }

    public boolean IsRoot() {
        return (Boolean)this.Source.map(i -> i == 0, list -> list.size() == 0);
    }

    public boolean IsNamed() {
        return this.Source.right().isPresent();
    }

    @Nonnull
    public VehicleComponentPath Damageable() {
        return VehicleComponentPath.of(this, EPartDefComponent.Damage, 0);
    }

    @Nonnull
    public VehicleComponentPath Articulation() {
        return VehicleComponentPath.of(this, EPartDefComponent.Articulation, 0);
    }

    @Nonnull
    public VehicleComponentPath Arm(int index) {
        return VehicleComponentPath.of(this, EPartDefComponent.Arm, index);
    }

    @Nonnull
    public VehicleComponentPath Leg(int index) {
        return VehicleComponentPath.of(this, EPartDefComponent.Leg, index);
    }

    @Nonnull
    public VehicleComponentPath Seat(int index) {
        return VehicleComponentPath.of(this, EPartDefComponent.Seat, index);
    }

    @Nonnull
    public VehicleComponentPath Gun(int index) {
        return VehicleComponentPath.of(this, EPartDefComponent.Gun, index);
    }

    @Nonnull
    public VehicleComponentPath Wheel(int index) {
        return VehicleComponentPath.of(this, EPartDefComponent.Wheel, index);
    }

    @Nonnull
    public VehicleComponentPath Propeller(int index) {
        return VehicleComponentPath.of(this, EPartDefComponent.Propeller, index);
    }

    @Override
    public int hashCode() {
        return (Integer)this.Source.map(Integer::intValue, stringList -> {
            int hash = 0;
            for (String s : stringList) {
                hash = Objects.hash(hash, s);
            }
            return hash;
        });
    }

    @Override
    public String toString() {
        return (String)this.Source.map(i -> Integer.toString(i), stringList -> {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < stringList.size(); ++i) {
                sb.append((String)stringList.get(i));
                if (i == stringList.size() - 1) continue;
                sb.append("/");
            }
            return sb.toString();
        });
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof VehiclePartPath) {
            VehiclePartPath otherPath = (VehiclePartPath)other;
            return otherPath.hashCode() == this.hashCode();
        }
        return false;
    }
}

