/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.entity.vehicle.hierarchy;

import com.flansmod.common.entity.vehicle.hierarchy.EPartDefComponent;
import com.flansmod.common.entity.vehicle.hierarchy.VehiclePartPath;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Either;
import java.util.Objects;
import javax.annotation.Nonnull;

public record VehicleComponentPath(@Nonnull VehiclePartPath Part, @Nonnull EPartDefComponent Type, int Index) {
    public static final VehicleComponentPath Invalid = new VehicleComponentPath(VehiclePartPath.Invalid, EPartDefComponent.Articulation, 0);
    public static final VehicleComponentPath coreDamage = new VehicleComponentPath(VehiclePartPath.Core, EPartDefComponent.Damage, 0);
    public static final VehicleComponentPath coreArticulation = new VehicleComponentPath(VehiclePartPath.Core, EPartDefComponent.Damage, 0);

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.Part.hashCode(), this.Type, this.Index});
    }

    @Override
    public String toString() {
        return this.Part + ":" + this.Type + "_" + this.Index;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof VehicleComponentPath) {
            VehicleComponentPath otherPath = (VehicleComponentPath)other;
            return otherPath.Part.equals(this.Part) && otherPath.Type == this.Type && otherPath.Index == this.Index;
        }
        return false;
    }

    @Nonnull
    public static VehicleComponentPath of(@Nonnull String string) {
        String[] partComponentSplit = string.split(":");
        if (partComponentSplit.length == 2) {
            VehiclePartPath partPath = VehiclePartPath.of(partComponentSplit[0]);
            String[] underscoreSplit = partComponentSplit[1].split("_");
            if (underscoreSplit.length == 2) {
                return VehicleComponentPath.of(partPath, EPartDefComponent.valueOf(underscoreSplit[0]), Integer.parseInt(underscoreSplit[1]));
            }
        }
        return Invalid;
    }

    @Nonnull
    public static VehicleComponentPath of(@Nonnull VehiclePartPath part, @Nonnull EPartDefComponent type, int childIndex) {
        return new VehicleComponentPath(part, type, childIndex);
    }

    @Nonnull
    public static VehicleComponentPath of(int pathHash, @Nonnull EPartDefComponent type, int childIndex) {
        return new VehicleComponentPath(new VehiclePartPath((Either<Integer, ImmutableList<String>>)Either.left((Object)pathHash)), type, childIndex);
    }

    @Nonnull
    public static VehicleComponentPath of(@Nonnull ImmutableList<String> names, @Nonnull EPartDefComponent type, int childIndex) {
        return new VehicleComponentPath(new VehiclePartPath((Either<Integer, ImmutableList<String>>)Either.right(names)), type, childIndex);
    }
}

