/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.entity.vehicle.controls;

import com.flansmod.common.entity.vehicle.VehicleEntity;
import com.flansmod.common.entity.vehicle.controls.VehicleInputState;
import com.flansmod.common.entity.vehicle.hierarchy.VehiclePartPath;
import com.flansmod.common.types.vehicles.ControlSchemeDefinition;
import com.flansmod.common.types.vehicles.EVehicleAxis;
import com.flansmod.common.types.vehicles.VehicleDefinition;
import com.flansmod.common.types.vehicles.elements.ControlSchemeAxisDefinition;
import com.flansmod.physics.common.collision.DynamicCollisionEvent;
import com.flansmod.physics.common.collision.StaticCollisionEvent;
import javax.annotation.Nonnull;

public abstract class ControlLogic {
    @Nonnull
    public final ControlSchemeDefinition Def;

    public ControlLogic(@Nonnull ControlSchemeDefinition def) {
        this.Def = def;
    }

    @Nonnull
    protected ControlSchemeAxisDefinition FindAxis(@Nonnull EVehicleAxis axisType) {
        for (ControlSchemeAxisDefinition axis : this.Def.axes) {
            if (axis.axisType != axisType) continue;
            return axis;
        }
        return ControlSchemeAxisDefinition.INVALID;
    }

    public abstract boolean CanControl(@Nonnull VehicleDefinition var1);

    public abstract void TickAuthoritative(@Nonnull VehicleEntity var1, @Nonnull VehicleInputState var2);

    public abstract void TickRemote(@Nonnull VehicleEntity var1, @Nonnull VehicleInputState var2);

    public boolean OnCollide(@Nonnull VehiclePartPath onPart, @Nonnull StaticCollisionEvent collision) {
        return true;
    }

    public boolean OnCollide(@Nonnull VehiclePartPath onPart, @Nonnull DynamicCollisionEvent collision) {
        return true;
    }
}

