/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.entity.vehicle.controls;

import com.flansmod.common.entity.vehicle.VehicleEntity;
import com.flansmod.common.entity.vehicle.controls.ControlLogic;
import com.flansmod.common.entity.vehicle.controls.VehicleInputState;
import com.flansmod.common.types.vehicles.ControlSchemeDefinition;
import com.flansmod.common.types.vehicles.EVehicleAxis;
import com.flansmod.common.types.vehicles.VehicleDefinition;
import com.flansmod.common.types.vehicles.elements.ControlSchemeAxisDefinition;
import com.flansmod.common.types.vehicles.elements.EControlLogicHint;
import com.flansmod.common.types.vehicles.elements.WheelDefinition;
import java.util.List;
import javax.annotation.Nonnull;

public class CarControlLogic
extends ControlLogic {
    @Nonnull
    private final ControlSchemeAxisDefinition AcceleratorAxis = this.FindAxis(EVehicleAxis.Accelerator);
    @Nonnull
    private final ControlSchemeAxisDefinition SteerLeftRightAxis = this.FindAxis(EVehicleAxis.Yaw);

    public CarControlLogic(@Nonnull ControlSchemeDefinition def) {
        super(def);
    }

    @Override
    public boolean CanControl(@Nonnull VehicleDefinition vehicleDef) {
        List<WheelDefinition> allWheels = vehicleDef.AsHierarchy().AllWheels();
        int numWheels = allWheels.size();
        if (numWheels < 3) {
            return false;
        }
        boolean hasSteering = false;
        boolean hasFront = false;
        boolean hasRear = false;
        boolean hasDrive = false;
        for (WheelDefinition wheelDef : allWheels) {
            if (wheelDef.IsHintedAs(EControlLogicHint.Steering)) {
                hasSteering = true;
            }
            if (wheelDef.IsHintedAs(EControlLogicHint.Front)) {
                hasFront = true;
            }
            if (wheelDef.IsHintedAs(EControlLogicHint.Rear)) {
                hasRear = true;
            }
            if (!wheelDef.IsHintedAs(EControlLogicHint.Drive)) continue;
            hasDrive = true;
        }
        return hasSteering && hasFront && hasRear && hasDrive;
    }

    @Override
    public void TickAuthoritative(@Nonnull VehicleEntity vehicle, @Nonnull VehicleInputState inputs) {
        float accelerationInput = inputs.TickAxis(this.AcceleratorAxis);
        float steeringInput = inputs.TickAxis(this.SteerLeftRightAxis);
    }

    @Override
    public void TickRemote(@Nonnull VehicleEntity vehicle, @Nonnull VehicleInputState inputs) {
    }
}

