/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.entity;

import com.flansmod.common.entity.ENpcRelationship;
import com.flansmod.common.entity.INpcRelationshipsCapability;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class NpcRelationshipCapabilityImpl
implements INpcRelationshipsCapability {
    private final HashMap<ResourceLocation, ENpcRelationship> Relationships = new HashMap();
    private final HashMap<ResourceLocation, Long> Cooldowns = new HashMap();
    private final HashMap<ResourceLocation, Integer> Levels = new HashMap();

    @Override
    public ENpcRelationship GetRelationship(ResourceLocation npcID) {
        return this.Relationships.getOrDefault(npcID, ENpcRelationship.NotMet);
    }

    @Override
    public void SetRelationship(ResourceLocation npcID, ENpcRelationship relationship) {
        this.Relationships.put(npcID, relationship);
    }

    @Override
    public long GetEndCooldownTick(ResourceLocation npcID) {
        return this.Cooldowns.getOrDefault(npcID, 0L);
    }

    @Override
    public void SetEndCooldownTick(ResourceLocation npcID, long tick) {
        this.Cooldowns.put(npcID, tick);
    }

    @Override
    public int GetLevel(ResourceLocation npcID) {
        return this.Levels.getOrDefault(npcID, 0);
    }

    @Override
    public void SetLevel(ResourceLocation npcID, int level) {
        this.Levels.put(npcID, level);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tags = new CompoundTag();
        for (Map.Entry<ResourceLocation, ENpcRelationship> kvp : this.Relationships.entrySet()) {
            CompoundTag relationshipTags = new CompoundTag();
            relationshipTags.m_128359_("relation", kvp.getValue().toString());
            relationshipTags.m_128356_("cooldown", this.Cooldowns.getOrDefault(kvp.getKey(), 0L).longValue());
            tags.m_128365_(kvp.getKey().toString(), (Tag)relationshipTags);
        }
        return tags;
    }

    public void deserializeNBT(CompoundTag tags) {
        for (String key : tags.m_128431_()) {
            ResourceLocation npcID = new ResourceLocation(key);
            CompoundTag relationshipTags = tags.m_128469_(key);
            this.Relationships.put(npcID, ENpcRelationship.valueOf(relationshipTags.m_128461_("relation")));
            this.Cooldowns.put(npcID, relationshipTags.m_128454_("cooldown"));
        }
    }
}

