/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.crafting.ingredients;

import com.flansmod.common.FlansMod;
import com.flansmod.common.crafting.ingredients.IExtraIngredientTooltip;
import com.flansmod.common.types.JsonDefinition;
import com.flansmod.common.types.crafting.EMaterialType;
import com.flansmod.common.types.crafting.MaterialDefinition;
import com.flansmod.common.types.parts.PartDefinition;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.AbstractIngredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;

public class TieredPartIngredient
extends AbstractIngredient
implements IExtraIngredientTooltip {
    @Nonnull
    public final EMaterialType[] MaterialTypes;
    public final int MaterialTierMin;
    public final int MaterialTierMax;
    @Nonnull
    public final ResourceLocation MatchTag;
    @Nullable
    private ItemStack[] CachedMatchingStacks = null;
    @Nullable
    private List<MaterialDefinition> CachedMaterialMatches = null;
    @Nullable
    private List<PartDefinition> CachedPartMatches = null;

    public boolean IsMatchingMaterialType(EMaterialType matType) {
        for (EMaterialType materialType : this.MaterialTypes) {
            if (materialType != matType) continue;
            return true;
        }
        return false;
    }

    public static int MaterialsToFlags(EMaterialType[] materialTypes) {
        int flags = 0;
        for (EMaterialType materialType : materialTypes) {
            flags |= 1 << materialType.ordinal();
        }
        return flags;
    }

    public static EMaterialType[] MaterialsFromFlags(int flags) {
        ArrayList<EMaterialType> materialTypes = new ArrayList<EMaterialType>();
        for (EMaterialType materialType : EMaterialType.values()) {
            if ((flags & 1 << materialType.ordinal()) == 0) continue;
            materialTypes.add(materialType);
        }
        return materialTypes.toArray(new EMaterialType[0]);
    }

    public TieredPartIngredient(@Nonnull EMaterialType[] materialTypes, int tierMin, int tierMax, @Nonnull ResourceLocation matchTag) {
        this.MaterialTypes = materialTypes;
        this.MaterialTierMin = tierMin;
        this.MaterialTierMax = tierMax;
        this.MatchTag = matchTag;
    }

    @Override
    public void GenerateTooltip(@Nonnull List<Component> lines, boolean advanced) {
        if (JsonDefinition.IsValidLocation(this.MatchTag)) {
            lines.add((Component)Component.m_237110_((String)"crafting.with_tag", (Object[])new Object[]{this.MatchTag}));
        }
        if (this.MaterialTypes.length == 0) {
            lines.add((Component)Component.m_237115_((String)"crafting.match_any_material"));
        } else if (this.MaterialTypes.length == 1) {
            lines.add((Component)Component.m_237110_((String)"crafting.match_single", (Object[])new Object[]{this.MaterialTypes[0].ToComponent()}));
        } else {
            Object[] varargs = new Object[this.MaterialTypes.length];
            for (int n = 0; n < this.MaterialTypes.length; ++n) {
                varargs[n] = this.MaterialTypes[n] != null ? this.MaterialTypes[n].ToComponent() : Component.m_237119_();
            }
            lines.add((Component)Component.m_237110_((String)("crafting.match_multiple." + this.MaterialTypes.length), (Object[])varargs));
        }
        if (this.MaterialTierMin == this.MaterialTierMax) {
            lines.add((Component)Component.m_237110_((String)"crafting.match_single_tier", (Object[])new Object[]{this.MaterialTierMin}));
        } else if (this.MaterialTierMax >= 99) {
            lines.add((Component)Component.m_237110_((String)"crafting.match_tiers_above", (Object[])new Object[]{this.MaterialTierMin}));
        } else if (this.MaterialTierMin == 1) {
            lines.add((Component)Component.m_237110_((String)"crafting.match_tiers_below", (Object[])new Object[]{this.MaterialTierMax}));
        } else {
            lines.add((Component)Component.m_237110_((String)"crafting.match_tiers_between", (Object[])new Object[]{this.MaterialTierMin, this.MaterialTierMax}));
        }
    }

    @Nonnull
    public List<MaterialDefinition> GetMaterialMatches() {
        if (this.CachedMaterialMatches == null) {
            this.CachedMaterialMatches = FlansMod.MATERIALS.Find(mat -> mat.IsValid() && mat.craftingTier >= this.MaterialTierMin && mat.craftingTier <= this.MaterialTierMax && this.IsMatchingMaterialType(mat.materialType));
        }
        return this.CachedMaterialMatches;
    }

    @Nonnull
    public List<PartDefinition> GetPartMatches() {
        if (this.CachedPartMatches == null) {
            this.CachedPartMatches = FlansMod.PARTS.Find(part -> part.IsValid() && this.GetMaterialMatches().contains(part.GetMaterial()) && part.itemSettings.Matches(this.MatchTag));
        }
        return this.CachedPartMatches;
    }

    public boolean m_43947_() {
        return this.m_43908_().length == 0;
    }

    @Nonnull
    public ItemStack[] m_43908_() {
        if (this.CachedMatchingStacks == null) {
            ArrayList<ItemStack> matching = new ArrayList<ItemStack>();
            TagKey matchTagKey = TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)this.MatchTag);
            for (ResourceLocation partID : FlansMod.PARTS.getIds()) {
                MaterialDefinition matDef;
                PartDefinition part;
                Item partItem = (Item)ForgeRegistries.ITEMS.getValue(partID);
                if (partItem == null || !partItem.m_204114_().m_203656_(matchTagKey) || !(part = (PartDefinition)FlansMod.PARTS.Get(partID)).IsValid() || !(matDef = (MaterialDefinition)FlansMod.MATERIALS.Get(part.material)).IsValid() || !this.IsMatchingMaterialType(matDef.materialType) || matDef.craftingTier < this.MaterialTierMin || matDef.craftingTier > this.MaterialTierMax) continue;
                matching.add(new ItemStack((ItemLike)partItem));
            }
            this.CachedMatchingStacks = matching.toArray(new ItemStack[0]);
        }
        return this.CachedMatchingStacks;
    }

    public boolean isSimple() {
        return true;
    }

    @Nonnull
    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        JsonArray jMatArray = new JsonArray();
        for (EMaterialType materialType : this.MaterialTypes) {
            jMatArray.add(materialType.toString());
        }
        json.add("materials", (JsonElement)jMatArray);
        json.addProperty("min", (Number)this.MaterialTierMin);
        json.addProperty("max", (Number)this.MaterialTierMax);
        json.addProperty("tag", this.MatchTag.toString());
        return json;
    }

    @Nonnull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements IIngredientSerializer<TieredPartIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        @Nonnull
        public TieredPartIngredient parse(@Nonnull JsonObject json) {
            JsonArray array = GsonHelper.m_13933_((JsonObject)json, (String)"materials");
            EMaterialType[] materialTypes = new EMaterialType[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                materialTypes[i] = EMaterialType.parse(array.get(i).getAsString());
            }
            String tag = GsonHelper.m_13851_((JsonObject)json, (String)"tag", (String)"flansmod:generic");
            int min = GsonHelper.m_13824_((JsonObject)json, (String)"min", (int)1);
            int max = GsonHelper.m_13824_((JsonObject)json, (String)"max", (int)Integer.MAX_VALUE);
            return new TieredPartIngredient(materialTypes, min, max, new ResourceLocation(tag));
        }

        public void write(FriendlyByteBuf buffer, TieredPartIngredient ingredient) {
            buffer.writeInt(TieredPartIngredient.MaterialsToFlags(ingredient.MaterialTypes));
            buffer.writeInt(ingredient.MaterialTierMin);
            buffer.writeInt(ingredient.MaterialTierMax);
            buffer.m_130085_(ingredient.MatchTag);
        }

        @Nonnull
        public TieredPartIngredient parse(FriendlyByteBuf buffer) {
            int materialFlags = buffer.readInt();
            EMaterialType[] materialTypes = TieredPartIngredient.MaterialsFromFlags(materialFlags);
            int min = buffer.readInt();
            int max = buffer.readInt();
            ResourceLocation tag = buffer.m_130281_();
            return new TieredPartIngredient(materialTypes, min, max, tag);
        }
    }
}

