/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.crafting;

import com.flansmod.common.FlansMod;
import com.flansmod.common.types.crafting.MaterialDefinition;
import com.flansmod.common.types.elements.MaterialSourceDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class MaterialMatcher {
    public final List<MaterialDefinition> MaterialDefs;
    private List<MaterialMatchInfo> MatchItems = null;

    public MaterialMatcher(List<MaterialDefinition> materialDefs) {
        this.MaterialDefs = materialDefs;
    }

    private void InitializeCache() {
        this.MatchItems = new ArrayList<MaterialMatchInfo>();
        for (MaterialDefinition matDef : this.MaterialDefs) {
            if (matDef.IsValid()) {
                for (MaterialSourceDefinition source : matDef.sources) {
                    for (String itemId : source.matchItems) {
                        ResourceLocation itemResLoc = ResourceLocation.m_135820_((String)itemId);
                        if (itemResLoc != null) {
                            Item item = (Item)ForgeRegistries.ITEMS.getValue(itemResLoc);
                            if (item != null) {
                                if (this.MatchItems.contains(item)) continue;
                                this.MatchItems.add(new MaterialMatchInfo(item, source.count));
                                continue;
                            }
                            FlansMod.LOGGER.warn("Failed to find item with ResourceLocation " + itemResLoc + " for MaterialDefinition");
                            continue;
                        }
                        FlansMod.LOGGER.warn("Failed to parse item ResourceLocation " + itemId + " for MaterialDefinition");
                    }
                    ArrayList<TagKey> tagKeys = new ArrayList<TagKey>();
                    for (String tag : source.matchTags) {
                        ResourceLocation tagResLoc = ResourceLocation.m_135820_((String)tag);
                        if (tagResLoc != null) {
                            tagKeys.add(ItemTags.create((ResourceLocation)tagResLoc));
                            continue;
                        }
                        FlansMod.LOGGER.warn("Failed to parse tag ResourceLocation " + tag + " for MaterialDefinition");
                    }
                    for (Map.Entry kvp : ForgeRegistries.ITEMS.getEntries()) {
                        for (TagKey tagKey : tagKeys) {
                            if (!((Item)kvp.getValue()).m_204114_().m_203656_(tagKey) || this.MatchItems.contains(kvp.getValue())) continue;
                            this.MatchItems.add(new MaterialMatchInfo((Item)kvp.getValue(), source.count));
                        }
                    }
                }
                continue;
            }
            FlansMod.LOGGER.warn("MaterialDefinition " + matDef.GetLocationString() + " was invalid");
        }
    }

    public int Matches(ItemStack stack) {
        if (this.MatchItems == null) {
            this.InitializeCache();
        }
        for (MaterialMatchInfo kvp : this.MatchItems) {
            if (!stack.m_150930_(kvp.Item)) continue;
            return kvp.Count;
        }
        return 0;
    }

    private class MaterialMatchInfo {
        public Item Item;
        public int Count;

        public MaterialMatchInfo(Item item, int count) {
            this.Item = item;
            this.Count = count;
        }
    }
}

