/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.actions.stats;

import com.flansmod.common.FlansMod;
import com.flansmod.common.actions.stats.IStatCalculatorContext;
import com.flansmod.common.actions.stats.StatFormula;
import com.flansmod.common.types.abilities.elements.EAccumulationSource;
import com.flansmod.common.types.abilities.elements.StatAccumulatorDefinition;
import com.flansmod.common.types.elements.ModifierDefinition;
import com.flansmod.util.formulae.FloatAccumulation;
import com.flansmod.util.formulae.FloatAccumulator;
import javax.annotation.Nonnull;

public class StatAccumulator
extends FloatAccumulator<EAccumulationSource, StatFormula> {
    public static final StatAccumulator EmptyAccumulator = new StatAccumulator();
    public static final StatFormula EmptyFormula = new StatFormula();

    @Override
    @Nonnull
    protected StatFormula FormulaConstructor() {
        return new StatFormula();
    }

    @Override
    @Nonnull
    protected StatFormula ConstEmptyFormula() {
        return EmptyFormula;
    }

    @Nonnull
    public StatAccumulator CopyFrom(@Nonnull StatAccumulator other) {
        return (StatAccumulator)super.CopyFrom(other);
    }

    @Nonnull
    public StatAccumulator Bake(@Nonnull EAccumulationSource inputType, float value) {
        return (StatAccumulator)super.Bake(inputType, value);
    }

    @Nonnull
    public StatAccumulator Stack(ModifierDefinition ... mods) {
        for (ModifierDefinition mod : mods) {
            for (StatAccumulatorDefinition accumulatorDef : mod.accumulators) {
                ((StatFormula)this.GetFormulaFor(accumulatorDef.operation)).AddTerm(accumulatorDef.GetValue(), accumulatorDef.multiplyPer);
            }
        }
        return this;
    }

    @Nonnull
    public StatAccumulator Stack(StatAccumulatorDefinition ... accumulators) {
        for (StatAccumulatorDefinition accumulatorDef : accumulators) {
            ((StatFormula)this.GetFormulaFor(accumulatorDef.operation)).AddTerm(accumulatorDef.GetValue(), accumulatorDef.multiplyPer);
        }
        return this;
    }

    @Nonnull
    public StatAccumulator Stack(int level, int stackCount, StatAccumulatorDefinition ... accumulators) {
        for (StatAccumulatorDefinition accumulatorDef : accumulators) {
            ((StatFormula)this.GetFormulaFor(accumulatorDef.operation)).AddTerm(accumulatorDef.GetValue(), accumulatorDef.multiplyPer).BakeInput(EAccumulationSource.PerLevel, (float)level).BakeInput(EAccumulationSource.PerStacks, (float)stackCount);
        }
        return this;
    }

    @Nonnull
    public StatAccumulator Stack(int level, int stackCount, @Nonnull StatAccumulatorDefinition accumulatorDef) {
        ((StatFormula)this.GetFormulaFor(accumulatorDef.operation)).AddTerm(accumulatorDef.GetValue(), accumulatorDef.multiplyPer).BakeInput(EAccumulationSource.PerLevel, (float)level).BakeInput(EAccumulationSource.PerStacks, (float)stackCount);
        return this;
    }

    public StatAccumulator CopyWithLevelAndStacks(int level, int stackCount) {
        return new StatAccumulator().CopyFrom(this).Bake(EAccumulationSource.PerLevel, (float)level).Bake(EAccumulationSource.PerStacks, (float)stackCount);
    }

    @Nonnull
    public FloatAccumulation Calculate(@Nonnull IStatCalculatorContext ctx) {
        return this.Evaluate(statIndex -> {
            switch (EAccumulationSource.values()[statIndex]) {
                case PerLevel: 
                case PerStacks: {
                    return Float.valueOf(1.0f);
                }
                case PerAttachment: {
                    return Float.valueOf(ctx.GetNumAttachments());
                }
                case PerMagFullness: {
                    return Float.valueOf(ctx.GetMagFullness());
                }
                case PerMagEmptiness: {
                    return Float.valueOf(1.0f - ctx.GetMagFullness());
                }
            }
            FlansMod.LOGGER.error("I don't know what this input is");
            return Float.valueOf(0.0f);
        });
    }
}

