/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.actions.nodes;

import com.flansmod.common.FlansMod;
import com.flansmod.common.FlansModConfig;
import com.flansmod.common.actions.ActionGroupInstance;
import com.flansmod.common.actions.ActionInstance;
import com.flansmod.common.actions.EActionResult;
import com.flansmod.common.actions.contexts.TriggerContext;
import com.flansmod.common.gunshots.Raytracer;
import com.flansmod.common.types.abilities.elements.EAbilityTrigger;
import com.flansmod.common.types.guns.elements.ActionDefinition;
import com.flansmod.physics.common.util.Transform;
import java.util.ArrayList;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class RaycastAction
extends ActionInstance {
    public RaycastAction(@NotNull ActionGroupInstance group, @NotNull ActionDefinition def) {
        super(group, def);
    }

    @Override
    public EActionResult CanStart() {
        if (!((Boolean)FlansModConfig.AllowRaycastActions.get()).booleanValue()) {
            return EActionResult.TryNextAction;
        }
        return EActionResult.CanProcess;
    }

    @Override
    public void OnTriggerClient(int triggerIndex) {
    }

    @Override
    public void OnTriggerServer(int triggerIndex) {
        Transform ray = this.Group.Context.Gun.GetShootOrigin();
        Vec3 origin = ray.positionVec3();
        Vec3 direction = ray.forward();
        float reach = this.Reach();
        Level level = this.Group.Context.Gun.GetLevel();
        if (level != null) {
            Raytracer raytracer = Raytracer.ForLevel((LevelAccessor)level);
            ArrayList<HitResult> hits = new ArrayList<HitResult>();
            raytracer.CastBullet(this.Group.Context.Gun.GetShooter().Entity(), origin, direction.m_82541_().m_82490_((double)reach), 0.0, 0.0, hits);
            if (hits.size() > 0) {
                this.Group.Context.Gun.GetActionStack().EvaluateTrigger(EAbilityTrigger.RaycastAction, this.Group.Context, TriggerContext.hit(this.Group.Context.Gun.GetShooter(), (HitResult)hits.get(0)));
            }
        } else {
            FlansMod.LOGGER.warn("RaycastAction[" + this.Def + "]: Could not find level");
        }
    }
}

