/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.actions.nodes;

import com.flansmod.client.render.FirstPersonManager;
import com.flansmod.common.FlansMod;
import com.flansmod.common.actions.ActionGroupInstance;
import com.flansmod.common.actions.ActionInstance;
import com.flansmod.common.actions.contexts.ActionGroupContext;
import com.flansmod.common.actions.contexts.GunContext;
import com.flansmod.common.actions.contexts.GunContextPlayer;
import com.flansmod.common.actions.nodes.ShootAction;
import com.flansmod.common.projectiles.CasingEntity;
import com.flansmod.common.types.guns.elements.ActionDefinition;
import com.flansmod.common.types.magazines.MagazineDefinition;
import com.flansmod.physics.common.util.MinecraftHelpers;
import com.flansmod.physics.common.util.Transform;
import com.flansmod.physics.common.util.TransformStack;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EjectCasingAction
extends ActionInstance {
    public static final int ID = 2;
    public CasingEntity casingEntity;
    public Vec3 position = Vec3.f_82478_;
    public Vec3 velocity = Vec3.f_82478_;
    public Vec3 dir = Vec3.f_82478_;
    public Vec3 playerPosition = Vec3.f_82478_;
    public String spawnCasing = "";

    public EjectCasingAction(@NotNull ActionGroupInstance group, @NotNull ActionDefinition def) {
        super(group, def);
    }

    @Override
    public void OnTriggerClient(int triggerIndex) {
        GunContext gunContext = this.Group.Context.Gun;
        if (gunContext instanceof GunContextPlayer) {
            GunContextPlayer playerGunContext = (GunContextPlayer)gunContext;
            GunContext gunContext2 = this.Group.Context.Gun;
            ItemDisplayContext transformType = !Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() || !gunContext2.GetShooter().IsLocalPlayerOwner() ? MinecraftHelpers.getThirdPersonTransformType(gunContext2.GetShooter().IsLocalPlayerOwner(), playerGunContext.GetHand()) : MinecraftHelpers.getFirstPersonTransformType(playerGunContext.GetHand());
            TransformStack transformStack = TransformStack.empty();
            Transform origin = FirstPersonManager.GetWorldSpaceAPTransform(gunContext2, transformType, ActionGroupContext.CreateGroupPath(this.AttachPoint()));
            Transform direction = FirstPersonManager.GetWorldSpaceAPTransform(gunContext2, transformType, ActionGroupContext.CreateGroupPath(this.EjectDirection()));
            transformStack = TransformStack.empty();
            transformStack.add(direction);
            Vec3 look = transformStack.top().forward();
            float speed = this.EjectSpeed();
            transformStack = TransformStack.empty();
            transformStack.add(origin);
            Vec3 position = transformStack.top().positionVec3();
            Vec3 velocity = look.m_82490_((double)speed * ((double)0.8f + Math.random() * (double)0.4f));
            this.position = position;
            this.velocity = velocity;
            this.dir = transformStack.top().forward();
            this.playerPosition = gunContext2.GetShooter().Entity().m_20182_();
        }
    }

    public ShootAction getShot() {
        for (ActionInstance instance : this.Group.GetActions()) {
            if (!(instance instanceof ShootAction)) continue;
            return (ShootAction)instance;
        }
        return null;
    }

    @Override
    @Nonnull
    public ActionInstance.NetData GetNetDataForTrigger(int triggerIndex) {
        GunContext gunContext = this.Group.Context.Gun;
        if (gunContext instanceof GunContextPlayer) {
            GunContextPlayer playerGunContext = (GunContextPlayer)gunContext;
            GunContext gunContext2 = this.Group.Context.Gun;
            ItemDisplayContext transformType = !Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() || !gunContext2.GetShooter().IsLocalPlayerOwner() ? MinecraftHelpers.getThirdPersonTransformType(gunContext2.GetShooter().IsLocalPlayerOwner(), playerGunContext.GetHand()) : MinecraftHelpers.getFirstPersonTransformType(playerGunContext.GetHand());
            TransformStack transformStack = TransformStack.empty();
            Transform origin = FirstPersonManager.GetWorldSpaceAPTransform(gunContext2, transformType, ActionGroupContext.CreateGroupPath(this.AttachPoint()));
            Transform direction = FirstPersonManager.GetWorldSpaceAPTransform(gunContext2, transformType, ActionGroupContext.CreateGroupPath(this.EjectDirection()));
            transformStack = TransformStack.empty();
            transformStack.add(direction);
            Vec3 look = transformStack.top().forward();
            float speed = this.EjectSpeed();
            transformStack = TransformStack.empty();
            transformStack.add(origin);
            Vec3 position = transformStack.top().positionVec3();
            Vec3 velocity = look.m_82490_((double)speed * ((double)0.8f + Math.random() * (double)0.4f));
            this.position = position;
            this.velocity = velocity;
            this.dir = transformStack.top().forward();
            this.playerPosition = gunContext2.GetShooter().Entity().m_20182_();
        }
        if (this.position != Vec3.f_82478_) {
            return new CasingNetData(this.position, this.velocity, this.dir, this.playerPosition, this.spawnCasing);
        }
        return CasingNetData.Invalid;
    }

    @Override
    public void UpdateFromNetData(ActionInstance.NetData netData, int triggerIndex) {
        if (netData instanceof CasingNetData) {
            CasingNetData shootNetData = (CasingNetData)netData;
            this.position = shootNetData.Position;
            this.velocity = shootNetData.Velocity;
            this.dir = shootNetData.Dir;
            this.playerPosition = shootNetData.PlayerPos;
        }
    }

    @Override
    public void OnTriggerServer(int triggerIndex) {
        GunContext gunContext;
        this.casingEntity = null;
        MagazineDefinition magDef = this.Group.Context.GetMagazineType(0);
        if (!magDef.ejectCasings) {
            return;
        }
        if (this.casingEntity == null && (gunContext = this.Group.Context.Gun) instanceof GunContextPlayer) {
            GunContextPlayer playerGunContext = (GunContextPlayer)gunContext;
            CasingEntity casing = new CasingEntity((EntityType<? extends Projectile>)((EntityType)FlansMod.ENT_TYPE_CASING.get()), this.Group.Context.Gun.GetLevel());
            GunContext context = this.Group.Context.Gun;
            casing.InitContext(this.Group.Context);
            Vec3 playerPosNew = context.GetShooter().Entity().m_20182_();
            Vec3 offset = new Vec3(playerPosNew.m_7096_() - this.playerPosition.m_7096_(), playerPosNew.m_7098_() - this.playerPosition.m_7098_(), playerPosNew.m_7094_() - this.playerPosition.m_7094_());
            this.position = this.position.m_82549_(offset);
            casing.m_146884_(this.position);
            casing.SetVelocity(this.velocity);
            casing.RecalculateFacing(this.dir);
            casing.m_146867_();
            casing.Action = this;
            casing.itemToSpawn = this.spawnCasing = this.Group.Context.GetMagazineType((int)0).spawnBulletCasing;
            this.Group.Context.Gun.GetLevel().m_7967_((Entity)casing);
            this.casingEntity = casing;
        }
    }

    @Override
    public boolean PropogateToServer() {
        return true;
    }

    @Override
    public void OnTickClient() {
        super.OnTickClient();
        if (this.position != null) {
            // empty if block
        }
    }

    @Override
    public void OnTickServer() {
        super.OnTickServer();
    }

    @Nonnull
    public String AttachPoint() {
        return this.Group.Context.ModifyString("casing_eject_point" + this.Def.id, "casing_eject");
    }

    @Nonnull
    public String EjectDirection() {
        return this.Group.Context.ModifyString("casing_eject_direction" + this.Def.id, "casing_eject_direction");
    }

    public float EjectSpeed() {
        return this.Group.Context.ModifyFloat("casing_eject_speed" + this.Def.id).get();
    }

    public CompoundTag Save() {
        CompoundTag tag = new CompoundTag();
        tag.m_128350_("speed", this.EjectSpeed());
        tag.m_128359_("attachPoint", this.AttachPoint());
        tag.m_128359_("ejectDirection", this.EjectDirection());
        return tag;
    }

    public static class CasingNetData
    extends ActionInstance.NetData {
        public static final int ID = 2;
        public static final CasingNetData Invalid = new CasingNetData();
        public Vec3 Position;
        public Vec3 Velocity;
        public Vec3 Dir;
        public Vec3 PlayerPos;
        public String ItemToSpawn;

        public CasingNetData() {
            this.Position = Vec3.f_82478_;
            this.Velocity = Vec3.f_82478_;
            this.Dir = Vec3.f_82478_;
        }

        public CasingNetData(Vec3 pos, Vec3 vel, Vec3 d, Vec3 playerPos, String s) {
            this.Position = pos;
            this.Velocity = vel;
            this.Dir = d;
            this.PlayerPos = playerPos;
            this.ItemToSpawn = s;
        }

        @Override
        public int GetID() {
            return 2;
        }

        @Override
        public void Encode(FriendlyByteBuf buf) {
            buf.writeFloat((float)this.Position.m_7096_());
            buf.writeFloat((float)this.Position.m_7098_());
            buf.writeFloat((float)this.Position.m_7094_());
            buf.writeFloat((float)this.Velocity.m_7096_());
            buf.writeFloat((float)this.Velocity.m_7098_());
            buf.writeFloat((float)this.Velocity.m_7094_());
            buf.writeFloat((float)this.Dir.m_7096_());
            buf.writeFloat((float)this.Dir.m_7098_());
            buf.writeFloat((float)this.Dir.m_7094_());
            buf.writeFloat((float)this.PlayerPos.m_7096_());
            buf.writeFloat((float)this.PlayerPos.m_7098_());
            buf.writeFloat((float)this.PlayerPos.m_7094_());
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("bulletToSpawn", this.ItemToSpawn);
            buf.m_130079_(tag);
        }

        @Override
        public void Decode(FriendlyByteBuf buf) {
            this.Position = new Vec3((double)buf.readFloat(), (double)buf.readFloat(), (double)buf.readFloat());
            this.Velocity = new Vec3((double)buf.readFloat(), (double)buf.readFloat(), (double)buf.readFloat());
            this.Dir = new Vec3((double)buf.readFloat(), (double)buf.readFloat(), (double)buf.readFloat());
            this.PlayerPos = new Vec3((double)buf.readFloat(), (double)buf.readFloat(), (double)buf.readFloat());
            this.ItemToSpawn = buf.m_130260_().m_128461_("bulletToSpawn");
        }
    }
}

