/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.actions.contexts;

import com.flansmod.common.actions.contexts.ShooterContextVehicle;
import com.flansmod.common.actions.stats.IModifierBaker;
import com.flansmod.common.entity.vehicle.VehicleEntity;
import com.flansmod.common.entity.vehicle.hierarchy.VehicleComponentPath;
import com.flansmod.common.types.vehicles.elements.SeatDefinition;
import com.flansmod.physics.common.util.Transform;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;

public class ShooterContextVehicleSeat
extends ShooterContextVehicle {
    @Nonnull
    public final VehicleComponentPath SeatPath;
    @Nullable
    public final SeatDefinition SeatDef;

    public ShooterContextVehicleSeat(@Nonnull VehicleEntity vehicle, @Nonnull VehicleComponentPath seatPath) {
        super(vehicle);
        this.SeatPath = seatPath;
        this.SeatDef = this.VehicleDef().AsHierarchy().FindSeat(this.SeatPath).orElse(SeatDefinition.INVALID);
    }

    @Override
    public int GetNumValidContexts() {
        return this.SeatDef.inputs.length;
    }

    @Override
    @Nullable
    public Entity Owner() {
        return this.EntityInThisSeat();
    }

    @Override
    @Nonnull
    public Transform GetShootOrigin(float deltaTick) {
        Entity passenger = this.EntityInThisSeat();
        if (passenger != null) {
            return Transform.fromPos(passenger.m_20182_());
        }
        return Transform.fromPos(this.Vehicle.m_20182_());
    }

    @Override
    public void BakeModifiers(@Nonnull IModifierBaker baker) {
    }

    @Nullable
    public Entity EntityInThisSeat() {
        return this.Vehicle.GetPassengerInSeat(this.SeatPath, this.Vehicle.m_20197_());
    }

    public boolean IsOccupied() {
        return this.EntityInThisSeat() != null;
    }
}

