/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.actions.contexts;

import com.flansmod.common.actions.contexts.GunContext;
import com.flansmod.common.actions.contexts.GunContextVehicle;
import com.flansmod.common.actions.contexts.ShooterContext;
import com.flansmod.common.actions.contexts.ShooterContextVehicleSeat;
import com.flansmod.common.entity.vehicle.VehicleEntity;
import com.flansmod.common.entity.vehicle.VehicleInventory;
import com.flansmod.common.entity.vehicle.VehicleSubContainer;
import com.flansmod.common.entity.vehicle.hierarchy.VehicleComponentPath;
import com.flansmod.common.types.vehicles.VehicleDefinition;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;

public abstract class ShooterContextVehicle
extends ShooterContext {
    @Nonnull
    protected final VehicleEntity Vehicle;

    @Nonnull
    public VehicleDefinition VehicleDef() {
        return this.Vehicle.Def();
    }

    public ShooterContextVehicle(@Nonnull VehicleEntity vehicle) {
        this.Vehicle = vehicle;
    }

    @Nonnull
    public ShooterContextVehicleSeat GetSeat(@Nonnull VehicleComponentPath seatPath) {
        return new ShooterContextVehicleSeat(this.Vehicle, seatPath);
    }

    @Override
    @Nonnull
    public UUID ShooterID() {
        return this.EntityUUID();
    }

    @Override
    @Nonnull
    public Entity Entity() {
        return this.Vehicle;
    }

    @Override
    @Nonnull
    public UUID[] GetAllGunIDs() {
        return this.Vehicle.GetAllGunIDs().toArray(new UUID[0]);
    }

    @Override
    @Nonnull
    public UUID GetGunIDForSlot(int gunSlotIndex) {
        return this.Vehicle.GetGunIDAtIndex(gunSlotIndex);
    }

    @Override
    @Nonnull
    public GunContext CreateContext(@Nonnull UUID gunID) {
        int gunSlotIndex = this.Vehicle.GetIndexOfGunID(gunID);
        if (gunSlotIndex != -1) {
            return new GunContextVehicle(this, gunSlotIndex);
        }
        return GunContext.INVALID;
    }

    @Override
    @Nullable
    public VehicleInventory GetAttachedInventory() {
        return this.Vehicle.Inventory();
    }

    public int GunSlotIndex(int gunIndex) {
        return this.Vehicle.Inventory().SubIndexToContainer(VehicleSubContainer.EType.Gun, gunIndex);
    }

    public int AmmoSlotIndex(int ammoIndex) {
        return this.Vehicle.Inventory().SubIndexToContainer(VehicleSubContainer.EType.Ammo, ammoIndex);
    }

    public int FuelSlotIndex(int fuelIndex) {
        return this.Vehicle.Inventory().SubIndexToContainer(VehicleSubContainer.EType.Fuel, fuelIndex);
    }

    @Nonnull
    public ItemStack GetGunStack(int gunIndex) {
        return ItemStack.f_41583_;
    }

    @Override
    public boolean IsValid() {
        return !this.Vehicle.m_213877_();
    }

    @Override
    public boolean IsCreative() {
        return false;
    }
}

