/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.actions.contexts;

import com.flansmod.common.actions.contexts.ContextCache;
import com.flansmod.common.actions.contexts.ShooterBlockEntity;
import com.flansmod.common.actions.contexts.ShooterContextBlockEntity;
import com.flansmod.physics.common.util.EContextSide;
import com.flansmod.physics.common.util.MinecraftHelpers;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ServerContextCache
extends ContextCache {
    public ServerContextCache() {
        super(EContextSide.Server);
    }

    @Override
    @Nullable
    protected Entity TryFindEntity(@Nonnull UUID entityID) {
        MinecraftServer server = MinecraftHelpers.getServer();
        if (server != null && server.m_130010_()) {
            for (ServerPlayer player : server.m_6846_().m_11314_()) {
                if (!player.m_20148_().equals(entityID)) continue;
                return player;
            }
            for (ServerLevel level : server.m_129785_()) {
                Entity shooter = level.m_8791_(entityID);
                if (shooter == null) continue;
                return shooter;
            }
        }
        return null;
    }

    @Override
    @Nonnull
    protected Optional<ShooterBlockEntity> TryFindBlockEntity(@Nonnull UUID blockEntityID) {
        Pair<Integer, BlockPos> pair = ShooterContextBlockEntity.ConvertShooterIDToCoords(blockEntityID);
        MinecraftServer server = MinecraftHelpers.getServer();
        if (server != null && server.m_130010_()) {
            for (ServerLevel level : server.m_129785_()) {
                BlockEntity blockEntity;
                if (level.m_46472_().m_135782_().hashCode() != ((Integer)pair.getFirst()).intValue() || !((blockEntity = level.m_7702_((BlockPos)pair.getSecond())) instanceof ShooterBlockEntity)) continue;
                ShooterBlockEntity shooterBlockEntity = (ShooterBlockEntity)blockEntity;
                return Optional.of(shooterBlockEntity);
            }
        }
        return Optional.empty();
    }
}

