/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.abilities;

import com.flansmod.common.FlansModConfig;
import com.flansmod.common.abilities.AbilityStack;
import com.flansmod.common.abilities.IAbilityEffect;
import com.flansmod.common.actions.contexts.ActionGroupContext;
import com.flansmod.common.actions.contexts.TargetsContext;
import com.flansmod.common.actions.contexts.TriggerContext;
import com.flansmod.common.types.abilities.elements.AbilityEffectDefinition;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.level.Level;

public class AbilityEffectExplode
implements IAbilityEffect {
    private final IAbilityEffect.StatHolder ExplosionRadius;
    private final boolean BreakBlocks;

    public AbilityEffectExplode(@Nonnull AbilityEffectDefinition def) {
        this.ExplosionRadius = new IAbilityEffect.StatHolder("explosion_radius", def);
        this.BreakBlocks = def.ModifyBoolean("explosion_breaks_blocks", true);
    }

    @Override
    public void TriggerServer(@Nonnull ActionGroupContext actionGroup, @Nonnull TriggerContext trigger, @Nonnull TargetsContext targets, @Nullable AbilityStack stacks) {
        if (!((Boolean)FlansModConfig.AllowBulletsCreateExplosions.get()).booleanValue()) {
            return;
        }
        Level level = actionGroup.Gun.GetLevel();
        if (level != null) {
            DamageSource dmgSource = actionGroup.Gun.CreateDamageSource();
            float radius = this.ExplosionRadius.Get(actionGroup, stacks);
            targets.ForEachPosition(triggerAt -> level.m_254951_(null, dmgSource, null, triggerAt, radius, this.BreakBlocks, Level.ExplosionInteraction.TNT));
        }
    }
}

