/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.abilities;

import com.flansmod.common.FlansModConfig;
import com.flansmod.common.abilities.AbilityStack;
import com.flansmod.common.abilities.IAbilityEffect;
import com.flansmod.common.actions.contexts.ActionGroupContext;
import com.flansmod.common.actions.contexts.TargetsContext;
import com.flansmod.common.actions.contexts.TriggerContext;
import com.flansmod.common.types.abilities.elements.AbilityEffectDefinition;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;

public class AbilityEffectBreakBlock
implements IAbilityEffect {
    private final IAbilityEffect.StatHolder HarvestLevel;

    public AbilityEffectBreakBlock(@Nonnull AbilityEffectDefinition def) {
        this.HarvestLevel = new IAbilityEffect.StatHolder("tool_level", def);
    }

    @Override
    public void TriggerServer(@Nonnull ActionGroupContext actionGroup, @Nonnull TriggerContext trigger, @Nonnull TargetsContext targets, @Nullable AbilityStack stacks) {
        if (!((Boolean)FlansModConfig.AllowBulletsBreakBlocks.get()).booleanValue()) {
            return;
        }
        Level level = actionGroup.Gun.GetLevel();
        if (level != null) {
            float toolLevel = this.HarvestLevel.Get(actionGroup, stacks);
            targets.ForEachBlock((blockPos, blockState) -> {
                if (blockState.canEntityDestroy((BlockGetter)level, blockPos, actionGroup.Gun.GetShooter().Owner()) && blockState.m_60734_().m_155943_() <= toolLevel) {
                    level.m_46953_(blockPos, true, actionGroup.Gun.GetShooter().Owner());
                }
            });
        }
    }
}

