/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.abilities;

import com.flansmod.common.abilities.AbilityStack;
import com.flansmod.common.abilities.IAbilityEffect;
import com.flansmod.common.actions.contexts.ActionGroupContext;
import com.flansmod.common.actions.contexts.TargetsContext;
import com.flansmod.common.actions.contexts.TriggerContext;
import com.flansmod.common.types.abilities.elements.AbilityEffectDefinition;
import com.flansmod.physics.common.util.Maths;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.registries.ForgeRegistries;

public class AbilityEffectApplyMobEffect
implements IAbilityEffect {
    @Nullable
    public final MobEffect Effect;
    @Nonnull
    private final IAbilityEffect.StatHolder PotionMultiplier;

    public AbilityEffectApplyMobEffect(@Nonnull AbilityEffectDefinition def) {
        this.Effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(def.ModifyString("mob_effect_id", "")));
        this.PotionMultiplier = new IAbilityEffect.StatHolder("potion_multiplier", def);
    }

    @Override
    public void TriggerServer(@Nonnull ActionGroupContext actionGroup, @Nonnull TriggerContext trigger, @Nonnull TargetsContext targets, @Nullable AbilityStack stacks) {
        if (this.Effect != null) {
            targets.ForEachEntity(entity -> {
                if (entity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity;
                    int decayTicks = stacks == null ? 20 : stacks.GetDecayTimeTicks(actionGroup.Gun);
                    living.m_147207_(new MobEffectInstance(this.Effect, decayTicks, Maths.ceil(this.PotionMultiplier.Get(actionGroup, stacks)) - 1), actionGroup.Gun.GetShooter().Owner());
                }
            });
        }
    }
}

