/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.abilities;

import com.flansmod.client.FlansModClient;
import com.flansmod.common.FlansMod;
import com.flansmod.common.abilities.AbilityStack;
import com.flansmod.common.abilities.IAbilityEffect;
import com.flansmod.common.actions.contexts.ActionGroupContext;
import com.flansmod.common.actions.contexts.TargetsContext;
import com.flansmod.common.actions.contexts.TriggerContext;
import com.flansmod.common.types.JsonDefinition;
import com.flansmod.common.types.abilities.elements.AbilityEffectDefinition;
import com.flansmod.physics.common.util.Maths;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class AbilityEffectApplyDecal
implements IAbilityEffect {
    @Nonnull
    private final ResourceLocation DecalTexture;
    private final IAbilityEffect.StatHolder DecalDuration;
    private final boolean RandomizeRotation;

    public AbilityEffectApplyDecal(@Nonnull AbilityEffectDefinition def) {
        this.DecalTexture = new ResourceLocation(def.ModifyString("decal_texture", "")).m_246208_("textures/").m_266382_(".png");
        this.DecalDuration = new IAbilityEffect.StatHolder("decal_duration", def);
        this.RandomizeRotation = def.ModifyBoolean("decal_randomize_rotation", true);
        if (!JsonDefinition.IsValidLocation(this.DecalTexture)) {
            FlansMod.LOGGER.error("Could not resolve decal location " + this.DecalTexture);
        }
    }

    @Override
    public void TriggerClient(@Nonnull ActionGroupContext actionGroup, @Nonnull TriggerContext trigger, @Nonnull TargetsContext targets, @Nullable AbilityStack stacks) {
        float duration = this.DecalDuration.Get(actionGroup, stacks);
        HitResult hitResult = trigger.Hit;
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHit = (BlockHitResult)hitResult;
            Direction normal = blockHit.m_82434_();
            FlansModClient.DECAL_RENDERER.AddDecal(this.DecalTexture, blockHit.m_82450_(), normal, this.RandomizeRotation ? actionGroup.Gun.GetRandom().m_188501_() * 360.0f : 0.0f, Maths.ceil(duration * 20.0f));
        } else {
            targets.ForEachPosition(triggerAt -> FlansModClient.DECAL_RENDERER.AddDecal(this.DecalTexture, (Vec3)triggerAt, Direction.UP, this.RandomizeRotation ? actionGroup.Gun.GetRandom().m_188501_() * 360.0f : 0.0f, Maths.ceil(duration * 20.0f)));
        }
    }
}

