/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.render.models.unbaked;

import com.flansmod.client.render.models.ITurboDeserializer;
import com.flansmod.client.render.models.baked.BakedTurboGeometry;
import com.flansmod.client.render.models.unbaked.TurboBox;
import com.flansmod.client.render.models.unbaked.TurboElementRaw;
import com.flansmod.client.render.models.unbaked.TurboFace;
import com.flansmod.client.render.models.unbaked.TurboShapeBox;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public abstract class TurboElement {
    public static final TurboElement invalid = new TurboElement(new Vector3f(), new Vector3f(), false){

        @Override
        @Nonnull
        public BakedTurboGeometry bake(@Nonnull Vector2i textureSize) {
            return BakedTurboGeometry.invalid;
        }
    };
    public final boolean shade;
    public final Vector3f eulerRotations;
    public final Vector3f rotationOrigin;

    public TurboElement(@Nonnull Vector3f eulerRotations, @Nonnull Vector3f rotationOrigin, boolean shade) {
        this.eulerRotations = eulerRotations;
        this.rotationOrigin = rotationOrigin;
        this.shade = shade;
    }

    @Nonnull
    public abstract BakedTurboGeometry bake(@Nonnull Vector2i var1);

    public Vector3f GetNormal(Direction direction, boolean applyRotation) {
        if (applyRotation) {
            Quaternionf rotation = new Quaternionf().rotateZYX(this.eulerRotations.z, this.eulerRotations.y, this.eulerRotations.x);
            return rotation.transform(new Vector3f((float)direction.m_122436_().m_123341_(), (float)direction.m_122436_().m_123342_(), (float)direction.m_122436_().m_123343_()));
        }
        return new Vector3f((float)direction.m_122436_().m_123341_(), (float)direction.m_122436_().m_123342_(), (float)direction.m_122436_().m_123343_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Deserializer
    implements JsonDeserializer<TurboElement>,
    ITurboDeserializer {
        private static final boolean DEFAULT_SHADE = true;

        @Nonnull
        public TurboElement deserialize(@Nonnull JsonElement jElement, @Nonnull Type p_111330_, @Nonnull JsonDeserializationContext context) throws JsonParseException {
            JsonElement origin;
            Vector3f[] vertices;
            JsonObject jObject = jElement.getAsJsonObject();
            Vector3f eulerRotations = this.getOrDefaultVector3f(jObject, "eulerRotations", new Vector3f());
            Vector3f rotationOrigin = this.getOrDefaultVector3f(jObject, "rotationOrigin", new Vector3f());
            if (jObject.has("shade") && !GsonHelper.m_13880_((JsonObject)jObject, (String)"shade")) {
                throw new JsonParseException("Expected shade to be a Boolean");
            }
            boolean shade = GsonHelper.m_13855_((JsonObject)jObject, (String)"shade", (boolean)true);
            JsonElement jsonElement = jObject.get("verts");
            if (jsonElement instanceof JsonArray) {
                JsonArray jVertArray = (JsonArray)jsonElement;
                vertices = new Vector3f[8];
                if (jVertArray.size() == 8) {
                    for (i = 0; i < 8; ++i) {
                        vertices[i] = this.getVector3f(jVertArray.get(i));
                    }
                } else {
                    for (i = 0; i < 8; ++i) {
                        vertices[i] = new Vector3f();
                    }
                }
                EnumMap faceMap = Maps.newEnumMap(Direction.class);
                this.getFaces(context, jObject, faceMap);
                return new TurboElementRaw(eulerRotations, rotationOrigin, shade, vertices, faceMap);
            }
            vertices = jObject.get("box");
            if (vertices instanceof JsonObject) {
                JsonObject jBox = (JsonObject)vertices;
                origin = this.getOrDefaultVector3f(jBox, "origin", new Vector3f());
                Vector3f dimensions = this.getOrDefaultVector3f(jBox, "dimensions", new Vector3f());
                Vector2f uvCoords = this.getOrDefaultVector2f(jBox, "uv", new Vector2f());
                return new TurboBox(eulerRotations, rotationOrigin, shade, (Vector3f)origin, dimensions, uvCoords);
            }
            origin = jObject.get("shapebox");
            if (origin instanceof JsonObject) {
                JsonArray jOffsetArray;
                JsonObject jShapeBox = (JsonObject)origin;
                origin = this.getOrDefaultVector3f(jShapeBox, "origin", new Vector3f());
                Vector3f dimensions = this.getOrDefaultVector3f(jShapeBox, "dimensions", new Vector3f());
                Vector2f uvCoords = this.getOrDefaultVector2f(jShapeBox, "uv", new Vector2f());
                Vector3f[] offsets = new Vector3f[8];
                JsonElement jsonElement2 = jShapeBox.get("offsets");
                if (jsonElement2 instanceof JsonArray && (jOffsetArray = (JsonArray)jsonElement2).size() == 8) {
                    for (int i = 0; i < 8; ++i) {
                        offsets[i] = this.getVector3f(jOffsetArray.get(i));
                    }
                } else {
                    for (int i = 0; i < 8; ++i) {
                        offsets[i] = new Vector3f();
                    }
                }
                return new TurboShapeBox(eulerRotations, rotationOrigin, shade, (Vector3f)origin, dimensions, uvCoords, offsets);
            }
            return invalid;
        }

        private void getFaces(@Nonnull JsonDeserializationContext context, @Nonnull JsonObject jObject, @Nonnull Map<Direction, TurboFace> faceMap) {
            this.filterNullFromFaces(context, jObject, faceMap);
            if (faceMap.isEmpty()) {
                throw new JsonParseException("Expected between 1 and 6 unique faces, got 0");
            }
        }

        private void filterNullFromFaces(@Nonnull JsonDeserializationContext context, @Nonnull JsonObject jObject, @Nonnull Map<Direction, TurboFace> faceMap) {
            JsonObject jsonobject = GsonHelper.m_13930_((JsonObject)jObject, (String)"faces");
            for (Map.Entry entry : jsonobject.entrySet()) {
                Direction direction = this.getFacing((String)entry.getKey());
                faceMap.put(direction, (TurboFace)context.deserialize((JsonElement)entry.getValue(), TurboFace.class));
            }
        }
    }
}

