/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.render.models.unbaked;

import com.flansmod.client.render.models.ITurboDeserializer;
import com.flansmod.client.render.models.baked.BakedTurboGeometry;
import com.flansmod.client.render.models.unbaked.TurboElement;
import com.flansmod.physics.common.util.Maths;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.util.GsonHelper;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class TurboBox
extends TurboElement {
    public final Vector3f origin;
    public final Vector3f dimensions;
    public final Vector2f uvOrigin;

    public TurboBox(@Nonnull Vector3f euler, @Nonnull Vector3f rotationOrig, boolean shade, @Nonnull Vector3f orig, @Nonnull Vector3f dims, @Nonnull Vector2f uv) {
        super(euler, rotationOrig, shade);
        this.origin = orig;
        this.dimensions = dims;
        this.uvOrigin = uv;
    }

    @Nonnull
    public Vector3f getVertex(int vIndex) {
        return new Vector3f((vIndex & 1) == 0 ? this.origin.x : this.origin.x + this.dimensions.x, (vIndex & 2) == 0 ? this.origin.y : this.origin.y + this.dimensions.y, (vIndex & 4) == 0 ? this.origin.z : this.origin.z + this.dimensions.z);
    }

    @Nonnull
    public BakedTurboGeometry.Polygon bakeQuad(@Nonnull Vector2i textureSize, @Nonnull Direction dir) {
        int x = Maths.ceil(this.dimensions.x);
        int y = Maths.ceil(this.dimensions.y);
        int z = Maths.ceil(this.dimensions.z);
        float uMin = this.uvOrigin.x;
        float vMin = this.uvOrigin.y;
        float tX = 1.0f / (float)textureSize.x;
        float tY = 1.0f / (float)textureSize.y;
        return switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> new BakedTurboGeometry.Polygon((List<BakedTurboGeometry.VertexRef>)ImmutableList.of((Object)new BakedTurboGeometry.VertexRef(0, new Vector2f(tX * (uMin + (float)(x * 2) + (float)(z * 2)), tY * (vMin + (float)y + (float)z))), (Object)new BakedTurboGeometry.VertexRef(2, new Vector2f(tX * (uMin + (float)(x * 2) + (float)(z * 2)), tY * (vMin + (float)z))), (Object)new BakedTurboGeometry.VertexRef(3, new Vector2f(tX * (uMin + (float)x + (float)(z * 2)), tY * (vMin + (float)z))), (Object)new BakedTurboGeometry.VertexRef(1, new Vector2f(tX * (uMin + (float)x + (float)(z * 2)), tY * (vMin + (float)y + (float)z)))), new Vector3f((float)dir.m_122436_().m_123341_(), (float)dir.m_122436_().m_123342_(), (float)dir.m_122436_().m_123343_()));
            case Direction.SOUTH -> new BakedTurboGeometry.Polygon((List<BakedTurboGeometry.VertexRef>)ImmutableList.of((Object)new BakedTurboGeometry.VertexRef(5, new Vector2f(tX * (uMin + (float)x + (float)z), tY * (vMin + (float)y + (float)z))), (Object)new BakedTurboGeometry.VertexRef(7, new Vector2f(tX * (uMin + (float)x + (float)z), tY * (vMin + (float)z))), (Object)new BakedTurboGeometry.VertexRef(6, new Vector2f(tX * (uMin + (float)z), tY * (vMin + (float)z))), (Object)new BakedTurboGeometry.VertexRef(4, new Vector2f(tX * (uMin + (float)z), tY * (vMin + (float)y + (float)z)))), new Vector3f((float)dir.m_122436_().m_123341_(), (float)dir.m_122436_().m_123342_(), (float)dir.m_122436_().m_123343_()));
            case Direction.WEST -> new BakedTurboGeometry.Polygon((List<BakedTurboGeometry.VertexRef>)ImmutableList.of((Object)new BakedTurboGeometry.VertexRef(4, new Vector2f(tX * (uMin + (float)z), tY * (vMin + (float)y + (float)z))), (Object)new BakedTurboGeometry.VertexRef(6, new Vector2f(tX * (uMin + (float)z), tY * (vMin + (float)z))), (Object)new BakedTurboGeometry.VertexRef(2, new Vector2f(tX * uMin, tY * (vMin + (float)z))), (Object)new BakedTurboGeometry.VertexRef(0, new Vector2f(tX * uMin, tY * (vMin + (float)y + (float)z)))), new Vector3f((float)dir.m_122436_().m_123341_(), (float)dir.m_122436_().m_123342_(), (float)dir.m_122436_().m_123343_()));
            case Direction.EAST -> new BakedTurboGeometry.Polygon((List<BakedTurboGeometry.VertexRef>)ImmutableList.of((Object)new BakedTurboGeometry.VertexRef(1, new Vector2f(tX * (uMin + (float)x + (float)(2 * z)), tY * (vMin + (float)y + (float)z))), (Object)new BakedTurboGeometry.VertexRef(3, new Vector2f(tX * (uMin + (float)x + (float)(2 * z)), tY * (vMin + (float)z))), (Object)new BakedTurboGeometry.VertexRef(7, new Vector2f(tX * (uMin + (float)x + (float)z), tY * (vMin + (float)z))), (Object)new BakedTurboGeometry.VertexRef(5, new Vector2f(tX * (uMin + (float)x + (float)z), tY * (vMin + (float)y + (float)z)))), new Vector3f((float)dir.m_122436_().m_123341_(), (float)dir.m_122436_().m_123342_(), (float)dir.m_122436_().m_123343_()));
            case Direction.UP -> new BakedTurboGeometry.Polygon((List<BakedTurboGeometry.VertexRef>)ImmutableList.of((Object)new BakedTurboGeometry.VertexRef(7, new Vector2f(tX * (uMin + (float)x + (float)z), tY * (vMin + (float)z))), (Object)new BakedTurboGeometry.VertexRef(3, new Vector2f(tX * (uMin + (float)x + (float)z), tY * vMin)), (Object)new BakedTurboGeometry.VertexRef(2, new Vector2f(tX * (uMin + (float)z), tY * vMin)), (Object)new BakedTurboGeometry.VertexRef(6, new Vector2f(tX * (uMin + (float)z), tY * (vMin + (float)z)))), new Vector3f((float)dir.m_122436_().m_123341_(), (float)dir.m_122436_().m_123342_(), (float)dir.m_122436_().m_123343_()));
            case Direction.DOWN -> new BakedTurboGeometry.Polygon((List<BakedTurboGeometry.VertexRef>)ImmutableList.of((Object)new BakedTurboGeometry.VertexRef(5, new Vector2f(tX * (uMin + (float)(2 * x) + (float)z), tY * (vMin + (float)z))), (Object)new BakedTurboGeometry.VertexRef(4, new Vector2f(tX * (uMin + (float)x + (float)z), tY * (vMin + (float)z))), (Object)new BakedTurboGeometry.VertexRef(0, new Vector2f(tX * (uMin + (float)x + (float)z), tY * vMin)), (Object)new BakedTurboGeometry.VertexRef(1, new Vector2f(tX * (uMin + (float)(2 * x) + (float)z), tY * vMin))), new Vector3f((float)dir.m_122436_().m_123341_(), (float)dir.m_122436_().m_123342_(), (float)dir.m_122436_().m_123343_()));
        };
    }

    @Override
    @Nonnull
    public BakedTurboGeometry bake(@Nonnull Vector2i textureSize) {
        ImmutableList.Builder vertexBuilder = new ImmutableList.Builder();
        ImmutableList.Builder polygonBuilder = new ImmutableList.Builder();
        Quaternionf rotation = new Quaternionf().rotateY(this.eulerRotations.y * ((float)Math.PI / 180)).rotateX(this.eulerRotations.x * ((float)Math.PI / 180)).rotateZ(this.eulerRotations.z * ((float)Math.PI / 180));
        for (int z = 0; z < 2; ++z) {
            for (int y = 0; y < 2; ++y) {
                for (int x = 0; x < 2; ++x) {
                    int index = x + y * 2 + z * 4;
                    Vector3f vertex = new Vector3f((Vector3fc)this.getVertex(index));
                    vertex.rotate((Quaternionfc)rotation);
                    vertex.add((Vector3fc)this.rotationOrigin);
                    vertexBuilder.add((Object)new BakedTurboGeometry.Vertex(vertex));
                }
            }
        }
        polygonBuilder.add((Object)this.bakeQuad(textureSize, Direction.NORTH));
        polygonBuilder.add((Object)this.bakeQuad(textureSize, Direction.SOUTH));
        polygonBuilder.add((Object)this.bakeQuad(textureSize, Direction.WEST));
        polygonBuilder.add((Object)this.bakeQuad(textureSize, Direction.EAST));
        polygonBuilder.add((Object)this.bakeQuad(textureSize, Direction.UP));
        polygonBuilder.add((Object)this.bakeQuad(textureSize, Direction.DOWN));
        return new BakedTurboGeometry((List<BakedTurboGeometry.Vertex>)vertexBuilder.build(), (List<BakedTurboGeometry.Polygon>)polygonBuilder.build());
    }

    public static class Deserializer
    implements JsonDeserializer<TurboBox>,
    ITurboDeserializer {
        @Nonnull
        public TurboBox deserialize(@Nonnull JsonElement jElement, @Nonnull Type type, @Nonnull JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = jElement.getAsJsonObject();
            JsonElement jsonElement = jObject.get("box");
            if (jsonElement instanceof JsonObject) {
                JsonObject jBox = (JsonObject)jsonElement;
                Vector3f eulerRotations = this.getOrDefaultVector3f(jObject, "eulerRotations", new Vector3f());
                Vector3f rotationOrigin = this.getOrDefaultVector3f(jObject, "rotationOrigin", new Vector3f());
                if (jObject.has("shade") && !GsonHelper.m_13880_((JsonObject)jObject, (String)"shade")) {
                    throw new JsonParseException("Expected shade to be a Boolean");
                }
                boolean shade = GsonHelper.m_13855_((JsonObject)jObject, (String)"shade", (boolean)true);
                Vector3f origin = this.getOrDefaultVector3f(jBox, "origin", new Vector3f());
                Vector3f dimensions = this.getOrDefaultVector3f(jBox, "dimensions", new Vector3f());
                Vector2f uvCoords = this.getOrDefaultVector2f(jBox, "uv", new Vector2f());
                return new TurboBox(eulerRotations, rotationOrigin, shade, origin, dimensions, uvCoords);
            }
            throw new JsonParseException("This is not a TurboBox");
        }
    }
}

