/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.render.models.baked;

import com.flansmod.physics.common.util.Transform;
import com.flansmod.physics.common.util.TransformStack;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector3f;

public record BakedTurboGeometry(@Nonnull List<Vertex> vertices, @Nonnull List<Polygon> polygons) implements BakedModel
{
    public static final BakedTurboGeometry invalid = new BakedTurboGeometry((List<Vertex>)ImmutableList.of(), (List<Polygon>)ImmutableList.of());

    public boolean m_7541_() {
        return false;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return null;
    }

    public ItemOverrides m_7343_() {
        return null;
    }

    @Nonnull
    public List<BakedQuad> m_213637_(@Nullable BlockState blockState, @Nullable Direction direction, RandomSource randomSource) {
        return Collections.emptyList();
    }

    public void render(@Nonnull VertexConsumer vc, @Nonnull TransformStack transformStack, int light, int overlay, float scale) {
        Transform topPose = transformStack.top();
        boolean flipNormal = topPose.Scale.x < 0.0f ^ topPose.Scale.y < 0.0f ^ topPose.Scale.z < 0.0f;
        for (Polygon polygon : this.polygons) {
            Vector3f normal = polygon.normal();
            Vec3 nPosed = topPose.localToGlobalDirection(new Vec3((double)normal.x, (double)normal.y, (double)normal.z));
            for (int i = 0; i < polygon.vertexOrder.size(); ++i) {
                int vIndex = flipNormal ? polygon.vertexOrder.size() - 1 - i : i;
                VertexRef vertexRef = polygon.vertexOrder.get(vIndex);
                Vertex v = this.vertices.get(vertexRef.vIndex);
                Vec3 vPosed = topPose.localToGlobalPosition(new Vec3((double)(v.position().x * scale), (double)(v.position().y * scale), (double)(v.position().z * scale)));
                vc.m_5954_((float)vPosed.f_82479_, (float)vPosed.f_82480_, (float)vPosed.f_82481_, 1.0f, 1.0f, 1.0f, 1.0f, vertexRef.uv().x, vertexRef.uv().y, overlay, light, (float)nPosed.f_82479_, (float)nPosed.f_82480_, (float)nPosed.f_82481_);
            }
        }
    }

    public record Polygon(@Nonnull List<VertexRef> vertexOrder, @Nonnull Vector3f normal) {
    }

    public record VertexRef(int vIndex, @Nonnull Vector2f uv) {
    }

    public record Vertex(@Nonnull Vector3f position) {
    }
}

