/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.render.models;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.util.GsonHelper;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.joml.Vector3f;

public interface ITurboDeserializer {
    @Nonnull
    default public Direction getFacing(@Nonnull String str) {
        Direction direction = Direction.m_122402_((String)str);
        if (direction == null) {
            throw new JsonParseException("Unknown facing: " + str);
        }
        return direction;
    }

    @Nonnull
    default public Vector3f getVector3f(@Nonnull JsonArray jArray) {
        if (jArray.size() != 3) {
            throw new JsonParseException("Expected 3 values, found: " + jArray.size());
        }
        float[] afloat = new float[3];
        for (int i = 0; i < afloat.length; ++i) {
            afloat[i] = GsonHelper.m_13888_((JsonElement)jArray.get(i), (String)("getVector3f[" + i + "]"));
        }
        return new Vector3f(afloat[0], afloat[1], afloat[2]);
    }

    @Nonnull
    default public Vector3f getOrDefaultVector3f(@Nonnull JsonArray jArray, @Nonnull Vector3f defaultValue) {
        try {
            return this.getVector3f(jArray);
        }
        catch (JsonParseException jsonParseException) {
            return defaultValue;
        }
    }

    @Nonnull
    default public Vector3f getVector3f(@Nonnull JsonElement jObject) {
        return this.getVector3f(jObject.getAsJsonArray());
    }

    @Nonnull
    default public Vector3f getOrDefaultVector3f(@Nonnull JsonElement jObject, @Nonnull Vector3f defaultValue) {
        if (jObject.isJsonArray()) {
            return this.getOrDefaultVector3f(jObject.getAsJsonArray(), defaultValue);
        }
        return defaultValue;
    }

    @Nonnull
    default public Vector3f getVector3f(@Nonnull JsonObject jObject, @Nonnull String key) {
        return this.getVector3f(GsonHelper.m_13933_((JsonObject)jObject, (String)key));
    }

    @Nonnull
    default public Vector3f getOrDefaultVector3f(@Nonnull JsonObject jObject, @Nonnull String key, @Nonnull Vector3f defaultValue) {
        if (GsonHelper.m_13885_((JsonObject)jObject, (String)key)) {
            return this.getOrDefaultVector3f(GsonHelper.m_13933_((JsonObject)jObject, (String)key), defaultValue);
        }
        return defaultValue;
    }

    @Nonnull
    default public Vector2i getVector2i(@Nonnull JsonArray jArray) {
        if (jArray.size() != 2) {
            throw new JsonParseException("Expected 2 values, found: " + jArray.size());
        }
        int[] aint = new int[2];
        for (int i = 0; i < aint.length; ++i) {
            aint[i] = GsonHelper.m_13897_((JsonElement)jArray.get(i), (String)("getVector2i[" + i + "]"));
        }
        return new Vector2i(aint[0], aint[1]);
    }

    @Nonnull
    default public Vector2f getVector2f(@Nonnull JsonArray jArray) {
        if (jArray.size() != 2) {
            throw new JsonParseException("Expected 2 values, found: " + jArray.size());
        }
        float[] afloat = new float[2];
        for (int i = 0; i < afloat.length; ++i) {
            afloat[i] = GsonHelper.m_13888_((JsonElement)jArray.get(i), (String)("getVector2f[" + i + "]"));
        }
        return new Vector2f(afloat[0], afloat[1]);
    }

    @Nonnull
    default public Vector2f getOrDefaultVector2f(@Nonnull JsonArray jArray, @Nonnull Vector2f defaultValue) {
        try {
            return this.getVector2f(jArray);
        }
        catch (JsonParseException jsonParseException) {
            return defaultValue;
        }
    }

    @Nonnull
    default public Vector2f getVector2f(@Nonnull JsonElement jObject) {
        return this.getVector2f(jObject.getAsJsonArray());
    }

    @Nonnull
    default public Vector2f getOrDefaultVector2f(@Nonnull JsonElement jObject, @Nonnull Vector2f defaultValue) {
        if (jObject.isJsonArray()) {
            return this.getOrDefaultVector2f(jObject.getAsJsonArray(), defaultValue);
        }
        return defaultValue;
    }

    @Nonnull
    default public Vector2f getVector2f(@Nonnull JsonObject jObject, @Nonnull String key) {
        return this.getVector2f(GsonHelper.m_13933_((JsonObject)jObject, (String)key));
    }

    @Nonnull
    default public Vector2f getOrDefaultVector2f(@Nonnull JsonObject jObject, @Nonnull String key, @Nonnull Vector2f defaultValue) {
        if (GsonHelper.m_13885_((JsonObject)jObject, (String)key)) {
            return this.getOrDefaultVector2f(GsonHelper.m_13933_((JsonObject)jObject, (String)key), defaultValue);
        }
        return defaultValue;
    }
}

