/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.render.models;

import com.flansmod.client.render.IClientFlanItemExtensions;
import com.flansmod.client.render.models.ITurboRenderer;
import com.flansmod.client.render.models.baked.BakedTurboRig;
import com.flansmod.client.render.models.unbaked.TurboRig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.ForgeRegistries;

public class FlansModelRegistry
implements PreparableReloadListener {
    private static final List<ModelLoadOp> ModelLoadOps = new ArrayList<ModelLoadOp>();
    private static final Map<ResourceLocation, TurboRig> UnbakedRigs = new HashMap<ResourceLocation, TurboRig>();
    private static final Map<ResourceLocation, BakedTurboRig> BakedRigs = new HashMap<ResourceLocation, BakedTurboRig>();
    private static final Map<ResourceLocation, ITurboRenderer> RendererLookup = new HashMap<ResourceLocation, ITurboRenderer>();

    public static void PreRegisterModel(@Nonnull ResourceLocation loc) {
        ModelLoadOps.add(new ModelLoadOp(() -> loc));
    }

    public static void PreRegisterModel(@Nonnull Supplier<ResourceLocation> locProvider) {
        ModelLoadOps.add(new ModelLoadOp(locProvider));
    }

    public static void PreRegisterRenderer(@Nonnull ResourceLocation loc, @Nonnull ITurboRenderer renderer) {
        ModelLoadOps.add(new ModelLoadOp(() -> loc));
        RendererLookup.put(loc, renderer);
    }

    public static void PreRegisterRenderer(@Nonnull Supplier<ResourceLocation> locProvider, @Nonnull ITurboRenderer renderer) {
        ModelLoadOps.add(new ModelLoadOp(locProvider));
        RendererLookup.put(locProvider.get(), renderer);
    }

    @Nullable
    public static ITurboRenderer GetItemRenderer(@Nonnull Item item) {
        IClientItemExtensions iClientItemExtensions = IClientItemExtensions.of((Item)item);
        if (iClientItemExtensions instanceof IClientFlanItemExtensions) {
            IClientFlanItemExtensions flanItemExtensions = (IClientFlanItemExtensions)iClientItemExtensions;
            return flanItemExtensions.GetTurboRenderer();
        }
        return null;
    }

    @Nullable
    public static ITurboRenderer GetItemRenderer(@Nonnull ItemStack stack) {
        IClientItemExtensions iClientItemExtensions = IClientItemExtensions.of((ItemStack)stack);
        if (iClientItemExtensions instanceof IClientFlanItemExtensions) {
            IClientFlanItemExtensions flanItemExtensions = (IClientFlanItemExtensions)iClientItemExtensions;
            return flanItemExtensions.GetTurboRenderer();
        }
        return null;
    }

    @Nullable
    public static ITurboRenderer GetItemRenderer(@Nonnull ResourceLocation modelLoc) {
        if (RendererLookup.containsKey(modelLoc)) {
            return RendererLookup.get(modelLoc);
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(modelLoc);
        ITurboRenderer renderer = item != null ? FlansModelRegistry.GetItemRenderer(item) : null;
        RendererLookup.put(modelLoc, renderer);
        return renderer;
    }

    public void Hook(@Nonnull IEventBus modEventBus) {
        modEventBus.addListener(this::OnModelRegistry);
        modEventBus.addListener(this::OnModelBake);
        modEventBus.addListener(this::OnBakingComplete);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void OnRegisterGeometryLoaders(@Nonnull ModelEvent.RegisterGeometryLoaders event) {
        event.register("turborig", (IGeometryLoader)TurboRig.LOADER);
    }

    public void OnModelRegistry(@Nonnull ModelEvent.RegisterAdditional event) {
        for (ModelLoadOp op : ModelLoadOps) {
            event.register((ResourceLocation)new ModelResourceLocation(op.locationProvider.get(), "inventory"));
        }
    }

    public void OnBakingComplete(@Nonnull ModelEvent.BakingCompleted event) {
        ModelBakery bakery = Minecraft.m_91087_().m_91304_().getModelBakery();
        for (ModelLoadOp op : ModelLoadOps) {
            IUnbakedGeometry iUnbakedGeometry;
            ResourceLocation resLoc = op.locationProvider.get();
            ModelResourceLocation modelID = new ModelResourceLocation(resLoc, "inventory");
            UnbakedModel unbaked = bakery.m_119341_((ResourceLocation)modelID);
            if (!(unbaked instanceof BlockModel)) continue;
            BlockModel blockModel = (BlockModel)unbaked;
            if (!blockModel.customData.hasCustomGeometry() || !((iUnbakedGeometry = blockModel.customData.getCustomGeometry()) instanceof TurboRig)) continue;
            TurboRig unbakedRig = (TurboRig)iUnbakedGeometry;
            UnbakedRigs.put(resLoc, unbakedRig);
        }
    }

    public void OnModelBake(@Nonnull ModelEvent.ModifyBakingResult event) {
        Map modelRegistry = event.getModels();
        TextureManager tm = Minecraft.m_91087_().f_90987_;
        for (ModelLoadOp op : ModelLoadOps) {
            ResourceLocation resLoc = op.locationProvider.get();
            ModelResourceLocation modelID = new ModelResourceLocation(resLoc, "inventory");
            BakedModel bakedModel = (BakedModel)modelRegistry.get(modelID);
            if (!(bakedModel instanceof BakedTurboRig)) continue;
            BakedTurboRig turboBaked = (BakedTurboRig)bakedModel;
            BakedRigs.put(resLoc, turboBaked);
        }
    }

    @Nullable
    public BakedTurboRig getBakedRig(@Nonnull ResourceLocation modelLocation) {
        return BakedRigs.get(modelLocation);
    }

    @Nonnull
    public CompletableFuture<Void> m_5540_(@Nonnull PreparableReloadListener.PreparationBarrier preparationBarrier, @Nonnull ResourceManager resourceManager, @Nonnull ProfilerFiller filler1, @Nonnull ProfilerFiller filler2, @Nonnull Executor executor1, @Nonnull Executor executor2) {
        return CompletableFuture.allOf(new CompletableFuture[0]);
    }

    private record ModelLoadOp(@Nonnull Supplier<ResourceLocation> locationProvider) {
    }
}

