/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.render.effects;

import com.flansmod.client.render.FirstPersonManager;
import com.flansmod.client.render.RenderContext;
import com.flansmod.client.render.models.FlansModelRegistry;
import com.flansmod.client.render.models.ITurboRenderer;
import com.flansmod.common.actions.ActionGroupInstance;
import com.flansmod.common.actions.ActionInstance;
import com.flansmod.common.actions.contexts.GunContext;
import com.flansmod.common.actions.contexts.GunContextPlayer;
import com.flansmod.common.actions.contexts.ShooterContext;
import com.flansmod.common.actions.nodes.AttachEffectAction;
import com.flansmod.physics.common.util.MinecraftHelpers;
import com.flansmod.physics.common.util.Transform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class FlashEffectRenderer {
    private final RandomSource random = RandomSource.m_216327_();

    public FlashEffectRenderer() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void OnRenderFirstPersonHands(@Nonnull RenderHandEvent event) {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        ShooterContext playerContext = ShooterContext.of((Entity)Minecraft.m_91087_().f_91074_);
        if (!playerContext.IsValid()) {
            return;
        }
        for (GunContext gunContext : playerContext.GetAllGunContexts()) {
            if (!gunContext.IsValid()) continue;
            for (ActionGroupInstance actionGroup : gunContext.GetActionStack().GetActiveActionGroups()) {
                for (ActionInstance actionInstance : actionGroup.GetActions()) {
                    if (!(actionInstance instanceof AttachEffectAction)) continue;
                    AttachEffectAction attachEffectAction = (AttachEffectAction)actionInstance;
                    if (attachEffectAction.TicksSinceTrigger != 0) continue;
                    this.RenderFlashEffectOnEntity(event.getPoseStack(), null, gunContext, attachEffectAction.GetRelativeAPName(), attachEffectAction.EffectModelLocation(), attachEffectAction.EffectTextureLocation());
                }
            }
        }
    }

    @SubscribeEvent
    public void RenderTick(@Nonnull RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        if (Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        RenderSystem.setShader(GameRenderer::m_172820_);
        for (Player player : Minecraft.m_91087_().f_91073_.m_6907_()) {
            ShooterContext playerContext = ShooterContext.of((Entity)player);
            if (!playerContext.IsValid() || playerContext.IsLocalPlayerOwner() && Minecraft.m_91087_().f_91066_.m_92176_().m_90612_()) continue;
            for (GunContext gunContext : playerContext.GetAllGunContexts()) {
                if (!gunContext.IsValid()) continue;
                for (ActionGroupInstance actionGroup : gunContext.GetActionStack().GetActiveActionGroups()) {
                    for (ActionInstance actionInstance : actionGroup.GetActions()) {
                        if (!(actionInstance instanceof AttachEffectAction)) continue;
                        AttachEffectAction attachEffectAction = (AttachEffectAction)actionInstance;
                        if (attachEffectAction.TicksSinceTrigger > 0) continue;
                        this.RenderFlashEffectOnEntity(event.getPoseStack(), event.getCamera(), gunContext, attachEffectAction.GetRelativeAPName(), attachEffectAction.EffectModelLocation(), attachEffectAction.EffectTextureLocation());
                    }
                }
            }
        }
    }

    public void RenderFlashEffectOnEntity(@Nonnull PoseStack poseStack, @Nullable Camera camera, @Nonnull GunContext gunContext, @Nonnull String relativeAPName, @Nonnull ResourceLocation modelLoc, @Nonnull ResourceLocation textureLoc) {
        ITurboRenderer renderer = FlansModelRegistry.GetItemRenderer(modelLoc);
        if (renderer != null) {
            ItemDisplayContext transformType = ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
            if (gunContext instanceof GunContextPlayer) {
                GunContextPlayer playerGunContext = (GunContextPlayer)gunContext;
                transformType = !Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() || !gunContext.GetShooter().IsLocalPlayerOwner() ? MinecraftHelpers.getThirdPersonTransformType(gunContext.GetShooter().IsLocalPlayerOwner(), playerGunContext.GetHand()) : MinecraftHelpers.getFirstPersonTransformType(playerGunContext.GetHand());
            }
            int light = camera != null ? camera.getBlockAtCamera().m_60791_() : 0;
            RenderContext renderContext = new RenderContext((MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), transformType, poseStack, light, 0);
            renderContext.Transforms.push();
            if (camera != null) {
                renderContext.Transforms.add(Transform.fromPos(camera.m_90583_().m_82490_(-1.0)));
            }
            if (transformType.m_269069_()) {
                FirstPersonManager.ApplyEyeToRoot(renderContext.Transforms, gunContext, transformType);
                FirstPersonManager.ApplyRootToModel(renderContext.Transforms, gunContext, transformType);
                FirstPersonManager.ApplyModelToAP(renderContext.Transforms, gunContext, relativeAPName, true);
                renderContext.Transforms.add(Transform.fromScale(2.0f));
            } else {
                renderContext.Transforms.add(FirstPersonManager.GetWorldSpaceAPTransform(gunContext, transformType, relativeAPName));
            }
            renderContext.Transforms.add(Transform.fromPos(0.0, 0.0, -0.0625));
            renderer.renderDirect(null, null, renderContext);
            renderContext.Transforms.pop();
        }
    }
}

