/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.render.bullets;

import com.flansmod.client.render.RenderContext;
import com.flansmod.client.render.bullets.CasingRenderer;
import com.flansmod.client.render.models.FlansModelRegistry;
import com.flansmod.common.FlansMod;
import com.flansmod.common.item.GunItem;
import com.flansmod.common.projectiles.CasingEntity;
import com.flansmod.common.types.guns.GunDefinition;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class CasingEntityRenderer
extends EntityRenderer<CasingEntity> {
    public CasingEntityRenderer(EntityRendererProvider.Context p_174008_) {
        super(p_174008_);
    }

    public ResourceLocation getTextureLocation(CasingEntity casing) {
        return new ResourceLocation(casing.GetContext().Def.casingModel);
    }

    public void render(@Nonnull CasingEntity casing, float yaw, float partialTick, @Nonnull PoseStack pose, @Nonnull MultiBufferSource buffers, int light) {
        GunDefinition def = casing.GetContext().Def;
        ResourceLocation loc = new ResourceLocation(casing.GetContext().Def.casingModel);
        Item item = casing.GetContext().GetItemStack().m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            if (!gunItem.GetMagazineType((ItemStack)casing.GetContext().GetItemStack(), (String)casing.GetContext().GetActionGroupContextByHash((int)casing.GetActionGroupPathHash()).GroupPath, (int)0).casingModelOverride.isEmpty()) {
                loc = new ResourceLocation(gunItem.GetMagazineType((ItemStack)casing.GetContext().GetItemStack(), (String)casing.GetContext().GetActionGroupContextByHash((int)casing.GetActionGroupPathHash()).GroupPath, (int)0).casingModelOverride);
            }
        }
        CasingRenderer casingRenderer = (CasingRenderer)FlansModelRegistry.GetItemRenderer(loc);
        boolean noRender = false;
        if (casingRenderer != null) {
            pose.m_85836_();
            ItemDisplayContext display = ItemDisplayContext.FIXED;
            if (Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() && casing.GetContext().GetShooter().IsLocalPlayerOwner()) {
                pose.m_85837_(casing.firstPersonOffset.m_7096_(), casing.firstPersonOffset.m_7098_(), casing.firstPersonOffset.m_7094_());
                display = ItemDisplayContext.FIRST_PERSON_RIGHT_HAND;
                if (casing.lifeTime < 8) {
                    noRender = true;
                }
            }
            float y = Mth.m_14179_((float)partialTick, (float)casing.f_19859_, (float)casing.m_146908_());
            float x = -Mth.m_14179_((float)partialTick, (float)casing.f_19860_, (float)casing.m_146909_());
            pose.m_252781_(Axis.f_252436_.m_252977_(y));
            pose.m_252781_(Axis.f_252403_.m_252977_(x));
            RenderContext context = new RenderContext(buffers, display, pose, light, 655360);
            if (!noRender) {
                casingRenderer.renderDirect((Entity)casing, ItemStack.f_41583_, context);
            }
            pose.m_85849_();
        } else {
            FlansMod.LOGGER.warn("Could not find bullet renderer for " + casing);
        }
    }
}

