/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.render.animation;

import com.flansmod.client.render.animation.elements.KeyframeDefinition;
import com.flansmod.client.render.animation.elements.ModalSequenceDefinition;
import com.flansmod.client.render.animation.elements.PoseDefinition;
import com.flansmod.client.render.animation.elements.SequenceDefinition;
import com.flansmod.client.render.animation.elements.SequenceEntryDefinition;
import com.flansmod.common.types.JsonDefinition;
import com.flansmod.common.types.JsonField;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public class FlanimationDefinition
extends JsonDefinition {
    public static final String TYPE = "flanimation";
    public static final String FOLDER = "flanimations";
    public static final FlanimationDefinition INVALID = new FlanimationDefinition(new ResourceLocation("flansmod", "animations/null"));
    @JsonField
    public KeyframeDefinition[] keyframes = new KeyframeDefinition[0];
    @JsonField
    public SequenceDefinition[] sequences = new SequenceDefinition[0];
    @JsonField
    public ModalSequenceDefinition[] modalSequences = new ModalSequenceDefinition[0];

    public FlanimationDefinition(@Nonnull ResourceLocation srcLoc) {
        super(srcLoc);
    }

    @Override
    public String GetTypeName() {
        return TYPE;
    }

    @Nullable
    public ModalSequenceDefinition GetModalSequence(@Nonnull String modeName) {
        for (ModalSequenceDefinition modal : this.modalSequences) {
            if (!modal.modeName.equalsIgnoreCase(modeName)) continue;
            return modal;
        }
        return null;
    }

    @Nullable
    public SequenceDefinition GetSequence(@Nonnull String name) {
        for (SequenceDefinition sequence : this.sequences) {
            if (!sequence.name.equalsIgnoreCase(name)) continue;
            return sequence;
        }
        return null;
    }

    @Nullable
    public KeyframeDefinition GetKeyframe(@Nullable SequenceEntryDefinition entry) {
        return entry == null ? null : this.GetKeyframe(entry.frame);
    }

    @Nullable
    public KeyframeDefinition GetKeyframe(@Nonnull String name) {
        for (KeyframeDefinition keyframe : this.keyframes) {
            if (!keyframe.name.equals(name)) continue;
            return keyframe;
        }
        return null;
    }

    @Nonnull
    public PoseDefinition GetPoseForPart(@Nonnull KeyframeDefinition keyframe, @Nonnull String partName) {
        return this.GetPoseForPartOptional(keyframe, partName).orElse(PoseDefinition.Identity());
    }

    @Nonnull
    private Optional<PoseDefinition> GetPoseForPartOptional(@Nonnull KeyframeDefinition keyframe, @Nonnull String partName) {
        if (keyframe.HasPoseForPart(partName)) {
            return Optional.of(keyframe.GetPoseForPart(partName));
        }
        for (String parent : keyframe.parents) {
            Optional<PoseDefinition> poseFromParent;
            KeyframeDefinition parentKeyframe = this.GetKeyframe(parent);
            if (parentKeyframe == null || !(poseFromParent = this.GetPoseForPartOptional(parentKeyframe, partName)).isPresent()) continue;
            return poseFromParent;
        }
        return Optional.empty();
    }
}

