/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.render;

import com.flansmod.client.render.FirstPersonManager;
import com.flansmod.client.render.RenderContext;
import com.flansmod.client.render.animation.FlanimationDefinition;
import com.flansmod.client.render.models.ITurboRenderer;
import com.flansmod.client.render.models.TurboRigWrapper;
import com.flansmod.client.render.models.baked.BakedAttachPoint;
import com.flansmod.client.render.models.baked.BakedTurboRig;
import com.flansmod.common.actions.ActionStack;
import com.flansmod.common.actions.contexts.GunContext;
import com.flansmod.common.item.FlanItem;
import com.flansmod.common.types.attachments.EAttachmentType;
import com.flansmod.physics.common.util.EContextSide;
import com.flansmod.physics.common.util.Transform;
import com.flansmod.physics.common.util.TransformStack;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public abstract class FlanItemModelRenderer
extends BlockEntityWithoutLevelRenderer
implements ITurboRenderer {
    public static final ResourceLocation invalidModelLoc = new ResourceLocation("flansmod", "models/unknown");
    public static final Supplier<ResourceLocation> invalidModelLocGetter = () -> invalidModelLoc;
    public final boolean ShouldRenderWhenHeld;
    @Nullable
    public final FlanItem Item;
    protected final TurboRigWrapper rigWrapper;
    private ResourceLocation locationOverride;

    public FlanItemModelRenderer(@Nullable FlanItem flanItem, boolean shouldRenderWhenHeld) {
        super(null, null);
        this.Item = flanItem;
        this.ShouldRenderWhenHeld = shouldRenderWhenHeld;
        this.rigWrapper = new TurboRigWrapper(this.Item != null ? this.Item::getDefinitionLocation : invalidModelLocGetter);
    }

    public FlanItemModelRenderer(@Nullable FlanItem flanItem, boolean shouldRenderWhenHeld, ResourceLocation loc) {
        super(null, null);
        this.Item = flanItem;
        this.ShouldRenderWhenHeld = shouldRenderWhenHeld;
        this.locationOverride = loc;
        this.rigWrapper = new TurboRigWrapper(this::getLocationOverride);
    }

    public ResourceLocation getLocationOverride() {
        return this.locationOverride;
    }

    protected void ifRigFound(@Nonnull Consumer<BakedTurboRig> func) {
        this.rigWrapper.ifRigFound(func);
    }

    protected void ifAnyModelFound(@Nonnull Consumer<BakedModel> func) {
        this.rigWrapper.ifAnyModelFound(func);
    }

    protected void ifRigOrOtherwise(@Nonnull Consumer<BakedTurboRig> rigFunc, @Nonnull Consumer<BakedModel> backupFunc) {
        this.rigWrapper.ifRigOrOtherwise(rigFunc, backupFunc);
    }

    @Nullable
    protected <T> T getOrDefault(@Nonnull Function<BakedTurboRig, T> getFunc, @Nullable T defaultValue) {
        return this.rigWrapper.getOrDefault(getFunc, defaultValue);
    }

    @Nullable
    protected <T> T getRigOrOtherwise(@Nonnull Function<BakedTurboRig, T> rigGetFunc, @Nonnull Function<BakedModel, T> backupGetFunc, @Nullable T defaultValue) {
        return this.rigWrapper.getRigOrOtherwise(rigGetFunc, backupGetFunc, defaultValue);
    }

    public void m_108829_(@Nonnull ItemStack stack, @Nonnull ItemDisplayContext transformType, @Nonnull PoseStack ms, @Nonnull MultiBufferSource buffers, int light, int overlay) {
        FlanItem flanItem;
        TransformStack transformStack = TransformStack.of(ms);
        boolean shouldRenderIcon = false;
        Item item = stack.m_41720_();
        if (item instanceof FlanItem && (flanItem = (FlanItem)item).ShouldRenderAsIcon(transformType)) {
            shouldRenderIcon = true;
        }
        if (shouldRenderIcon) {
            String skin = FlanItem.GetPaintjobName(stack);
            BakedModel iconModel = this.getRigOrOtherwise(rig -> rig.getIconModel(skin), other -> other, null);
            if (iconModel != null) {
                PoseStack poseStack = null;
                switch (transformType) {
                    case GUI: {
                        poseStack = transformStack.top().toNewPoseStack();
                        Lighting.m_84930_();
                        break;
                    }
                    default: {
                        poseStack = transformStack.top().toNewPoseStack();
                        poseStack.m_85841_(0.55f, 0.55f, 0.55f);
                        poseStack.m_252880_(0.4f, 0.5f, 0.5f);
                    }
                }
                VertexConsumer buff = buffers.m_6299_(RenderType.m_110463_());
                buff.m_6122_(1, 1, 1, 1);
                Minecraft.m_91087_().m_91289_().m_110937_().m_111067_(poseStack.m_85850_(), buff, null, iconModel, 1.0f, 1.0f, 1.0f, light, overlay);
            } else {
                shouldRenderIcon = false;
            }
        }
        if (!shouldRenderIcon) {
            FirstPersonManager.ApplyRootToModel(transformStack, GunContext.of(stack, EContextSide.Client), transformType);
            LocalPlayer heldBy = transformType.m_269069_() ? Minecraft.m_91087_().f_91074_ : null;
            this.doRender((Entity)heldBy, stack, new RenderContext(buffers, transformType, transformStack, light, overlay));
        }
    }

    @Override
    public void renderDirect(@Nullable Entity heldByEntity, @Nullable ItemStack stack, @Nonnull RenderContext renderContext) {
        renderContext.Transforms.push();
        this.doRender(heldByEntity, stack, renderContext);
        renderContext.Transforms.pop();
    }

    protected abstract void doRender(@Nullable Entity var1, @Nullable ItemStack var2, @Nonnull RenderContext var3);

    protected void applyAnimations(@Nonnull RenderContext renderContext, @Nonnull FlanimationDefinition animationSet, @Nullable ActionStack actionStack, @Nonnull String partName) {
        renderContext.Transforms.add(this.getPose(animationSet, actionStack, partName));
    }

    @Nonnull
    protected Transform getPose(@Nonnull FlanimationDefinition animationSet, @Nullable ActionStack actionStack, @Nonnull String sectionName) {
        return this.getOrDefault(rig -> rig.getPose(sectionName, this.getDefLoc(), animationSet, actionStack), Transform.IDENTITY);
    }

    @Nonnull
    public Transform getPosePublic(@Nonnull FlanimationDefinition animationSet, @Nullable ActionStack actionStack, @Nonnull String sectionName) {
        return this.getOrDefault(rig -> rig.getPose(sectionName, this.getDefLoc(), animationSet, actionStack), Transform.IDENTITY);
    }

    public boolean hasSection(@Nonnull String sectionName) {
        return this.getOrDefault(rig -> rig.hasSection(sectionName), false);
    }

    private void applyItemArmTransform(PoseStack poseStack, HumanoidArm arm, float equipProgress) {
        int i = arm == HumanoidArm.RIGHT ? 1 : -1;
        poseStack.m_252880_((float)i * 0.56f, -0.52f + equipProgress * -0.6f, -0.72f);
    }

    @Nonnull
    public ResourceLocation getSkin(@Nullable ItemStack stack) {
        String skin = stack != null ? FlanItem.GetPaintjobName(stack) : "default";
        return this.getOrDefault(rig -> rig.getSkin(skin), invalidModelLoc);
    }

    @Nonnull
    public Map<String, Float> getParameters() {
        return this.getOrDefault(BakedTurboRig::floatParameters, Map.of());
    }

    @Nonnull
    public ResourceLocation getDefLoc() {
        return this.Item != null ? this.Item.DefinitionLocation : invalidModelLoc;
    }

    protected void RenderFirstPersonArm(PoseStack poseStack) {
    }

    protected void renderSectionIteratively(@Nonnull RenderContext renderContext, @Nonnull String sectionName, @Nonnull Function<String, ResourceLocation> textureFunc, @Nonnull BiFunction<String, RenderContext, Boolean> preRenderFunc, @Nonnull BiConsumer<String, RenderContext> postRenderFunc) {
        this.ifRigFound(rig -> rig.renderSectionIteratively(renderContext, sectionName, textureFunc, preRenderFunc, postRenderFunc));
    }

    protected void RenderAttachedEffect(String attachPointName, ResourceLocation texture, ResourceLocation model, RenderContext renderContext) {
    }

    public void ApplyAPOffsetInternal(@Nonnull TransformStack transformStack, @Nonnull String apName, @Nullable FlanimationDefinition animationSet, @Nullable ActionStack actionStack) {
        this.ifRigFound(rig -> {
            BakedAttachPoint ap = rig.getAP(apName);
            if (ap.parent() != null) {
                this.ApplyAPOffsetInternal(transformStack, ap.parent(), animationSet, actionStack);
            }
            transformStack.add(ap.offset());
            if (animationSet != null && actionStack != null) {
                transformStack.add(this.getPose(animationSet, actionStack, apName));
            }
        });
    }

    @Nonnull
    public String getAPKey(@Nonnull EAttachmentType attachmentType, int attachmentIndex) {
        return this.getOrDefault(rig -> rig.getAPKey(attachmentType, attachmentIndex), this.getDefaultAPKey(attachmentType, attachmentIndex));
    }

    @Nonnull
    public String getDefaultAPKey(@Nonnull EAttachmentType attachmentType, int attachmentIndex) {
        return attachmentType.unindexedName(attachmentIndex);
    }
}

