/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.input;

import com.flansmod.client.FlansModClient;
import com.flansmod.client.input.KeyMappings;
import com.flansmod.common.item.GunItem;
import com.flansmod.common.types.elements.EPlayerInput;
import com.flansmod.common.types.vehicles.EVehicleAxis;
import com.flansmod.physics.common.util.Maths;
import javax.annotation.Nonnull;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWGamepadState;

public class ClientInputHooks {
    private static final HoldableInput Use = new HoldableInput();
    private static final HoldableInput Attack = new HoldableInput();
    private static final HoldableInput MoveRight = new HoldableInput();
    private static final HoldableInput MoveForward = new HoldableInput();
    private static final HoldableInput MoveBack = new HoldableInput();
    private static final HoldableInput MoveLeft = new HoldableInput();
    private static final HoldableInput MoveUp = new HoldableInput();
    private static final HoldableInput MoveDown = new HoldableInput();
    private static final HoldableInput Jump = new HoldableInput();
    private static final HoldableInput Sneak = new HoldableInput();
    private static final HoldableInput Sprint = new HoldableInput();
    private static final HoldableInput GearUp = new HoldableInput();
    private static final HoldableInput GearDown = new HoldableInput();
    private static final HoldableInput YawLeft = new HoldableInput();
    private static final HoldableInput YawRight = new HoldableInput();
    private static final HoldableInput PitchUp = new HoldableInput();
    private static final HoldableInput PitchDown = new HoldableInput();
    private static final HoldableInput RollLeft = new HoldableInput();
    private static final HoldableInput RollRight = new HoldableInput();
    private static final HoldableAxis MouseYaw = new HoldableAxis();
    private static final HoldableAxis MousePitch = new HoldableAxis();
    private static final HoldableAxis MouseRoll = new HoldableAxis();
    private static final HoldableAxis GamepadYaw = new HoldableAxis();
    private static final HoldableAxis GamepadPitch = new HoldableAxis();
    private static final HoldableAxis GamepadRoll = new HoldableAxis();
    private static final HoldableAxis GamepadForward = new HoldableAxis();
    private static final HoldableAxis GamepadRight = new HoldableAxis();
    private static final HoldableAxis GamepadUp = new HoldableAxis();
    private static final HoldableInput LookAt = new HoldableInput();
    private static final HoldableInput ModeToggle = new HoldableInput();
    private static final HoldableInput ManualReload = new HoldableInput();

    public static float Positive(@Nonnull HoldableInput input) {
        return input.IsHeld() ? 1.0f : 0.0f;
    }

    public static float Negative(@Nonnull HoldableInput input) {
        return input.IsHeld() ? -1.0f : 0.0f;
    }

    public static float GetYaw() {
        return Maths.clamp(ClientInputHooks.MouseYaw.Value + ClientInputHooks.GamepadYaw.Value + ClientInputHooks.Positive(YawRight) + ClientInputHooks.Negative(YawLeft), -1.0f, 1.0f);
    }

    public static float GetPitch() {
        return Maths.clamp(ClientInputHooks.MousePitch.Value + ClientInputHooks.GamepadPitch.Value + ClientInputHooks.Positive(PitchUp) + ClientInputHooks.Negative(PitchDown), -1.0f, 1.0f);
    }

    public static float GetRoll() {
        return Maths.clamp(ClientInputHooks.MouseRoll.Value + ClientInputHooks.GamepadRoll.Value + ClientInputHooks.Positive(RollRight) + ClientInputHooks.Negative(RollLeft), -1.0f, 1.0f);
    }

    public static float GetMoveForward() {
        return Maths.clamp(ClientInputHooks.GamepadForward.Value + ClientInputHooks.Positive(MoveForward) + ClientInputHooks.Negative(MoveBack), -1.0f, 1.0f);
    }

    public static float GetMoveRight() {
        return Maths.clamp(ClientInputHooks.GamepadRight.Value + ClientInputHooks.Positive(MoveRight) + ClientInputHooks.Negative(MoveLeft), -1.0f, 1.0f);
    }

    public static float GetMoveUp() {
        return Maths.clamp(ClientInputHooks.GamepadUp.Value + ClientInputHooks.Positive(MoveUp) + ClientInputHooks.Negative(MoveDown), -1.0f, 1.0f);
    }

    public static boolean CheckPositive(float f) {
        return f > 0.01f;
    }

    public static boolean CheckNegative(float f) {
        return f < -0.01f;
    }

    public static boolean GetInput(@Nonnull EPlayerInput additionalKey) {
        return switch (additionalKey) {
            default -> throw new IncompatibleClassChangeError();
            case EPlayerInput.MoveForward -> ClientInputHooks.CheckPositive(ClientInputHooks.GetMoveForward());
            case EPlayerInput.MoveBackward -> ClientInputHooks.CheckNegative(ClientInputHooks.GetMoveForward());
            case EPlayerInput.MoveLeft -> ClientInputHooks.CheckNegative(ClientInputHooks.GetMoveRight());
            case EPlayerInput.MoveRight -> ClientInputHooks.CheckPositive(ClientInputHooks.GetMoveRight());
            case EPlayerInput.YawLeft -> ClientInputHooks.CheckNegative(ClientInputHooks.GetYaw());
            case EPlayerInput.YawRight -> ClientInputHooks.CheckPositive(ClientInputHooks.GetYaw());
            case EPlayerInput.RollLeft -> ClientInputHooks.CheckNegative(ClientInputHooks.GetRoll());
            case EPlayerInput.RollRight -> ClientInputHooks.CheckPositive(ClientInputHooks.GetRoll());
            case EPlayerInput.PitchUp -> ClientInputHooks.CheckPositive(ClientInputHooks.GetPitch());
            case EPlayerInput.PitchDown -> ClientInputHooks.CheckNegative(ClientInputHooks.GetPitch());
            case EPlayerInput.Fire1 -> Attack.IsPressed();
            case EPlayerInput.Fire2 -> Use.IsPressed();
            case EPlayerInput.Fire3 -> false;
            case EPlayerInput.Reload1 -> ManualReload.IsPressed();
            case EPlayerInput.Reload2 -> false;
            case EPlayerInput.Reload3 -> false;
            case EPlayerInput.Jump -> Jump.IsPressed();
            case EPlayerInput.Sprint -> Sprint.IsPressed();
            case EPlayerInput.SpecialKey1 -> LookAt.IsPressed();
            case EPlayerInput.SpecialKey2 -> ModeToggle.IsPressed();
            case EPlayerInput.GearUp -> GearUp.IsPressed();
            case EPlayerInput.GearDown -> GearDown.IsPressed();
        };
    }

    public static float GetInput(@Nonnull EVehicleAxis control) {
        return switch (control) {
            case EVehicleAxis.Roll -> ClientInputHooks.GetRoll();
            case EVehicleAxis.Yaw -> ClientInputHooks.GetYaw();
            case EVehicleAxis.Pitch -> ClientInputHooks.GetPitch();
            case EVehicleAxis.MoveX -> ClientInputHooks.GetMoveRight();
            case EVehicleAxis.MoveY -> ClientInputHooks.GetMoveUp();
            case EVehicleAxis.MoveZ -> ClientInputHooks.GetMoveForward();
            case EVehicleAxis.Accelerator -> ClientInputHooks.GetMoveForward();
            default -> 0.0f;
        };
    }

    public ClientInputHooks() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::OnKeyMappings);
        MinecraftForge.EVENT_BUS.addListener(this::OnClickInput);
        MinecraftForge.EVENT_BUS.addListener(this::OnClientTick);
        MinecraftForge.EVENT_BUS.addListener(this::OnUseItemTick);
    }

    public void OnKeyMappings(RegisterKeyMappingsEvent event) {
        event.register((KeyMapping)KeyMappings.LOOK_AT_MAPPING.get());
        event.register((KeyMapping)KeyMappings.MODE_TOGGLE_MAPPING.get());
        event.register((KeyMapping)KeyMappings.MANUAL_RELOAD_MAPPING.get());
        event.register((KeyMapping)KeyMappings.STRAFE_UP_MAPPING.get());
        event.register((KeyMapping)KeyMappings.STRAFE_DOWN_MAPPING.get());
        event.register((KeyMapping)KeyMappings.YAW_RIGHT_MAPPING.get());
        event.register((KeyMapping)KeyMappings.YAW_LEFT_MAPPING.get());
        event.register((KeyMapping)KeyMappings.PITCH_UP_MAPPING.get());
        event.register((KeyMapping)KeyMappings.PITCH_DOWN_MAPPING.get());
        event.register((KeyMapping)KeyMappings.ROLL_LEFT_MAPPING.get());
        event.register((KeyMapping)KeyMappings.ROLL_RIGHT_MAPPING.get());
    }

    public void OnClickInput(InputEvent.InteractionKeyMappingTriggered event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ItemStack stack = player.m_21120_(event.getHand());
        Item item = stack.m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
        }
    }

    public void OnUseItemTick(LivingEntityUseItemEvent.Tick event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Item item = event.getItem().m_41720_();
        if (item instanceof GunItem) {
            GunItem gun = (GunItem)item;
            gun.ClientUpdateUsing((Player)player, event.getItem(), event);
        }
    }

    private void ProcessPress(@Nonnull Player player, @Nonnull HoldableInput holdable, @Nonnull EPlayerInput input) {
        if (holdable.IsPressed()) {
            FlansModClient.ACTIONS_CLIENT.ClientKeyPressed(player, input);
        }
    }

    private void ProcessPressHoldRelease(@Nonnull Player player, @Nonnull HoldableInput holdable, @Nonnull EPlayerInput input) {
        if (holdable.IsPressed()) {
            FlansModClient.ACTIONS_CLIENT.ClientKeyPressed(player, input);
        }
        if (holdable.IsHeld()) {
            FlansModClient.ACTIONS_CLIENT.ClientKeyHeld(player, input);
        }
        if (holdable.IsReleased()) {
            FlansModClient.ACTIONS_CLIENT.ClientKeyReleased(player, input, holdable.TicksSinceToggled());
        }
    }

    public void OnClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Options options = Minecraft.m_91087_().f_91066_;
            Use.Tick(options.f_92095_.m_90857_());
            Attack.Tick(options.f_92096_.m_90857_());
            MoveForward.Tick(options.f_92085_.m_90857_());
            MoveBack.Tick(options.f_92087_.m_90857_());
            MoveLeft.Tick(options.f_92086_.m_90857_());
            MoveRight.Tick(options.f_92088_.m_90857_());
            Jump.Tick(options.f_92089_.m_90857_());
            Sneak.Tick(options.f_92090_.m_90857_());
            Sprint.Tick(options.f_92091_.m_90857_());
            YawLeft.Tick(((KeyMapping)KeyMappings.YAW_LEFT_MAPPING.get()).m_90857_());
            YawRight.Tick(((KeyMapping)KeyMappings.YAW_RIGHT_MAPPING.get()).m_90857_());
            PitchUp.Tick(((KeyMapping)KeyMappings.PITCH_UP_MAPPING.get()).m_90857_());
            PitchDown.Tick(((KeyMapping)KeyMappings.PITCH_DOWN_MAPPING.get()).m_90857_());
            RollLeft.Tick(((KeyMapping)KeyMappings.ROLL_LEFT_MAPPING.get()).m_90857_());
            RollRight.Tick(((KeyMapping)KeyMappings.ROLL_RIGHT_MAPPING.get()).m_90857_());
            LookAt.Tick(((KeyMapping)KeyMappings.LOOK_AT_MAPPING.get()).m_90857_());
            ModeToggle.Tick(((KeyMapping)KeyMappings.MODE_TOGGLE_MAPPING.get()).m_90857_());
            ManualReload.Tick(((KeyMapping)KeyMappings.MANUAL_RELOAD_MAPPING.get()).m_90857_());
            MoveUp.Tick(((KeyMapping)KeyMappings.STRAFE_UP_MAPPING.get()).m_90857_());
            MoveDown.Tick(((KeyMapping)KeyMappings.STRAFE_DOWN_MAPPING.get()).m_90857_());
            GearUp.Tick(((KeyMapping)KeyMappings.GEAR_UP_MAPPING.get()).m_90857_());
            GearDown.Tick(((KeyMapping)KeyMappings.GEAR_DOWN_MAPPING.get()).m_90857_());
            MouseYaw.Tick((KeyMappings.AxisMapping)KeyMappings.YAW_MOUSE_AXIS.get());
            MousePitch.Tick((KeyMappings.AxisMapping)KeyMappings.PITCH_MOUSE_AXIS.get());
            MouseRoll.Tick((KeyMappings.AxisMapping)KeyMappings.ROLL_MOUSE_AXIS.get());
            GamepadYaw.Tick((KeyMappings.AxisMapping)KeyMappings.YAW_GAMEPAD_AXIS.get());
            GamepadPitch.Tick((KeyMappings.AxisMapping)KeyMappings.PITCH_GAMEPAD_AXIS.get());
            GamepadRoll.Tick((KeyMappings.AxisMapping)KeyMappings.ROLL_GAMEPAD_AXIS.get());
            GamepadForward.Tick((KeyMappings.AxisMapping)KeyMappings.FORWARD_GAMEPAD_AXIS.get());
            GamepadRight.Tick((KeyMappings.AxisMapping)KeyMappings.STRAFE_RIGHT_GAMEPAD_AXIS.get());
            GamepadUp.Tick((KeyMappings.AxisMapping)KeyMappings.STRAFE_UP_GAMEPAD_AXIS.get());
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null) {
                this.ProcessPress((Player)player, LookAt, EPlayerInput.SpecialKey1);
                this.ProcessPress((Player)player, ModeToggle, EPlayerInput.SpecialKey2);
                this.ProcessPress((Player)player, ManualReload, EPlayerInput.Reload1);
                this.ProcessPress((Player)player, Jump, EPlayerInput.Jump);
                this.ProcessPress((Player)player, Sprint, EPlayerInput.Sprint);
                this.ProcessPress((Player)player, GearUp, EPlayerInput.GearUp);
                this.ProcessPress((Player)player, GearDown, EPlayerInput.GearDown);
                this.ProcessPressHoldRelease((Player)player, Attack, EPlayerInput.Fire1);
                this.ProcessPressHoldRelease((Player)player, Use, EPlayerInput.Fire2);
            }
        }
    }

    private static class HoldableInput {
        public boolean HeldThisFrame = false;
        public boolean HeldLastFrame = false;
        public int FramesSinceToggled = 0;

        private HoldableInput() {
        }

        public boolean IsPressed() {
            return this.HeldThisFrame && !this.HeldLastFrame;
        }

        public boolean IsHeld() {
            return this.HeldThisFrame;
        }

        public boolean IsReleased() {
            return !this.HeldThisFrame && this.HeldLastFrame;
        }

        public int TicksSinceToggled() {
            return this.FramesSinceToggled;
        }

        public void Tick(boolean pressed) {
            this.HeldLastFrame = this.HeldThisFrame;
            this.HeldThisFrame = pressed;
            this.FramesSinceToggled = this.HeldThisFrame != this.HeldLastFrame ? 0 : ++this.FramesSinceToggled;
        }
    }

    private static class HoldableAxis {
        public float Value = 0.0f;
        public boolean IsActive = false;
        public Lazy<GLFWGamepadState> GamepadState = Lazy.of(GLFWGamepadState::create);

        private HoldableAxis() {
        }

        public void Tick(@Nonnull KeyMappings.AxisMapping axis) {
            block0 : switch (axis.mappingType()) {
                case GamepadAxis: {
                    if (axis.axisID() >= 0 && GLFW.glfwGetGamepadState((int)0, (GLFWGamepadState)((GLFWGamepadState)this.GamepadState.get()))) {
                        this.IsActive = true;
                        this.Value = ((GLFWGamepadState)this.GamepadState.get()).axes(axis.axisID());
                        break;
                    }
                    this.IsActive = false;
                    this.Value = 0.0f;
                    break;
                }
                case MouseAxis: {
                    switch (axis.axisID()) {
                        case 0: {
                            this.IsActive = true;
                            this.Value = (float)Minecraft.m_91087_().f_91067_.getXVelocity();
                            break block0;
                        }
                        case 1: {
                            this.IsActive = true;
                            this.Value = (float)Minecraft.m_91087_().f_91067_.getYVelocity();
                            break block0;
                        }
                    }
                    this.IsActive = false;
                    this.Value = 0.0f;
                }
            }
        }
    }
}

